/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.v2.formats.ObjectFormatCache;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.index.generator.IndexTaskGenerator;
import org.dataone.cn.indexer.parser.IDocumentSubprocessor;
import org.dataone.cn.indexer.parser.utility.SeriesIdResolver;
import org.dataone.cn.indexer.solrhttp.HTTPService;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.SystemMetadata;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseReprocessSubprocessor
implements IDocumentSubprocessor {
    @Autowired
    private HTTPService httpService;
    @Autowired
    private String solrQueryUri;
    @Autowired
    private IndexTaskGenerator indexTaskGenerator;
    private List<String> matchDocuments = null;
    private List<String> relationFields;
    public static Log log = LogFactory.getLog(BaseReprocessSubprocessor.class);

    @Override
    public Map<String, SolrDoc> processDocument(String identifier, Map<String, SolrDoc> docs, InputStream is) throws Exception {
        Identifier id = new Identifier();
        id.setValue(identifier);
        SystemMetadata sysMeta = (SystemMetadata)HazelcastClientFactory.getSystemMetadataMap().get((Object)id);
        if (sysMeta == null) {
            return docs;
        }
        Identifier seriesId = sysMeta.getSeriesId();
        log.debug((Object)("seriesId===" + seriesId));
        if (seriesId != null) {
            log.debug((Object)("seriesId===" + seriesId.getValue()));
            List<SolrDoc> previousDocs = this.httpService.getDocumentsByField(this.solrQueryUri, Collections.singletonList(seriesId.getValue()), "seriesId", true);
            log.debug((Object)("previousDocs===" + previousDocs));
            if (previousDocs != null && !previousDocs.isEmpty()) {
                ArrayList<Identifier> pidsToProcess = new ArrayList<Identifier>();
                for (SolrDoc indexedDoc : previousDocs) {
                    log.debug((Object)("indexedDoc===" + indexedDoc));
                    for (String fieldName : this.relationFields) {
                        log.debug((Object)("fieldName===" + fieldName));
                        List<String> relationFieldValues = indexedDoc.getAllFieldValues(fieldName);
                        if (relationFieldValues == null) continue;
                        for (String relationFieldValue : relationFieldValues) {
                            Identifier relatedPid = new Identifier();
                            relatedPid.setValue(relationFieldValue);
                            if (SeriesIdResolver.isSeriesId(relatedPid)) {
                                try {
                                    relatedPid = SeriesIdResolver.getPid(relatedPid);
                                }
                                catch (BaseException be) {
                                    log.error((Object)("could not locate PID for given identifier: " + relatedPid.getValue()), (Throwable)be);
                                    continue;
                                }
                            }
                            if (pidsToProcess.contains(relatedPid)) continue;
                            log.debug((Object)("Processing relatedPid===" + relatedPid.getValue()));
                            pidsToProcess.add(relatedPid);
                            SystemMetadata relatedSysMeta = (SystemMetadata)HazelcastClientFactory.getSystemMetadataMap().get((Object)relatedPid);
                            String objectPath = (String)HazelcastClientFactory.getObjectPathMap().get((Object)relatedPid);
                            log.debug((Object)("Processing relatedSysMeta===" + relatedSysMeta));
                            log.debug((Object)("Processing objectPath===" + objectPath));
                            this.indexTaskGenerator.processSystemMetaDataUpdate(relatedSysMeta, objectPath);
                        }
                    }
                }
            }
        }
        return docs;
    }

    @Override
    public boolean canProcess(String formatId) {
        if (this.matchDocuments != null) {
            return this.matchDocuments.contains(formatId);
        }
        ObjectFormatIdentifier ofi = new ObjectFormatIdentifier();
        ofi.setValue(formatId);
        ObjectFormat objectFormat = null;
        try {
            objectFormat = ObjectFormatCache.getInstance().getFormat(ofi);
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        if (objectFormat != null) {
            return !objectFormat.getFormatType().equalsIgnoreCase("RESOURCE");
        }
        return true;
    }

    @Override
    public SolrDoc mergeWithIndexedDocument(SolrDoc indexDocument) throws IOException, EncoderException, XPathExpressionException {
        return indexDocument;
    }

    public List<String> getRelationFields() {
        return this.relationFields;
    }

    public void setRelationFields(List<String> relationFields) {
        this.relationFields = relationFields;
    }
}

