/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.solrhttp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.dataone.service.types.v2.SystemMetadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SolrDoc {
    public static final char[] ELEMENT_DOC_OPEN = "<doc>".toCharArray();
    public static final char[] ELEMENT_DOC_CLOSE = "</doc>".toCharArray();
    private List<SolrElementField> fieldList = new ArrayList<SolrElementField>();
    private String identifier;
    private String seriesId;
    private boolean merged = false;

    public SolrDoc() {
    }

    public SolrDoc(List<SolrElementField> fieldList) {
        this.fieldList = fieldList;
    }

    public List<SolrElementField> getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(List<SolrElementField> fieldList) {
        this.fieldList = fieldList;
    }

    public void serialize(OutputStream outputStream, String encoding) throws IOException {
        IOUtils.write((char[])ELEMENT_DOC_OPEN, (OutputStream)outputStream, (String)encoding);
        for (SolrElementField field : this.getFieldList()) {
            field.serialize(outputStream, encoding);
        }
        IOUtils.write((char[])ELEMENT_DOC_CLOSE, (OutputStream)outputStream, (String)encoding);
    }

    public boolean hasField(String fieldName) {
        for (SolrElementField field : this.fieldList) {
            if (!field.getName().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasFieldWithValue(String fieldName, String value) {
        for (SolrElementField field : this.fieldList) {
            if (field.getName() == null || !field.getName().equals(fieldName) || !field.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public SolrElementField getField(String fieldName) {
        SolrElementField searchField = null;
        for (SolrElementField field : this.fieldList) {
            if (!field.getName().equals(fieldName)) continue;
            searchField = field;
            break;
        }
        return searchField;
    }

    public void loadFromElement(Element docElement, List<String> validFields) {
        this.fieldList = new ArrayList<SolrElementField>();
        NodeList values = docElement.getChildNodes();
        for (int i = 0; i < values.getLength(); ++i) {
            Node n = values.item(i);
            if (n instanceof Text) continue;
            Element elementField = (Element)n;
            String tagName = elementField.getTagName();
            String fieldName = elementField.getAttribute("name");
            if (validFields != null && !validFields.contains(fieldName)) continue;
            if (tagName.equals("arr")) {
                NodeList arrayValues = elementField.getChildNodes();
                for (int j = 0; j < arrayValues.getLength(); ++j) {
                    Node nv = arrayValues.item(j);
                    if (nv instanceof Text) continue;
                    Node arrayValue = nv;
                    String valueString = arrayValue.getTextContent();
                    this.fieldList.add(new SolrElementField(fieldName, valueString));
                }
                continue;
            }
            if (this.hasField(fieldName)) continue;
            String valueString = elementField.getTextContent();
            this.fieldList.add(new SolrElementField(fieldName, valueString));
        }
    }

    public String getIdentifier() {
        if (this.identifier == null) {
            this.identifier = this.getFirstFieldValue("id");
        }
        return this.identifier;
    }

    public String getSeriesId() {
        if (this.seriesId == null) {
            this.seriesId = this.getFirstFieldValue("seriesId");
        }
        return this.seriesId;
    }

    public void addField(SolrElementField field) {
        this.getFieldList().add(field);
    }

    public void removeField(SolrElementField fieldToRemove) {
        if (fieldToRemove == null || fieldToRemove.getName() == null) {
            return;
        }
        SolrElementField temp = null;
        for (SolrElementField field : this.fieldList) {
            if (!field.getName().equals(fieldToRemove.getName())) continue;
            temp = field;
            break;
        }
        this.fieldList.remove(temp);
    }

    public void removeAllFields(String fieldName) {
        ArrayList<SolrElementField> fieldsToRemove = new ArrayList<SolrElementField>();
        for (SolrElementField field : this.fieldList) {
            if (!field.getName().equals(fieldName)) continue;
            fieldsToRemove.add(field);
        }
        this.fieldList.removeAll(fieldsToRemove);
    }

    public void removeFieldsWithValue(String name, String value) {
        ArrayList<SolrElementField> fieldsToRemove = new ArrayList<SolrElementField>();
        for (SolrElementField field : this.fieldList) {
            if (!field.getName().equals(name) || !field.getValue().equals(value)) continue;
            fieldsToRemove.add(field);
        }
        this.fieldList.removeAll(fieldsToRemove);
    }

    public void removeOneFieldWithValue(String name, String value) {
        ArrayList<SolrElementField> fieldsToRemove = new ArrayList<SolrElementField>();
        for (SolrElementField field : this.fieldList) {
            if (!field.getName().equals(name) || !field.getValue().equals(value)) continue;
            fieldsToRemove.add(field);
            break;
        }
        this.fieldList.removeAll(fieldsToRemove);
    }

    public String getFirstFieldValue(String fieldName) {
        for (SolrElementField field : this.fieldList) {
            if (!field.getName().equals(fieldName)) continue;
            return field.getValue();
        }
        return null;
    }

    public List<String> getAllFieldValues(String fieldName) {
        ArrayList<String> allValues = new ArrayList<String>();
        for (SolrElementField field : this.fieldList) {
            if (!field.getName().equals(fieldName)) continue;
            allValues.add(field.getValue());
        }
        return allValues;
    }

    public void updateOrAddField(String fieldName, String fieldValue) {
        for (SolrElementField solrElementField : this.fieldList) {
            if (!solrElementField.getName().equals(fieldName)) continue;
            solrElementField.setValue(fieldValue);
            return;
        }
        SolrElementField field = new SolrElementField(fieldName, fieldValue);
        this.fieldList.add(field);
    }

    public boolean isMerged() {
        return this.merged;
    }

    public void setMerged(boolean merged) {
        this.merged = merged;
    }

    public static boolean visibleInIndex(SystemMetadata smd) {
        if (smd == null) {
            return false;
        }
        return smd.getArchived() == null || smd.getArchived() == false;
    }
}

