/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.hazelcast;

import com.hazelcast.client.ClientConfig;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.config.ClasspathXmlConfig;
import com.hazelcast.config.Config;
import com.hazelcast.core.IMap;
import java.io.FileNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.hazelcast.ClientConfiguration;
import org.dataone.cn.hazelcast.HazelcastConfigLocationFactory;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Node;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v2.SystemMetadata;

public class HazelcastClientFactory {
    public static final Log logger = LogFactory.getLog(HazelcastClientFactory.class);
    private static final String HZ_SYSTEM_METADATA = Settings.getConfiguration().getString("dataone.hazelcast.systemMetadata");
    private static final String HZ_NODE_MAP = Settings.getConfiguration().getString("dataone.hazelcast.nodes");
    private static final String HZ_OBJECT_PATH = Settings.getConfiguration().getString("dataone.hazelcast.objectPath");
    private static HazelcastClient hzStorageClient = null;
    private static HazelcastClient hzProcessingClient = null;
    private static HazelcastClient hzSessionClient = null;

    private HazelcastClientFactory() {
    }

    public static IMap<Identifier, SystemMetadata> getSystemMetadataMap() {
        if (HazelcastClientFactory.getStorageClient() != null) {
            return HazelcastClientFactory.getStorageClient().getMap(HZ_SYSTEM_METADATA);
        }
        return null;
    }

    public static IMap<Identifier, String> getObjectPathMap() {
        if (HazelcastClientFactory.getStorageClient() != null) {
            return HazelcastClientFactory.getStorageClient().getMap(HZ_OBJECT_PATH);
        }
        return null;
    }

    public static IMap<NodeReference, Node> getNodeMap() {
        if (HazelcastClientFactory.getProcessingClient() != null) {
            return HazelcastClientFactory.getProcessingClient().getMap(HZ_NODE_MAP);
        }
        return null;
    }

    public static HazelcastClient getStorageClient() {
        if (hzStorageClient == null) {
            hzStorageClient = HazelcastClientFactory.getHazelcastClientUsingConfig(HazelcastConfigLocationFactory.getStorageConfigLocation());
        }
        return hzStorageClient;
    }

    public static HazelcastClient getProcessingClient() {
        if (hzProcessingClient == null) {
            String group = Settings.getConfiguration().getString("dataone.hazelcast.process.groupName");
            String password = Settings.getConfiguration().getString("dataone.hazelcast.process.groupPassword");
            String localhost = "127.0.0.1";
            String port = Settings.getConfiguration().getString("dataone.hazelcast.process.port");
            ClientConfig cc = new ClientConfig();
            cc.getGroupConfig().setName(group);
            cc.getGroupConfig().setPassword(password);
            cc.addAddress(new String[]{localhost + ":" + port});
            try {
                hzProcessingClient = HazelcastClient.newHazelcastClient((ClientConfig)cc);
            }
            catch (Exception e) {
                logger.error((Object)"Unable to create hazelcast client: ", (Throwable)e);
                e.printStackTrace();
            }
        }
        return hzProcessingClient;
    }

    public static HazelcastClient getSessionClient() {
        if (hzSessionClient == null) {
            hzSessionClient = HazelcastClientFactory.getHazelcastClientUsingConfig(HazelcastConfigLocationFactory.getSessionConfigLocation());
        }
        return hzSessionClient;
    }

    private static HazelcastClient getHazelcastClientUsingConfig(String configLocation) {
        ClientConfiguration clientConfiguration = null;
        try {
            if (configLocation != null) {
                if (configLocation.startsWith("classpath:")) {
                    String hzConfigLocationConfig = configLocation.replace("classpath:", "");
                    ClasspathXmlConfig config = new ClasspathXmlConfig(hzConfigLocationConfig);
                    clientConfiguration = new ClientConfiguration((Config)config);
                } else {
                    clientConfiguration = new ClientConfiguration(configLocation);
                }
            }
        }
        catch (FileNotFoundException ex) {
            throw new NullPointerException("FileNotFound so clientConfiguration is Null: " + ex.getMessage());
        }
        logger.info((Object)("group " + clientConfiguration.getGroup() + " addresses " + clientConfiguration.getLocalhost()));
        ClientConfig cc = new ClientConfig();
        cc.getGroupConfig().setName(clientConfiguration.getGroup());
        cc.getGroupConfig().setPassword(clientConfiguration.getPassword());
        cc.addAddress(new String[]{clientConfiguration.getLocalhost()});
        HazelcastClient client = null;
        try {
            client = HazelcastClient.newHazelcastClient((ClientConfig)cc);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to create hazelcast client: ", (Throwable)e);
            e.printStackTrace();
        }
        return client;
    }
}

