/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.ldap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamingListener;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.dataone.cn.ldap.D1UnsolicitedNotificationListener;
import org.dataone.configuration.Settings;

public abstract class LDAPService {
    public static Log log = LogFactory.getLog(LDAPService.class);
    protected DirContext context = null;
    protected String server = Settings.getConfiguration().getString("cn.ldap.server");
    protected String admin = Settings.getConfiguration().getString("cn.ldap.admin");
    protected String password = Settings.getConfiguration().getString("cn.ldap.password");
    protected String base = null;
    protected boolean useTLS = Boolean.parseBoolean(Settings.getConfiguration().getString("cn.ldap.useTLS"));

    public synchronized DirContext getContext() throws NamingException {
        if (this.context == null) {
            log.debug((Object)"context is null");
            if (this.useTLS) {
                try {
                    this.context = this.getSecureContext();
                }
                catch (Throwable e) {
                    log.error((Object)"Could not set up TLS connection, using non-secure communication", e);
                    this.context = this.getDefaultContext();
                }
            } else {
                this.context = this.getDefaultContext();
            }
            D1UnsolicitedNotificationListener d1Listener = new D1UnsolicitedNotificationListener(this);
            EventDirContext eventDirContext = (EventDirContext)this.context.lookup("");
            eventDirContext.addNamingListener("", 1, (NamingListener)d1Listener);
        }
        return this.context;
    }

    public synchronized void closeContext() {
        if (this.context != null) {
            try {
                this.context.close();
            }
            catch (Exception ex) {
                log.warn((Object)ex);
            }
        }
        this.context = null;
    }

    protected DirContext getDefaultContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.server);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.admin);
        env.put("java.naming.security.credentials", this.password);
        InitialDirContext ctx = new InitialDirContext(env);
        return ctx;
    }

    protected DirContext getSecureContext() throws NamingException, IOException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.server);
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        StartTlsResponse tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
        if (this.server.contains("localhost")) {
            tls.setHostnameVerifier((HostnameVerifier)new AllowAllHostnameVerifier());
        }
        SSLSession sess = tls.negotiate();
        ctx.addToEnvironment("java.naming.security.authentication", "simple");
        ctx.addToEnvironment("java.naming.security.principal", this.admin);
        ctx.addToEnvironment("java.naming.security.credentials", this.password);
        return ctx;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getAdmin() {
        return this.admin;
    }

    public void setAdmin(String admin) {
        this.admin = admin;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public abstract void setBase(String var1);

    public String getBase() {
        return this.base;
    }

    public boolean removeEntry(String dn) {
        try {
            DirContext ctx = this.getContext();
            ctx.destroySubcontext(new LdapName(dn));
            log.debug((Object)("Removed entry: " + dn));
        }
        catch (NamingException e) {
            log.error((Object)("Error removing entry: " + dn), (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean checkAttribute(String dn, String attributeName, String attributeValue) {
        try {
            boolean result;
            DirContext ctx = this.getContext();
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(0);
            ctls.setReturningAttributes(new String[0]);
            attributeValue = attributeValue.replace("\\", "\\5c");
            String searchCriteria = attributeName + "=" + attributeValue;
            NamingEnumeration<SearchResult> results = ctx.search((Name)new LdapName(dn), searchCriteria, ctls);
            boolean bl = result = results != null && results.hasMoreElements();
            if (result) {
                log.debug((Object)("Found matching attribute: " + searchCriteria));
            } else {
                log.warn((Object)("Did not find matching attribute: " + searchCriteria));
            }
            return result;
        }
        catch (NamingException e) {
            log.warn((Object)("Problem checking attribute: " + attributeName), (Throwable)e);
            return false;
        }
    }

    public List<Object> getAttributeValues(String dn, String attributeName) throws NamingException {
        DirContext ctx = this.getContext();
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(0);
        ctls.setReturningAttributes(new String[]{attributeName});
        String searchCriteria = attributeName + "=*";
        NamingEnumeration<SearchResult> results = ctx.search((Name)new LdapName(dn), searchCriteria, ctls);
        if (results != null) {
            log.debug((Object)("Found matching attribute: " + searchCriteria));
            ArrayList<Object> values = new ArrayList<Object>();
            while (results.hasMore()) {
                SearchResult result = results.next();
                NamingEnumeration<? extends Attribute> attributes = result.getAttributes().getAll();
                while (attributes.hasMore()) {
                    Object value = attributes.next().get();
                    values.add(value);
                }
            }
            return values;
        }
        return null;
    }

    protected String parseAttribute(String original, String attribute) {
        String result = null;
        try {
            String temp = original;
            int start = temp.toLowerCase().indexOf(attribute.toLowerCase() + "=");
            int end = temp.indexOf(",", start);
            temp = end < 0 ? temp.substring(start) : temp.substring(start, end);
            start = temp.indexOf("=") + 1;
            result = temp = temp.substring(start);
            result = (String)Rdn.unescapeValue(result);
        }
        catch (Exception e) {
            log.warn((Object)("could not parse attribute from string: " + original), (Throwable)e);
        }
        return result;
    }

    protected boolean constructTree(String dn) throws NamingException {
        LdapName ldapName = new LdapName(dn);
        List<Rdn> rdns = ldapName.getRdns();
        LdapName partialDn = null;
        for (int i = 0; i < rdns.size(); ++i) {
            Rdn rdn = rdns.get(i);
            if (partialDn == null) {
                partialDn = new LdapName(Arrays.asList(rdn));
            } else {
                partialDn.add(rdn);
            }
            boolean exists = false;
            try {
                exists = this.checkAttribute(partialDn.toString(), rdn.getType(), rdn.getValue().toString());
            }
            catch (Exception e) {
                exists = false;
            }
            if (exists) continue;
            String type = rdn.getType();
            if (type.equalsIgnoreCase("c")) {
                this.addCountry(partialDn.toString());
            }
            if (type.equalsIgnoreCase("o")) {
                this.addOrg(partialDn.toString());
            }
            if (type.equalsIgnoreCase("ou")) {
                this.addOrgUnit(partialDn.toString());
            }
            if (!type.equalsIgnoreCase("dc")) continue;
            this.addDc(partialDn.toString());
        }
        return true;
    }

    protected boolean addOrg(String dn) throws NamingException {
        BasicAttribute objClasses = new BasicAttribute("objectclass");
        objClasses.add("organization");
        String org = this.parseAttribute(dn, "o");
        BasicAttribute oAttribute = new BasicAttribute("o", org);
        DirContext ctx = this.getContext();
        BasicAttributes orig = new BasicAttributes();
        orig.put(objClasses);
        orig.put(oAttribute);
        ctx.createSubcontext(dn, (Attributes)orig);
        log.debug((Object)("Added entry " + dn));
        return true;
    }

    protected boolean addOrgUnit(String dn) throws NamingException {
        BasicAttribute objClasses = new BasicAttribute("objectclass");
        objClasses.add("organizationalUnit");
        String orgUnit = this.parseAttribute(dn, "ou");
        BasicAttribute oAttribute = new BasicAttribute("ou", orgUnit);
        DirContext ctx = this.getContext();
        BasicAttributes orig = new BasicAttributes();
        orig.put(objClasses);
        orig.put(oAttribute);
        ctx.createSubcontext(dn, (Attributes)orig);
        log.debug((Object)("Added entry " + dn));
        return true;
    }

    protected boolean addDc(String dn) throws NamingException {
        BasicAttribute objClasses = new BasicAttribute("objectclass");
        objClasses.add("dcObject");
        objClasses.add("organization");
        String dc = this.parseAttribute(dn, "dc");
        BasicAttribute dcAttribute = new BasicAttribute("dc", dc);
        BasicAttribute oAttribute = new BasicAttribute("o", dc);
        DirContext ctx = this.getContext();
        BasicAttributes orig = new BasicAttributes();
        orig.put(objClasses);
        orig.put(dcAttribute);
        orig.put(oAttribute);
        ctx.createSubcontext(dn, (Attributes)orig);
        log.debug((Object)("Added entry " + dn));
        return true;
    }

    protected boolean addCountry(String dn) throws NamingException {
        BasicAttribute objClasses = new BasicAttribute("objectclass");
        objClasses.add("country");
        String country = this.parseAttribute(dn, "c");
        BasicAttribute cAttribute = new BasicAttribute("c", country);
        DirContext ctx = this.getContext();
        BasicAttributes orig = new BasicAttributes();
        orig.put(objClasses);
        orig.put(cAttribute);
        ctx.createSubcontext(dn, (Attributes)orig);
        log.debug((Object)("Added entry " + dn));
        return true;
    }

    public String getEnumerationValueString(NamingEnumeration namingEnum) throws NamingException {
        if (namingEnum.hasMore()) {
            return (String)namingEnum.next();
        }
        return "";
    }
}

