/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;
import org.apache.lucene.util.LuceneTestCase;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _TestUtil {
    private static final int[] blockStarts = new int[]{0, 128, 256, 384, 592, 688, 768, 880, 1024, 1280, 1328, 1424, 1536, 1792, 1872, 1920, 1984, 2048, 2304, 2432, 2560, 2688, 2816, 2944, 3072, 3200, 3328, 3456, 3584, 3712, 3840, 4096, 4256, 4352, 4608, 4992, 5024, 5120, 5760, 5792, 5888, 5920, 5952, 5984, 6016, 6144, 6320, 6400, 6480, 6528, 6624, 6656, 6688, 6912, 7040, 7168, 7248, 7376, 7424, 7552, 7616, 7680, 7936, 8192, 8304, 8352, 8400, 8448, 8528, 8592, 8704, 8960, 9216, 9280, 9312, 9472, 9600, 9632, 9728, 9984, 10176, 10224, 10240, 10496, 10624, 10752, 11008, 11264, 11360, 11392, 11520, 11568, 11648, 11744, 11776, 11904, 12032, 12272, 12288, 12352, 12448, 12544, 12592, 12688, 12704, 12736, 12784, 12800, 13056, 13312, 19904, 19968, 40960, 42128, 42192, 42240, 42560, 42656, 42752, 42784, 43008, 43056, 43072, 43136, 43232, 43264, 43312, 43360, 43392, 43520, 43616, 43648, 43968, 44032, 55216, 57344, 63744, 64256, 64336, 65024, 65040, 65056, 65072, 65104, 65136, 65280, 65520, 65536, 65664, 65792, 65856, 65936, 66000, 66176, 66208, 66304, 66352, 66432, 66464, 66560, 66640, 66688, 67584, 67648, 67840, 67872, 68096, 68192, 68352, 68416, 68448, 68608, 69216, 69760, 73728, 74752, 77824, 118784, 119040, 119296, 119552, 119648, 119808, 126976, 127024, 127232, 127488, 131072, 173824, 194560, 917504, 917760, 983040, 0x100000};
    private static final int[] blockEnds = new int[]{127, 255, 383, 591, 687, 767, 879, 1023, 1279, 1327, 1423, 1535, 1791, 1871, 1919, 1983, 2047, 2111, 2431, 2559, 2687, 2815, 2943, 3071, 3199, 3327, 3455, 3583, 3711, 3839, 4095, 4255, 4351, 4607, 4991, 5023, 5119, 5759, 5791, 5887, 5919, 5951, 5983, 6015, 6143, 6319, 6399, 6479, 6527, 6623, 6655, 6687, 6831, 7039, 7103, 7247, 7295, 7423, 7551, 7615, 7679, 7935, 8191, 8303, 8351, 8399, 8447, 8527, 8591, 8703, 8959, 9215, 9279, 9311, 9471, 9599, 9631, 9727, 9983, 10175, 10223, 10239, 10495, 10623, 10751, 11007, 11263, 11359, 11391, 11519, 11567, 11647, 11743, 11775, 11903, 12031, 12255, 12287, 12351, 12447, 12543, 12591, 12687, 12703, 12735, 12783, 12799, 13055, 13311, 19903, 19967, 40959, 42127, 42191, 42239, 42559, 42655, 42751, 42783, 43007, 43055, 43071, 43135, 43231, 43263, 43311, 43359, 43391, 43487, 43615, 43647, 43743, 44031, 55215, 55295, 63743, 64255, 64335, 65023, 65039, 65055, 65071, 65103, 65135, 65279, 65519, 65534, 65663, 65791, 65855, 65935, 65999, 66047, 66207, 66271, 66351, 66383, 66463, 66527, 66639, 66687, 66735, 67647, 67679, 67871, 67903, 68191, 68223, 68415, 68447, 68479, 68687, 69247, 69839, 74751, 74879, 78895, 119039, 119295, 119375, 119647, 119679, 120831, 127023, 127135, 127487, 127743, 173791, 177983, 195103, 917631, 917999, 1048575, 0x10FFFF};
    private static int counter = 0;
    private static int counterBase = 0;
    private static TempFileLocker tempFileLocker = new TempFileLocker();

    public static File getTempDir(String desc) {
        try {
            File f = _TestUtil.createTempFile(desc, "tmp", LuceneTestCase.TEMP_DIR);
            f.delete();
            LuceneTestCase.registerTempFile(f);
            return f;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void rmDir(File dir) throws IOException {
        if (dir.exists()) {
            for (File f : dir.listFiles()) {
                if (f.isDirectory()) {
                    _TestUtil.rmDir(f);
                    continue;
                }
                if (f.delete()) continue;
                throw new IOException("could not delete " + f);
            }
            if (!dir.delete()) {
                throw new IOException("could not delete " + dir);
            }
        }
    }

    public static void unzip(File zipName, File destDir) throws IOException {
        ZipFile zipFile = new ZipFile(zipName);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        _TestUtil.rmDir(destDir);
        destDir.mkdir();
        LuceneTestCase.registerTempFile(destDir);
        while (entries.hasMoreElements()) {
            int len;
            ZipEntry entry = entries.nextElement();
            InputStream in = zipFile.getInputStream(entry);
            File targetFile = new File(destDir, entry.getName());
            if (entry.isDirectory()) {
                targetFile.mkdirs();
                continue;
            }
            if (targetFile.getParentFile() != null) {
                targetFile.getParentFile().mkdirs();
            }
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFile));
            byte[] buffer = new byte[8192];
            while ((len = in.read(buffer)) >= 0) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
        }
        zipFile.close();
    }

    public static void syncConcurrentMerges(IndexWriter writer) {
        _TestUtil.syncConcurrentMerges(writer.getConfig().getMergeScheduler());
    }

    public static void syncConcurrentMerges(MergeScheduler ms) {
        if (ms instanceof ConcurrentMergeScheduler) {
            ((ConcurrentMergeScheduler)ms).sync();
        }
    }

    public static CheckIndex.Status checkIndex(Directory dir) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        CheckIndex checker = new CheckIndex(dir);
        checker.setInfoStream(new PrintStream(bos));
        CheckIndex.Status indexStatus = checker.checkIndex();
        if (indexStatus == null || !indexStatus.clean) {
            System.out.println("CheckIndex failed");
            System.out.println(bos.toString());
            throw new RuntimeException("CheckIndex failed");
        }
        return indexStatus;
    }

    @Deprecated
    public static String arrayToString(int[] array) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(array[i]);
        }
        buf.append("]");
        return buf.toString();
    }

    @Deprecated
    public static String arrayToString(Object[] array) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(array[i]);
        }
        buf.append("]");
        return buf.toString();
    }

    public static String randomSimpleString(Random r) {
        int end = r.nextInt(10);
        if (end == 0) {
            return "";
        }
        char[] buffer = new char[end];
        for (int i = 0; i < end; ++i) {
            buffer[i] = (char)_TestUtil.nextInt(r, 97, 102);
        }
        return new String(buffer, 0, end);
    }

    public static String randomUnicodeString(Random r) {
        return _TestUtil.randomUnicodeString(r, 20);
    }

    public static String randomUnicodeString(Random r, int maxLength) {
        int end = r.nextInt(maxLength);
        if (end == 0) {
            return "";
        }
        char[] buffer = new char[end];
        _TestUtil.randomFixedLengthUnicodeString(r, buffer, 0, buffer.length);
        return new String(buffer, 0, end);
    }

    public static void randomFixedLengthUnicodeString(Random random, char[] chars, int offset, int length) {
        int i = offset;
        int end = offset + length;
        while (i < end) {
            int t = random.nextInt(5);
            if (0 == t && i < length - 1) {
                chars[i++] = (char)_TestUtil.nextInt(random, 55296, 56319);
                chars[i++] = (char)_TestUtil.nextInt(random, 56320, 57343);
                continue;
            }
            if (t <= 1) {
                chars[i++] = (char)random.nextInt(128);
                continue;
            }
            if (2 == t) {
                chars[i++] = (char)_TestUtil.nextInt(random, 128, 2047);
                continue;
            }
            if (3 == t) {
                chars[i++] = (char)_TestUtil.nextInt(random, 2048, 55295);
                continue;
            }
            if (4 != t) continue;
            chars[i++] = (char)_TestUtil.nextInt(random, 57344, 65534);
        }
    }

    public static String randomRealisticUnicodeString(Random r) {
        return _TestUtil.randomRealisticUnicodeString(r, 20);
    }

    public static String randomRealisticUnicodeString(Random r, int maxLength) {
        return _TestUtil.randomRealisticUnicodeString(r, 0, 20);
    }

    public static String randomRealisticUnicodeString(Random r, int minLength, int maxLength) {
        int end = minLength + r.nextInt(maxLength);
        int block = r.nextInt(blockStarts.length);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < end; ++i) {
            sb.appendCodePoint(_TestUtil.nextInt(r, blockStarts[block], blockEnds[block]));
        }
        return sb.toString();
    }

    public static String randomFixedByteLengthUnicodeString(Random r, int length) {
        int i;
        char[] buffer = new char[length * 3];
        int bytes = length;
        for (i = 0; i < buffer.length && bytes != 0; ++i) {
            int t = bytes >= 4 ? r.nextInt(5) : (bytes >= 3 ? r.nextInt(4) : (bytes >= 2 ? r.nextInt(2) : 0));
            if (t == 0) {
                buffer[i] = (char)r.nextInt(128);
                --bytes;
                continue;
            }
            if (1 == t) {
                buffer[i] = (char)_TestUtil.nextInt(r, 128, 2047);
                bytes -= 2;
                continue;
            }
            if (2 == t) {
                buffer[i] = (char)_TestUtil.nextInt(r, 2048, 55295);
                bytes -= 3;
                continue;
            }
            if (3 == t) {
                buffer[i] = (char)_TestUtil.nextInt(r, 57344, 65534);
                bytes -= 3;
                continue;
            }
            if (4 != t) continue;
            buffer[i++] = (char)_TestUtil.nextInt(r, 55296, 56319);
            buffer[i] = (char)_TestUtil.nextInt(r, 56320, 57343);
            bytes -= 4;
        }
        return new String(buffer, 0, i);
    }

    public static int nextInt(Random r, int start, int end) {
        return start + r.nextInt(end - start + 1);
    }

    public static boolean anyFilesExceptWriteLock(Directory dir) throws IOException {
        String[] files = dir.listAll();
        return files.length > 1 || files.length == 1 && !files[0].equals("write.lock");
    }

    public static void reduceOpenFiles(IndexWriter w) {
        MergePolicy mp = w.getConfig().getMergePolicy();
        if (mp instanceof LogMergePolicy) {
            LogMergePolicy lmp = (LogMergePolicy)mp;
            lmp.setMergeFactor(Math.min(5, lmp.getMergeFactor()));
        } else if (mp instanceof TieredMergePolicy) {
            TieredMergePolicy tmp = (TieredMergePolicy)mp;
            tmp.setMaxMergeAtOnce(Math.min(5, tmp.getMaxMergeAtOnce()));
            tmp.setSegmentsPerTier(Math.min(5.0, tmp.getSegmentsPerTier()));
        }
        MergeScheduler ms = w.getConfig().getMergeScheduler();
        if (ms instanceof ConcurrentMergeScheduler) {
            ((ConcurrentMergeScheduler)ms).setMaxThreadCount(2);
            ((ConcurrentMergeScheduler)ms).setMaxMergeCount(3);
        }
    }

    public static <T> void assertAttributeReflection(AttributeImpl att, Map<String, T> reflectedValues) {
        final HashMap map = new HashMap();
        att.reflectWith(new AttributeReflector(){

            public void reflect(Class<? extends Attribute> attClass, String key, Object value) {
                map.put(attClass.getName() + '#' + key, value);
            }
        });
        Assert.assertEquals((String)"Reflection does not produce same map", reflectedValues, map);
    }

    public static void keepFullyDeletedSegments(IndexWriter w) {
        try {
            Method m = IndexWriter.class.getDeclaredMethod("keepFullyDeletedSegments", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)w, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        File result;
        String newSuffix;
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("prefix must be 3");
        }
        String string = newSuffix = suffix == null ? ".tmp" : suffix;
        while (!(result = _TestUtil.genTempFile(prefix, newSuffix, directory)).createNewFile()) {
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File genTempFile(String prefix, String suffix, File directory) {
        int identify = 0;
        TempFileLocker tempFileLocker = _TestUtil.tempFileLocker;
        synchronized (tempFileLocker) {
            if (counter == 0) {
                int newInt = new Random().nextInt();
                counterBase = counter = (newInt / 65535 & 0xFFFF) + 10000;
            }
            identify = counter++;
        }
        StringBuilder newName = new StringBuilder();
        newName.append(prefix);
        newName.append(counterBase);
        newName.append(identify);
        newName.append(suffix);
        return new File(directory, newName.toString());
    }

    public static void assertEquals(TopDocs expected, TopDocs actual) {
        Assert.assertEquals((String)"wrong total hits", (long)expected.totalHits, (long)actual.totalHits);
        Assert.assertEquals((String)"wrong maxScore", (double)expected.getMaxScore(), (double)actual.getMaxScore(), (double)0.0);
        Assert.assertEquals((String)"wrong hit count", (long)expected.scoreDocs.length, (long)actual.scoreDocs.length);
        for (int hitIDX = 0; hitIDX < expected.scoreDocs.length; ++hitIDX) {
            ScoreDoc expectedSD = expected.scoreDocs[hitIDX];
            ScoreDoc actualSD = actual.scoreDocs[hitIDX];
            Assert.assertEquals((String)"wrong hit docID", (long)expectedSD.doc, (long)actualSD.doc);
            Assert.assertEquals((String)"wrong hit score", (double)expectedSD.score, (double)actualSD.score, (double)0.0);
            if (expectedSD instanceof FieldDoc) {
                Assert.assertTrue((boolean)(actualSD instanceof FieldDoc));
                Assert.assertEquals((String)"wrong sort field values", (Object[])((FieldDoc)expectedSD).fields, (Object[])((FieldDoc)actualSD).fields);
                continue;
            }
            Assert.assertFalse((boolean)(actualSD instanceof FieldDoc));
        }
    }

    public static Document cloneDocument(Document doc1) {
        Document doc2 = new Document();
        for (Fieldable f : doc1.getFields()) {
            Field field1 = (Field)f;
            Field field2 = new Field(field1.name(), field1.stringValue(), field1.isStored() ? Field.Store.YES : Field.Store.NO, field1.isIndexed() ? (field1.isTokenized() ? Field.Index.ANALYZED : Field.Index.NOT_ANALYZED) : Field.Index.NO);
            field2.setOmitNorms(field1.getOmitNorms());
            field2.setIndexOptions(field1.getIndexOptions());
            doc2.add((Fieldable)field2);
        }
        return doc2;
    }

    private static class TempFileLocker {
        private TempFileLocker() {
        }
    }
}

