/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.index.generator;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IMap;
import org.apache.log4j.Logger;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.index.generator.IndexTaskGenerator;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.SystemMetadata;
import org.springframework.beans.factory.annotation.Autowired;

public class IndexTaskGeneratorEntryListener
implements EntryListener<Identifier, SystemMetadata> {
    private static Logger logger = Logger.getLogger((String)IndexTaskGeneratorEntryListener.class.getName());
    @Autowired
    private IndexTaskGenerator generator;
    private IMap<Identifier, SystemMetadata> systemMetadata;
    private IMap<Identifier, String> objectPaths;

    public void start() {
        logger.info((Object)"starting index task generator entry listener...");
        this.systemMetadata = HazelcastClientFactory.getSystemMetadataMap();
        this.objectPaths = HazelcastClientFactory.getObjectPathMap();
        this.systemMetadata.addEntryListener((EntryListener)this, true);
        logger.info((Object)("System Metadata size: " + this.systemMetadata.size()));
        logger.info((Object)("Object path size:" + this.objectPaths.size()));
    }

    public void stop() {
        logger.info((Object)"stopping index task generator entry listener...");
        this.systemMetadata.removeEntryListener((EntryListener)this);
    }

    public void entryUpdated(EntryEvent<Identifier, SystemMetadata> event) {
        logger.info((Object)("UPDATE EVENT - index task generator - system metadata callback invoked on pid: " + ((Identifier)event.getKey()).getValue()));
        this.generator.processSystemMetaDataUpdate((SystemMetadata)event.getValue(), this.getObjectPath(event));
    }

    public void entryAdded(EntryEvent<Identifier, SystemMetadata> event) {
        if (event.getKey() != null && event.getValue() != null) {
            logger.info((Object)("ADD EVENT - index task generator - system metadata callback invoked on pid: " + ((Identifier)event.getKey()).getValue()));
            SystemMetadata smd = (SystemMetadata)event.getValue();
            if (smd.getSerialVersion().longValue() > 1L) {
                logger.info((Object)("Add event for pid: " + ((Identifier)event.getKey()).getValue() + " determined to be invalid due to serial version: " + smd.getSerialVersion().longValue() + ".  skipping add index task."));
            } else {
                logger.info((Object)("Processing add event index task for pid: " + ((Identifier)event.getKey()).getValue()));
                this.generator.processSystemMetaDataAdd((SystemMetadata)event.getValue(), this.getObjectPath(event));
            }
        }
    }

    private String getObjectPath(EntryEvent<Identifier, SystemMetadata> event) {
        return (String)this.objectPaths.get(event.getKey());
    }

    public void entryEvicted(EntryEvent<Identifier, SystemMetadata> arg0) {
    }

    public void entryRemoved(EntryEvent<Identifier, SystemMetadata> event) {
        logger.info((Object)("REMOVE EVENT - index task generator - system metadata callback invoked on pid: " + ((Identifier)event.getKey()).getValue()));
        this.generator.processSystemMetaDataDelete((SystemMetadata)event.getValue());
    }
}

