/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.rest;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Observable;
import java.util.Observer;
import org.apache.http.client.HttpClient;
import org.dataone.client.auth.CertificateManager;
import org.dataone.client.exception.ClientSideException;
import org.dataone.client.rest.HttpMultipartRestClient;
import org.dataone.client.utils.HttpUtils;
import org.jibx.runtime.JiBXException;

public class DefaultHttpMultipartRestClient
extends HttpMultipartRestClient
implements Observer {
    public DefaultHttpMultipartRestClient() throws IOException, ClientSideException {
        super((String)null);
        this.observeCertificateManager();
    }

    protected void observeCertificateManager() {
        CertificateManager.getInstance().addObserver(this);
    }

    @Override
    public void update(Observable observable, Object arg) {
        if (observable instanceof CertificateManager) {
            try {
                this.x509Session = ((CertificateManager)observable).selectSession(null);
                HttpClient hc = this.rc.getHttpClient();
                this.rc.setHttpClient(HttpUtils.createHttpClient(this.x509Session));
            }
            catch (IOException | IllegalAccessException | InstantiationException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | JiBXException e) {
                log.error((Object)"Could not update the HttpClient with new default information from CertificateManager!", e);
            }
        } else {
            log.debug((Object)("Observer.update did not receive an Observable of the right type! Got a: " + observable.getClass().getCanonicalName()));
        }
    }
}

