/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.rest;

import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.dataone.mimemultipart.SimpleMultipartEntity;

public class RestClient {
    protected static Log log = LogFactory.getLog(RestClient.class);
    protected HttpClient httpClient;
    protected HashMap<String, String> headers = new HashMap();
    private String latestRequestUrl = null;

    public RestClient(HttpClient client) {
        this.httpClient = client;
    }

    public String getLatestRequestUrl() {
        return this.latestRequestUrl;
    }

    private void setLatestRequestUrl(String value) {
        this.latestRequestUrl = value;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public HashMap<String, String> getAddedHeaders() {
        return this.headers;
    }

    public void clearAddedHeaders() {
        this.headers.clear();
    }

    public HttpResponse doGetRequest(String url, RequestConfig requestConfig) throws ClientProtocolException, IOException {
        return this.doRequestNoBody(url, "GET", requestConfig);
    }

    public HttpResponse doHeadRequest(String url, RequestConfig requestConfig) throws ClientProtocolException, IOException {
        return this.doRequestNoBody(url, "HEAD", requestConfig);
    }

    public HttpResponse doDeleteRequest(String url, RequestConfig requestConfig) throws ClientProtocolException, IOException {
        return this.doRequestNoBody(url, "DELETE", requestConfig);
    }

    public HttpResponse doPostRequest(String url, SimpleMultipartEntity mpe, RequestConfig requestConfig) throws ClientProtocolException, IOException {
        return this.doRequestMMBody(url, "POST", mpe, requestConfig);
    }

    public HttpResponse doPutRequest(String url, SimpleMultipartEntity mpe, RequestConfig requestConfig) throws ClientProtocolException, IOException {
        return this.doRequestMMBody(url, "PUT", mpe, requestConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized HttpResponse doRequestNoBody(String url, String httpMethod, RequestConfig requestConfig) throws ClientProtocolException, IOException {
        String latestCall = httpMethod + " " + url;
        HttpResponse response = null;
        try {
            HttpGet req = null;
            if (httpMethod == "GET") {
                req = new HttpGet(url);
            } else if (httpMethod == "HEAD") {
                req = new HttpHead(url);
            } else if (httpMethod == "DELETE") {
                req = new HttpDelete(url);
            } else {
                throw new ClientProtocolException("method requested not defined: " + httpMethod);
            }
            req.setConfig(requestConfig);
            response = this.doRequest((HttpUriRequest)req);
        }
        finally {
            this.setLatestRequestUrl(latestCall);
            log.info((Object)("rest call info: " + latestCall));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized HttpResponse doRequestMMBody(String url, String httpMethod, SimpleMultipartEntity mpe, RequestConfig requestConfig) throws ClientProtocolException, IOException {
        String latestCall = httpMethod + " " + url;
        HttpResponse response = null;
        try {
            HttpPut req = null;
            if (httpMethod == "PUT") {
                req = new HttpPut(url);
            } else if (httpMethod == "POST") {
                req = new HttpPost(url);
            } else {
                throw new ClientProtocolException("method requested not defined: " + httpMethod);
            }
            if (mpe != null) {
                req.setEntity((HttpEntity)mpe);
                latestCall = latestCall + "; MMP message has: " + mpe.getDescription();
            } else {
                latestCall = latestCall + "; MMP entity is null";
            }
            if (requestConfig != null) {
                req.setConfig(requestConfig);
            }
            response = this.doRequest((HttpUriRequest)req);
        }
        finally {
            this.setLatestRequestUrl(latestCall);
            log.info((Object)("rest call info: " + latestCall));
            if (mpe != null && !mpe.cleanupTempFiles()) {
                log.warn((Object)("failed to clean up temp files for: " + httpMethod + " " + url));
            }
        }
        return response;
    }

    private HttpResponse doRequest(HttpUriRequest req) throws ClientProtocolException, IOException {
        for (String n : this.headers.keySet()) {
            req.setHeader(n, this.headers.get(n));
        }
        return this.httpClient.execute(req);
    }
}

