/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.utils;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;
import org.dataone.client.auth.CertificateManager;
import org.dataone.client.auth.X509Session;
import org.jibx.runtime.JiBXException;

public class HttpUtils {
    private static Logger logger = Logger.getLogger((String)HttpUtils.class.getName());
    public static final String SCHEME_NAME = "https";
    public static final int MAX_CONNECTIONS_PER_ROUTE = 8;
    public static final int MAX_CONNECTIONS = 160;

    public static void setupSSL_v4_1(AbstractHttpClient httpClient, X509Session x509Session) {
        SchemeRegistry schemeReg = httpClient.getConnectionManager().getSchemeRegistry();
        if (schemeReg.getScheme(SCHEME_NAME) == null) {
            SSLSocketFactory socketFactory = null;
            try {
                socketFactory = CertificateManager.getInstance().getSSLSocketFactory(x509Session);
            }
            catch (Exception e) {
                logger.warn((Object)("Exception from CertificateManager at SSL setup - client will be anonymous: " + e.getClass() + ":: " + e.getMessage()));
            }
            try {
                Scheme sch = new Scheme(SCHEME_NAME, 443, (SchemeSocketFactory)socketFactory);
                httpClient.getConnectionManager().getSchemeRegistry().register(sch);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to set up SSL connection for client. Continuing. " + e.getClass() + ":: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static HttpClient createHttpClient(X509Session x509session) throws UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, InstantiationException, IllegalAccessException, IOException, JiBXException {
        return HttpUtils.getHttpClientBuilder(x509session).build();
    }

    public static HttpClientBuilder getHttpClientBuilder(X509Session x509session) throws UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, InstantiationException, IllegalAccessException, IOException, JiBXException {
        PoolingHttpClientConnectionManager connMan = new PoolingHttpClientConnectionManager(HttpUtils.buildConnectionRegistry(x509session));
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connMan).setMaxConnPerRoute(8).setMaxConnTotal(160);
    }

    public static HttpClient createHttpClient(String authToken) {
        return HttpUtils.getHttpClientBuilder(authToken).build();
    }

    public static HttpClientBuilder getHttpClientBuilder(final String authToken) {
        PoolingHttpClientConnectionManager connMan = new PoolingHttpClientConnectionManager(HttpUtils.buildConnectionRegistry());
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connMan).setMaxConnPerRoute(8).setMaxConnTotal(160).addInterceptorLast(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                request.addHeader("Authorization", "Bearer " + authToken);
            }
        });
    }

    public static X509Session selectSession(String subjectString) throws IOException {
        return CertificateManager.getInstance().selectSession(subjectString);
    }

    public static Registry<ConnectionSocketFactory> buildConnectionRegistry(X509Session x509Session) throws UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        RegistryBuilder rb = RegistryBuilder.create();
        rb.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        SSLConnectionSocketFactory sslSocketFactory = null;
        sslSocketFactory = CertificateManager.getInstance().getSSLConnectionSocketFactory(x509Session);
        rb.register(SCHEME_NAME, (Object)sslSocketFactory);
        Registry sfRegistry = rb.build();
        return sfRegistry;
    }

    public static Registry<ConnectionSocketFactory> buildConnectionRegistry() {
        RegistryBuilder rb = RegistryBuilder.create();
        rb.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        SSLConnectionSocketFactory sslSocketFactory = null;
        sslSocketFactory = SSLConnectionSocketFactory.getSocketFactory();
        rb.register(SCHEME_NAME, (Object)sslSocketFactory);
        Registry sfRegistry = rb.build();
        return sfRegistry;
    }
}

