/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.datatype;

import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.TypeIncubator;
import com.sun.msv.datatype.xsd.XSDatatype;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.datatype.DatatypeDocumentFactory;
import org.dom4j.datatype.DatatypeElementFactory;
import org.dom4j.datatype.InvalidSchemaException;
import org.dom4j.datatype.NamedTypeResolver;
import org.dom4j.io.SAXReader;
import org.dom4j.util.AttributeHelper;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class SchemaParser {
    private static final Namespace XSD_NAMESPACE = Namespace.get("xsd", "http://www.w3.org/2001/XMLSchema");
    private static final QName XSD_ELEMENT = QName.get("element", XSD_NAMESPACE);
    private static final QName XSD_ATTRIBUTE = QName.get("attribute", XSD_NAMESPACE);
    private static final QName XSD_SIMPLETYPE = QName.get("simpleType", XSD_NAMESPACE);
    private static final QName XSD_COMPLEXTYPE = QName.get("complexType", XSD_NAMESPACE);
    private static final QName XSD_RESTRICTION = QName.get("restriction", XSD_NAMESPACE);
    private static final QName XSD_SEQUENCE = QName.get("sequence", XSD_NAMESPACE);
    private static final QName XSD_CHOICE = QName.get("choice", XSD_NAMESPACE);
    private static final QName XSD_ALL = QName.get("all", XSD_NAMESPACE);
    private static final QName XSD_INCLUDE = QName.get("include", XSD_NAMESPACE);
    private DatatypeDocumentFactory documentFactory;
    private Map dataTypeCache = new HashMap();
    private NamedTypeResolver namedTypeResolver;

    public SchemaParser() {
        this(DatatypeDocumentFactory.singleton);
    }

    public SchemaParser(DatatypeDocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
        this.namedTypeResolver = new NamedTypeResolver(documentFactory);
    }

    public void build(Document schemaDocument) {
        Element root = schemaDocument.getRootElement();
        if (root != null) {
            Iterator includeIter = root.elementIterator(XSD_INCLUDE);
            while (includeIter.hasNext()) {
                Element includeElement = (Element)includeIter.next();
                String inclSchemaInstanceURI = includeElement.attributeValue("schemaLocation");
                EntityResolver resolver = schemaDocument.getEntityResolver();
                try {
                    if (resolver == null) {
                        throw new InvalidSchemaException("No EntityResolver available so could not resolve the schema URI: " + inclSchemaInstanceURI);
                    }
                    InputSource inputSource = resolver.resolveEntity(null, inclSchemaInstanceURI);
                    if (inputSource == null) {
                        throw new InvalidSchemaException("Could not resolve the schema URI: " + inclSchemaInstanceURI);
                    }
                    SAXReader reader = new SAXReader();
                    Document inclSchemaDocument = reader.read(inputSource);
                    this.build(inclSchemaDocument);
                }
                catch (Exception e) {
                    System.out.println("Failed to load schema: " + inclSchemaInstanceURI);
                    System.out.println("Caught: " + e);
                    e.printStackTrace();
                    throw new InvalidSchemaException("Failed to load schema: " + inclSchemaInstanceURI);
                }
            }
            Iterator iter = root.elementIterator(XSD_ELEMENT);
            while (iter.hasNext()) {
                this.onDatatypeElement((Element)iter.next(), this.documentFactory);
            }
            iter = root.elementIterator(XSD_COMPLEXTYPE);
            while (iter.hasNext()) {
                this.onNamedSchemaComplexType((Element)iter.next());
            }
            iter = root.elementIterator(XSD_SIMPLETYPE);
            while (iter.hasNext()) {
                this.onNamedSchemaSimpleType((Element)iter.next());
            }
            this.namedTypeResolver.resolveNamedTypes();
        }
    }

    protected XSDatatype dataTypeForXsdAttribute(Element xsdAttribute) {
        String type = xsdAttribute.attributeValue("type");
        XSDatatype dataType = null;
        if (type != null) {
            dataType = this.getTypeByName(type);
        } else {
            Element xsdSimpleType = xsdAttribute.element(XSD_SIMPLETYPE);
            if (xsdSimpleType == null) {
                String name = xsdAttribute.attributeValue("name");
                throw new InvalidSchemaException("The attribute: " + name + " has no type attribute and does not contain a <simpleType/> element");
            }
            dataType = this.loadXSDatatypeFromSimpleType(xsdSimpleType);
        }
        return dataType;
    }

    protected XSDatatype deriveSimpleType(XSDatatype baseType, Element xsdRestriction) {
        TypeIncubator incubator = new TypeIncubator(baseType);
        ValidationContext context = null;
        try {
            Iterator iter = xsdRestriction.elementIterator();
            while (iter.hasNext()) {
                Element element = (Element)iter.next();
                String name = element.getName();
                String value = element.attributeValue("value");
                boolean fixed = AttributeHelper.booleanValue(element, "fixed");
                incubator.addFacet(name, value, fixed, context);
            }
            String newTypeName = null;
            return incubator.derive(newTypeName);
        }
        catch (DatatypeException e) {
            this.onSchemaError("Invalid restriction: " + e.getMessage() + " when trying to build restriction: " + xsdRestriction);
            return null;
        }
    }

    protected DatatypeElementFactory getDatatypeElementFactory(QName elementQName) {
        DatatypeElementFactory factory = this.documentFactory.getElementFactory(elementQName);
        if (factory == null) {
            factory = new DatatypeElementFactory(elementQName);
            elementQName.setDocumentFactory(factory);
        }
        return factory;
    }

    protected QName getQName(String name) {
        return this.documentFactory.createQName(name);
    }

    protected XSDatatype getTypeByName(String type) {
        XSDatatype dataType = (XSDatatype)this.dataTypeCache.get(type);
        if (dataType == null) {
            try {
                int idx = type.indexOf(58);
                if (idx >= 0) {
                    String localName = type.substring(idx + 1);
                    dataType = DatatypeFactory.getTypeByName((String)localName);
                }
                if (dataType == null) {
                    dataType = DatatypeFactory.getTypeByName((String)type);
                }
            }
            catch (DatatypeException datatypeException) {}
            if (dataType != null) {
                this.dataTypeCache.put(type, dataType);
            }
        }
        return dataType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected XSDatatype loadXSDatatypeFromSimpleType(Element xsdSimpleType) {
        Element xsdRestriction = xsdSimpleType.element(XSD_RESTRICTION);
        if (xsdRestriction != null) {
            String base = xsdRestriction.attributeValue("base");
            if (base != null) {
                XSDatatype baseType = this.getTypeByName(base);
                if (baseType != null) return this.deriveSimpleType(baseType, xsdRestriction);
                this.onSchemaError("Invalid base type: " + base + " when trying to build restriction: " + xsdRestriction);
                return null;
            } else {
                Element xsdSubType = xsdSimpleType.element(XSD_SIMPLETYPE);
                if (xsdSubType != null) return this.loadXSDatatypeFromSimpleType(xsdSubType);
                this.onSchemaError("The simpleType element: " + xsdSimpleType + " must contain a base attribute or simpleType element");
            }
            return null;
        } else {
            this.onSchemaError("No <restriction>. Could not create XSDatatype for simpleType: " + xsdSimpleType);
        }
        return null;
    }

    protected void onChildElements(Element element, DatatypeElementFactory factory) {
        Iterator iter = element.elementIterator(XSD_ELEMENT);
        while (iter.hasNext()) {
            Element xsdElement = (Element)iter.next();
            this.onDatatypeElement(xsdElement, factory);
        }
    }

    protected void onDatatypeAttribute(Element xsdElement, DatatypeElementFactory elementFactory, Element xsdAttribute) {
        String name = xsdAttribute.attributeValue("name");
        QName qname = this.getQName(name);
        XSDatatype dataType = this.dataTypeForXsdAttribute(xsdAttribute);
        if (dataType != null) {
            elementFactory.setAttributeXSDatatype(qname, dataType);
        } else {
            String type = xsdAttribute.attributeValue("type");
            System.out.println("Warning: Couldn't find XSDatatype for type: " + type + " attribute: " + name);
        }
    }

    protected void onDatatypeElement(Element xsdElement, DocumentFactory parentFactory) {
        Iterator iter;
        Element schemaComplexType;
        String name = xsdElement.attributeValue("name");
        String type = xsdElement.attributeValue("type");
        QName qname = this.getQName(name);
        DatatypeElementFactory elementFactory = this.getDatatypeElementFactory(qname);
        if (type != null) {
            XSDatatype dataType = this.getTypeByName(type);
            if (dataType != null) {
                elementFactory.setChildElementXSDatatype(qname, dataType);
            } else {
                QName typeQName = this.getQName(type);
                this.namedTypeResolver.registerTypedElement(xsdElement, typeQName, parentFactory);
            }
            return;
        }
        Element xsdSimpleType = xsdElement.element(XSD_SIMPLETYPE);
        if (xsdSimpleType != null) {
            System.out.println("Agfa-sg: handle element types derrived from simpleTypes for element: " + name);
            XSDatatype dataType = this.loadXSDatatypeFromSimpleType(xsdSimpleType);
            if (dataType != null) {
                System.out.println("dataType (from loadXSDatatypeFromSimpleType) = " + dataType);
                elementFactory.setChildElementXSDatatype(qname, dataType);
            }
        }
        if ((schemaComplexType = xsdElement.element(XSD_COMPLEXTYPE)) != null) {
            this.onSchemaComplexType(schemaComplexType, elementFactory);
        }
        if ((iter = xsdElement.elementIterator(XSD_ATTRIBUTE)).hasNext()) {
            do {
                this.onDatatypeAttribute(xsdElement, elementFactory, (Element)iter.next());
            } while (iter.hasNext());
        }
    }

    protected void onNamedSchemaComplexType(Element schemaComplexType) {
        Attribute nameAttr = schemaComplexType.attribute("name");
        if (nameAttr == null) {
            return;
        }
        String name = nameAttr.getText();
        QName qname = this.getQName(name);
        DatatypeElementFactory elementFactory = this.getDatatypeElementFactory(qname);
        this.onSchemaComplexType(schemaComplexType, elementFactory);
        this.namedTypeResolver.registerComplexType(qname, elementFactory);
    }

    protected void onNamedSchemaSimpleType(Element schemaSimpleType) {
        Attribute nameAttr = schemaSimpleType.attribute("name");
        if (nameAttr == null) {
            return;
        }
        String name = nameAttr.getText();
        QName qname = this.getQName(name);
        XSDatatype datatype = this.loadXSDatatypeFromSimpleType(schemaSimpleType);
        this.namedTypeResolver.registerSimpleType(qname, datatype);
    }

    protected void onSchemaComplexType(Element schemaComplexType, DatatypeElementFactory elementFactory) {
        Element schemaAll;
        Element schemaChoice;
        Iterator iter = schemaComplexType.elementIterator(XSD_ATTRIBUTE);
        while (iter.hasNext()) {
            Element xsdAttribute = (Element)iter.next();
            String name = xsdAttribute.attributeValue("name");
            QName qname = this.getQName(name);
            XSDatatype dataType = this.dataTypeForXsdAttribute(xsdAttribute);
            if (dataType != null) {
                elementFactory.setAttributeXSDatatype(qname, dataType);
                continue;
            }
            String type = xsdAttribute.attributeValue("type");
            System.out.println("Warning: Couldn't find XSDatatype for type: " + type + " attribute: " + name);
        }
        Element schemaSequence = schemaComplexType.element(XSD_SEQUENCE);
        if (schemaSequence != null) {
            this.onChildElements(schemaSequence, elementFactory);
        }
        if ((schemaChoice = schemaComplexType.element(XSD_CHOICE)) != null) {
            this.onChildElements(schemaChoice, elementFactory);
        }
        if ((schemaAll = schemaComplexType.element(XSD_ALL)) != null) {
            this.onChildElements(schemaAll, elementFactory);
        }
    }

    protected void onSchemaError(String message) {
        throw new InvalidSchemaException(message);
    }
}

