/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import net.sourceforge.plantuml.PSystem;
import net.sourceforge.plantuml.PSystemError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedImage
implements Comparable<GeneratedImage> {
    private final File pngFile;
    private final String description;
    private final PSystem system;

    public GeneratedImage(File file, String string, PSystem pSystem) {
        this.system = pSystem;
        this.pngFile = file;
        this.description = string;
    }

    public File getPngFile() {
        return this.pngFile;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isError() {
        return this.system instanceof PSystemError;
    }

    public String toString() {
        return this.pngFile.getAbsolutePath() + " " + this.description;
    }

    @Override
    public int compareTo(GeneratedImage generatedImage) {
        int n = this.pngFile.compareTo(generatedImage.pngFile);
        if (n != 0) {
            return n;
        }
        return this.description.compareTo(generatedImage.description);
    }

    public int hashCode() {
        return this.pngFile.hashCode() + this.description.hashCode();
    }

    public boolean equals(Object object) {
        GeneratedImage generatedImage = (GeneratedImage)object;
        return generatedImage.pngFile.equals(this.pngFile) && generatedImage.description.equals(this.description);
    }
}

