/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandLinkLollipop
extends SingleLineCommand<AbstractClassOrObjectDiagram> {
    private static final int OFFSET = 1;
    private static final int FIRST_TYPE_AND_CLASS = 1;
    private static final int FIRST_TYPE = 2;
    private static final int FIRST_CLASS = 3;
    private static final int FIRST_LABEL = 4;
    private static final int LINK1 = 5;
    private static final int LINK2 = 6;
    private static final int SECOND_LABEL = 7;
    private static final int SECOND_TYPE_AND_CLASS = 8;
    private static final int SECOND_TYPE = 9;
    private static final int SECOND_CLASS = 10;
    private static final int LINK_LABEL = 11;
    private final Pattern patternAssociationPoint = Pattern.compile("\\(\\s*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)\\s*,\\s*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)\\s*\\)");

    private CommandLinkLollipop(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram) {
        super(abstractClassOrObjectDiagram, "(?i)^(?:@([\\d.])\\s+)?((?:(interface|enum|abstract\\s+class|abstract|class)\\s+)?(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)|\\(\\s*\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*\\s*,\\s*\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*\\s*\\))\\s*(?:\"([^\"]+)\")?\\s*(?:\\(\\)([-=.]+)|([-=.]+)\\(\\))\\s*(?:\"([^\"]+)\")?\\s*((?:(interface|enum|abstract\\s+class|abstract|class)\\s+)?(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)|\\(\\s*\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*\\s*,\\s*\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*\\s*\\))\\s*(?::\\s*([^\"]+))?$");
    }

    @Override
    protected CommandExecutionResult executeArg(List<String> list) {
        Entity entity;
        Entity entity2;
        Entity entity3;
        if (list.get(1).startsWith("(")) {
            return this.executeArgSpecial1(list);
        }
        if (list.get(8).startsWith("(")) {
            return this.executeArgSpecial2(list);
        }
        if (((AbstractClassOrObjectDiagram)this.getSystem()).isGroup(list.get(3)) && ((AbstractClassOrObjectDiagram)this.getSystem()).isGroup(list.get(10))) {
            return this.executePackageLink(list);
        }
        if (((AbstractClassOrObjectDiagram)this.getSystem()).isGroup(list.get(3)) || ((AbstractClassOrObjectDiagram)this.getSystem()).isGroup(list.get(10))) {
            return CommandExecutionResult.error("Package can be only linked to other package");
        }
        String string = "lol" + UniqueSequence.getValue();
        if (list.get(5) != null) {
            entity3 = (Entity)((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateClass(list.get(10));
            entity2 = ((AbstractClassOrObjectDiagram)this.getSystem()).createEntity(entity3.getCode() + string, list.get(3), EntityType.LOLLIPOP);
            entity = entity3;
        } else {
            assert (list.get(6) != null);
            entity2 = (Entity)((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateClass(list.get(3));
            entity3 = ((AbstractClassOrObjectDiagram)this.getSystem()).createEntity(entity2.getCode() + string, list.get(10), EntityType.LOLLIPOP);
            entity = entity2;
        }
        LinkType linkType = this.getLinkType(list);
        String string2 = this.getQueue(list);
        int n = string2.length();
        if (n == 1 && ((AbstractClassOrObjectDiagram)this.getSystem()).getNbOfHozizontalLollipop(entity) > 1) {
            ++n;
        }
        Link link = new Link(entity2, entity3, linkType, list.get(11), n, list.get(4), list.get(7), ((AbstractClassOrObjectDiagram)this.getSystem()).getLabeldistance(), ((AbstractClassOrObjectDiagram)this.getSystem()).getLabelangle());
        ((AbstractClassOrObjectDiagram)this.getSystem()).resetPragmaLabel();
        this.addLink(link, list.get(0));
        return CommandExecutionResult.ok();
    }

    private String getQueue(List<String> list) {
        if (list.get(5) != null) {
            return list.get(5);
        }
        if (list.get(6) != null) {
            return list.get(6);
        }
        throw new IllegalArgumentException();
    }

    private LinkType getLinkType(List<String> list) {
        return new LinkType(LinkDecor.NONE, LinkDecor.NONE);
    }

    private void addLink(Link link, String string) {
        ((AbstractClassOrObjectDiagram)this.getSystem()).addLink(link);
        if (string == null) {
            LinkType linkType = link.getType();
        } else {
            link.setWeight(Double.parseDouble(string));
        }
    }

    private CommandExecutionResult executePackageLink(List<String> list) {
        Group group = ((AbstractClassOrObjectDiagram)this.getSystem()).getGroup(list.get(3));
        Group group2 = ((AbstractClassOrObjectDiagram)this.getSystem()).getGroup(list.get(10));
        LinkType linkType = this.getLinkType(list);
        String string = this.getQueue(list);
        Link link = new Link(group.getEntityCluster(), group2.getEntityCluster(), linkType, list.get(11), string.length(), list.get(4), list.get(7), ((AbstractClassOrObjectDiagram)this.getSystem()).getLabeldistance(), ((AbstractClassOrObjectDiagram)this.getSystem()).getLabelangle());
        ((AbstractClassOrObjectDiagram)this.getSystem()).resetPragmaLabel();
        this.addLink(link, list.get(0));
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial1(List<String> list) {
        Matcher matcher = this.patternAssociationPoint.matcher(list.get(1));
        if (!matcher.matches()) {
            throw new IllegalStateException();
        }
        String string = matcher.group(1);
        String string2 = matcher.group(2);
        if (!((AbstractClassOrObjectDiagram)this.getSystem()).entityExist(string)) {
            return CommandExecutionResult.error("No class " + string);
        }
        if (!((AbstractClassOrObjectDiagram)this.getSystem()).entityExist(string2)) {
            return CommandExecutionResult.error("No class " + string2);
        }
        IEntity iEntity = ((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateClass(string);
        IEntity iEntity2 = ((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateClass(string2);
        Entity entity = ((AbstractClassOrObjectDiagram)this.getSystem()).createEntity(list.get(1), "node", EntityType.POINT_FOR_ASSOCIATION);
        ((AbstractClassOrObjectDiagram)this.getSystem()).insertBetween(iEntity, iEntity2, entity);
        IEntity iEntity3 = ((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateClass(list.get(10));
        LinkType linkType = this.getLinkType(list);
        String string3 = this.getQueue(list);
        Link link = new Link(entity, iEntity3, linkType, list.get(11), string3.length());
        this.addLink(link, list.get(0));
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial2(List<String> list) {
        Matcher matcher = this.patternAssociationPoint.matcher(list.get(8));
        if (!matcher.matches()) {
            throw new IllegalStateException();
        }
        String string = matcher.group(1);
        String string2 = matcher.group(2);
        if (!((AbstractClassOrObjectDiagram)this.getSystem()).entityExist(string)) {
            return CommandExecutionResult.error("No class " + string);
        }
        if (!((AbstractClassOrObjectDiagram)this.getSystem()).entityExist(string2)) {
            return CommandExecutionResult.error("No class " + string2);
        }
        IEntity iEntity = ((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateClass(string);
        IEntity iEntity2 = ((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateClass(string2);
        Entity entity = ((AbstractClassOrObjectDiagram)this.getSystem()).createEntity(list.get(8), "node", EntityType.POINT_FOR_ASSOCIATION);
        ((AbstractClassOrObjectDiagram)this.getSystem()).insertBetween(iEntity, iEntity2, entity);
        IEntity iEntity3 = ((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateClass(list.get(1));
        LinkType linkType = this.getLinkType(list);
        String string3 = this.getQueue(list);
        Link link = new Link(iEntity3, entity, linkType, list.get(11), string3.length());
        this.addLink(link, list.get(0));
        return CommandExecutionResult.ok();
    }
}

