/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.Note;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommandMultilinesNoteEntity
extends CommandMultilines<AbstractEntityDiagram> {
    protected AbstractCommandMultilinesNoteEntity(AbstractEntityDiagram abstractEntityDiagram, String string) {
        super(abstractEntityDiagram, string, "(?i)^end ?note$");
    }

    @Override
    public final CommandExecutionResult execute(List<String> list) {
        Link link;
        List<String> list2 = StringUtils.getSplit(this.getStartingPattern(), list.get(0).trim());
        String string = list2.get(0);
        IEntity iEntity = ((AbstractEntityDiagram)this.getSystem()).getOrCreateClass(list2.get(1));
        List<String> list3 = StringUtils.removeEmptyColumns(list.subList(1, list.size() - 1));
        Url url = null;
        if (list3.size() > 0) {
            url = Note.extractUrl(list3.get(0));
        }
        if (url != null) {
            list3 = list3.subList(1, list3.size());
        }
        String string2 = StringUtils.getMergedLines(list3);
        Entity entity = ((AbstractEntityDiagram)this.getSystem()).createEntity("GMN" + UniqueSequence.getValue(), string2, EntityType.NOTE);
        entity.setSpecificBackcolor(HtmlColor.getColorIfValid(list2.get(2)));
        entity.setUrl(url);
        Position position = Position.valueOf(string.toUpperCase()).withRankdir(((AbstractEntityDiagram)this.getSystem()).getRankdir());
        LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getDashed();
        if (position == Position.RIGHT) {
            link = new Link(iEntity, entity, linkType, null, 1);
        } else if (position == Position.LEFT) {
            link = new Link(entity, iEntity, linkType, null, 1);
        } else if (position == Position.BOTTOM) {
            link = new Link(iEntity, entity, linkType, null, 2);
        } else if (position == Position.TOP) {
            link = new Link(entity, iEntity, linkType, null, 2);
        } else {
            throw new IllegalArgumentException();
        }
        ((AbstractEntityDiagram)this.getSystem()).addLink(link);
        return CommandExecutionResult.ok();
    }
}

