/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.IOException;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.dot.BorderMode;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.cucadiagram.dot.DrawFile;
import net.sourceforge.plantuml.cucadiagram.dot.LabelBuilder;
import net.sourceforge.plantuml.cucadiagram.dot.LabelBuilderObjectOrClass;

class LabelBuilderClassWithVisibilityImage
extends LabelBuilderObjectOrClass
implements LabelBuilder {
    LabelBuilderClassWithVisibilityImage(FileFormat fileFormat, DotData dotData, IEntity iEntity) {
        super(fileFormat, dotData, iEntity);
    }

    public void appendLabel(StringBuilder stringBuilder) throws IOException {
        String string;
        DrawFile drawFile = this.getEntity().getImageFile();
        if (drawFile == null) {
            string = this.getEntity().getStereotype() == null ? null : this.getEntity().getStereotype().getLabel();
            drawFile = this.getData().getStaticImages(this.getEntity().getType(), string);
        }
        if (drawFile == null) {
            throw new IllegalStateException();
        }
        string = this.getData().showPortion(EntityPortion.CIRCLED_CHARACTER, this.getEntity()) ? StringUtils.getPlateformDependentAbsolutePath(drawFile.getPngOrEps(this.getFileFormat())) : null;
        boolean bl = this.getData().showPortion(EntityPortion.FIELD, this.getEntity());
        boolean bl2 = this.getData().showPortion(EntityPortion.METHOD, this.getEntity());
        if (!bl && !bl2) {
            stringBuilder.append(this.getHtmlHeaderTableForObjectOrClassOrInterfaceOrEnum(this.getEntity(), string, 1, true, BorderMode.NO_BORDER_CELLSPACING));
        } else {
            String string2 = this.getEntity().getStereotype() == null ? null : this.getEntity().getStereotype().getLabel();
            int n = this.getLonguestHeader(this.getEntity());
            int n2 = this.computeSpring(n, this.getLongestFieldOrAttribute(this.getEntity()), 30);
            int n3 = this.computeSpring(this.getLongestField(this.getEntity()), Math.max(n, this.getLongestMethods(this.getEntity())), 30);
            int n4 = this.computeSpring(this.getLongestMethods(this.getEntity()), Math.max(n, this.getLongestField(this.getEntity())), 30);
            stringBuilder.append("<TABLE BGCOLOR=" + this.getColorString(ColorParam.classBackground, string2) + " COLOR=" + this.getColorString(ColorParam.classBorder, string2) + " BORDER=\"0\" CELLBORDER=\"1\" CELLSPACING=\"0\" CELLPADDING=\"4\">");
            stringBuilder.append("<TR><TD>");
            stringBuilder.append(this.getHtmlHeaderTableForObjectOrClassOrInterfaceOrEnum(this.getEntity(), string, n2, true, BorderMode.NO_BORDER));
            stringBuilder.append("</TD></TR>");
            if (bl) {
                stringBuilder.append("<TR><TD " + this.getWitdh55() + ">");
                if (this.getEntity().getFieldsToDisplay().size() > 0) {
                    this.buildTableVisibility(this.getEntity(), true, stringBuilder, n3);
                }
                stringBuilder.append("</TD></TR>");
            }
            if (bl2) {
                stringBuilder.append("<TR><TD>");
                if (this.getEntity().getMethodsToDisplay().size() > 0) {
                    this.buildTableVisibility(this.getEntity(), false, stringBuilder, n4);
                }
                stringBuilder.append("</TD></TR>");
            }
            stringBuilder.append("</TABLE>");
        }
    }
}

