/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ftp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpConnexion {
    private final String user;
    private final Map<String, String> incoming = new HashMap<String, String>();
    private final Map<String, byte[]> outgoing = new HashMap<String, byte[]>();

    public FtpConnexion(String string) {
        this.user = string;
    }

    public synchronized void addIncoming(String string, String string2) {
        if (string.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        this.incoming.put(string, string2);
    }

    public void removeOutgoing(String string) {
        this.outgoing.remove(string);
    }

    public synchronized Collection<String> getFiles() {
        ArrayList<String> arrayList = new ArrayList<String>(this.incoming.keySet());
        arrayList.addAll(this.outgoing.keySet());
        return Collections.unmodifiableCollection(arrayList);
    }

    public synchronized byte[] getData(String string) {
        if (string.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        String string2 = this.incoming.get(string);
        if (string2 != null) {
            return string2.getBytes();
        }
        byte[] byArray = this.outgoing.get(string);
        if (byArray != null) {
            return byArray;
        }
        return new byte[0];
    }

    public synchronized int getSize(String string) {
        if (string.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        String string2 = this.incoming.get(string);
        if (string2 != null) {
            return string2.length();
        }
        byte[] byArray = this.outgoing.get(string);
        if (byArray != null) {
            return byArray.length;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processImage(String string) throws IOException {
        if (string.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        SourceStringReader sourceStringReader = new SourceStringReader(this.incoming.get(string));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileFormat fileFormat = FileFormat.PNG;
        String string2 = fileFormat.changeName(string, 0);
        String string3 = sourceStringReader.generateImage((OutputStream)byteArrayOutputStream, new FileFormatOption(fileFormat));
        if (string3 != null) {
            FtpConnexion ftpConnexion = this;
            synchronized (ftpConnexion) {
                this.outgoing.put(string2, byteArrayOutputStream.toByteArray());
            }
        }
    }
}

