/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapper;

class EntityImageUsecase
extends AbstractEntityImage {
    private final TextBlock name;

    public EntityImageUsecase(Entity entity) {
        super(entity);
        this.name = TextBlockUtils.create(StringUtils.getWithNewlines(entity.getDisplay()), new FontConfiguration(this.getFont14(), HtmlColor.BLACK), HorizontalAlignement.CENTER);
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.name.calculateDimension(stringBounder);
        return new Dimension2DDouble(dimension2D.getWidth() * 1.7, dimension2D.getHeight() * 1.7);
    }

    public void draw(ColorMapper colorMapper, Graphics2D graphics2D) {
        Dimension2D dimension2D = this.getDimension(StringBounderUtils.asStringBounder(graphics2D));
        GeneralPath generalPath = new GeneralPath();
        double d = dimension2D.getHeight();
        double d2 = dimension2D.getWidth();
        generalPath.append(new QuadCurve2D.Double(0.0, d / 2.0, 0.0, 0.0, d2 / 2.0, 0.0), true);
        generalPath.append(new QuadCurve2D.Double(d2 / 2.0, 0.0, d2, 0.0, d2, d / 2.0), true);
        generalPath.append(new QuadCurve2D.Double(d2, d / 2.0, d2, d, d2 / 2.0, d), true);
        generalPath.append(new QuadCurve2D.Double(d2 / 2.0, d, 0.0, d, 0.0, d / 2.0), true);
        graphics2D.setColor(colorMapper.getMappedColor(this.getYellow()));
        graphics2D.fill(generalPath);
        graphics2D.setColor(colorMapper.getMappedColor(this.getRed()));
        graphics2D.draw(generalPath);
        Dimension2D dimension2D2 = this.name.calculateDimension(StringBounderUtils.asStringBounder(graphics2D));
        double d3 = (d2 - dimension2D2.getWidth()) / 2.0;
        double d4 = (d - dimension2D2.getHeight()) / 2.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d4, dimension2D2.getWidth(), dimension2D2.getHeight());
        graphics2D.setColor(Color.BLACK);
        this.name.drawTOBEREMOVED(colorMapper, graphics2D, d3, d4);
    }
}

