/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.SignatureUtils;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.DotCommon;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.cucadiagram.dot.DotSplines;
import net.sourceforge.plantuml.cucadiagram.dot.DrawFile;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizLayoutStrategy;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizMaker;
import net.sourceforge.plantuml.cucadiagram.dot.LabelBuilderClassOld;
import net.sourceforge.plantuml.cucadiagram.dot.LabelBuilderClassWithVisibilityImage;
import net.sourceforge.plantuml.cucadiagram.dot.LabelBuilderObjectOld;
import net.sourceforge.plantuml.cucadiagram.dot.LabelBuilderObjectOrClass;
import net.sourceforge.plantuml.cucadiagram.dot.LabelBuilderObjectWithVisibilityImage;
import net.sourceforge.plantuml.cucadiagram.dot.LabelBuilderTableLollipopDecorator;
import net.sourceforge.plantuml.cucadiagram.dot.LabelBuilderTableNineDecorator;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.UDrawable;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DotMaker
extends DotCommon
implements GraphvizMaker {
    private static boolean isJunit = false;
    private final List<String> dotStrings;
    private static String lastDotSignature;
    private final FileFormat fileFormat;
    private final boolean isVisibilityModifierPresent;
    private static final boolean TURN_AROUND_B2114 = false;
    private final Set<String> hasAlreadyOneIncommingArrowLenghtOne;
    private final Set<String> rankMin = new HashSet<String>();
    private boolean MODE_LOLLIPOP_BETA = false;
    static final boolean MODE_MARGIN = true;
    public static final boolean MODE_BRANCHE_CLUSTER = false;
    private final List<File> fileToClean = new ArrayList<File>();

    public static void goJunit() {
        isJunit = true;
    }

    public DotMaker(DotData dotData, List<String> list, FileFormat fileFormat) {
        super(fileFormat, dotData);
        this.dotStrings = list;
        this.fileFormat = fileFormat;
        this.isVisibilityModifierPresent = dotData.getSkinParam().classAttributeIconSize() > 0 ? dotData.isThereVisibilityImages() : false;
        this.hasAlreadyOneIncommingArrowLenghtOne = null;
    }

    @Override
    public String createDotString() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        this.initPrintWriter(stringBuilder);
        this.printGroups(stringBuilder, null);
        this.printEntities(stringBuilder, this.getUnpackagedEntities());
        this.printLinks(stringBuilder, this.getData().getLinks());
        this.printRanking(stringBuilder);
        stringBuilder.append("}");
        if (isJunit) {
            lastDotSignature = SignatureUtils.getSignatureWithoutImgSrc(stringBuilder.toString());
        }
        return stringBuilder.toString();
    }

    private void printRanking(StringBuilder stringBuilder) {
        if (this.rankMin.size() == 0) {
            return;
        }
        stringBuilder.append("{ rank = min;");
        for (String string : this.rankMin) {
            stringBuilder.append(string);
            stringBuilder.append(";");
        }
        stringBuilder.append("}");
    }

    private void initPrintWriter(StringBuilder stringBuilder) {
        Log.info("Entities = " + this.getData().getEntities().size());
        boolean bl = this.getData().getEntities().size() > 800;
        stringBuilder.append("digraph unix {");
        for (String object2 : this.dotStrings) {
            stringBuilder.append(object2);
        }
        stringBuilder.append("bgcolor=\"" + this.getAsHtml(this.getData().getSkinParam().getBackgroundColor()) + "\";");
        if (bl) {
            stringBuilder.append("size=\"400,400;\"");
        } else {
            stringBuilder.append("ratio=auto;");
        }
        stringBuilder.append("compound=true;");
        Object object3 = this.getData().getSkinParam().getDotSplines();
        GraphvizLayoutStrategy graphvizLayoutStrategy = this.getData().getSkinParam().getStrategy();
        if (object3 == DotSplines.ORTHO) {
            stringBuilder.append("splines=ortho;");
        } else if (object3 == DotSplines.POLYLINE) {
            stringBuilder.append("splines=polyline;");
        } else if (graphvizLayoutStrategy != GraphvizLayoutStrategy.DOT) {
            stringBuilder.append("splines=true;");
        }
        if (graphvizLayoutStrategy != GraphvizLayoutStrategy.DOT) {
            stringBuilder.append("layout=" + graphvizLayoutStrategy.name().toLowerCase() + ";");
            stringBuilder.append("overlap=false;");
        }
        stringBuilder.append("remincross=true;");
        stringBuilder.append("searchsize=500;");
        if (this.getData().getRankdir() == Rankdir.LEFT_TO_RIGHT) {
            stringBuilder.append("rankdir=LR;");
        }
        if (this.getData().getDpi() != 96) {
            stringBuilder.append("dpi=" + this.getData().getDpi() + ";");
            stringBuilder.append("imagescale=both;");
        }
    }

    private Collection<IEntity> getUnpackagedEntities() {
        ArrayList<IEntity> arrayList = new ArrayList<IEntity>();
        for (IEntity iEntity : this.getData().getEntities().values()) {
            if (iEntity.getParent() != this.getData().getTopParent()) continue;
            arrayList.add(iEntity);
        }
        return arrayList;
    }

    private void printGroups(StringBuilder stringBuilder, Group group) throws IOException {
        for (Group group2 : this.getData().getGroupHierarchy().getChildrenGroups(group)) {
            if (this.getData().isEmpty(group2) && group2.getType() == GroupType.PACKAGE) {
                Entity entity = new Entity(group2.getUid(), group2.getCode(), group2.getDisplay(), EntityType.EMPTY_PACKAGE, null, null);
                this.printEntity(stringBuilder, entity);
                continue;
            }
            this.printGroup(stringBuilder, group2);
        }
    }

    private void printGroup(StringBuilder stringBuilder, Group group) throws IOException {
        if (group.getType() == GroupType.CONCURRENT_STATE) {
            return;
        }
        if (this.isSpecialGroup(group)) {
            this.printGroupSpecial(stringBuilder, group);
        } else {
            this.printGroupNormal(stringBuilder, group);
        }
    }

    private void printGroupNormal(StringBuilder stringBuilder, Group group) throws IOException {
        String string = group.getStereotype();
        stringBuilder.append("subgraph " + group.getUid() + " {");
        UFont uFont = this.getData().getSkinParam().getFont(this.getFontParamForGroup(), string);
        stringBuilder.append("fontsize=\"" + uFont.getSize() + "\";");
        String string2 = uFont.getFamily(null);
        if (string2 != null) {
            stringBuilder.append("fontname=\"" + string2 + "\";");
        }
        if (group.getDisplay() != null) {
            stringBuilder.append("label=<" + this.manageHtmlIB(group.getDisplay(), this.getFontParamForGroup(), string) + ">;");
        }
        String string3 = this.getAsHtml(this.getData().getSkinParam().getFontHtmlColor(this.getFontParamForGroup(), string));
        stringBuilder.append("fontcolor=\"" + string3 + "\";");
        if (this.getGroupBackColor(group) != null) {
            stringBuilder.append("fillcolor=\"" + this.getAsHtml(this.getGroupBackColor(group)) + "\";");
        }
        if (group.getType() == GroupType.STATE) {
            stringBuilder.append("color=" + this.getColorString(ColorParam.stateBorder, string) + ";");
        } else {
            stringBuilder.append("color=" + this.getColorString(ColorParam.packageBorder, string) + ";");
        }
        stringBuilder.append("style=\"" + this.getStyle(group) + "\";");
        this.printGroups(stringBuilder, group);
        this.printEntities(stringBuilder, group.entities().values());
        for (Link link : this.getData().getLinks()) {
            this.eventuallySameRank(stringBuilder, group, link);
        }
        stringBuilder.append("}");
    }

    private HtmlColor getGroupBackColor(Group group) {
        HtmlColor htmlColor = group.getBackColor();
        if (htmlColor == null) {
            htmlColor = this.getData().getSkinParam().getHtmlColor(ColorParam.packageBackground, null);
        }
        return htmlColor;
    }

    /*
     * WARNING - void declaration
     */
    private void printGroupSpecial(StringBuilder stringBuilder, Group group) throws IOException {
        void var14_28;
        void var14_25;
        Object object2;
        Object object3;
        stringBuilder.append("subgraph " + group.getUid() + "a {");
        if (OptionFlags.getInstance().isDebugDot()) {
            stringBuilder.append("style=dotted;");
            stringBuilder.append("label=\"a\";");
        } else {
            stringBuilder.append("style=invis;");
            stringBuilder.append("label=\"\";");
        }
        stringBuilder.append("subgraph " + group.getUid() + "v {");
        stringBuilder.append("style=solid;");
        List<Link> list = this.getData().getAutoLinks(group);
        List<Link> list2 = this.getData().getToEdgeLinks(group);
        List<Link> list3 = this.getData().getFromEdgeLinks(group);
        boolean bl = list.size() == 1;
        List<Link> list4 = this.getNodesHiddenUidOut(group);
        List<Link> list5 = this.getNodesHiddenUidIn(group);
        ArrayList<Link> arrayList = new ArrayList<Link>(list4);
        arrayList.addAll(list5);
        for (Link link : arrayList) {
            object3 = this.getHiddenNodeUid(group, link);
            if (OptionFlags.getInstance().isDebugDot()) {
                stringBuilder.append("style=dotted;");
                stringBuilder.append("label=\"k" + (String)object3 + "\";");
            } else {
                stringBuilder.append("style=invis;");
                stringBuilder.append("label=\"\";");
            }
            if (OptionFlags.getInstance().isDebugDot()) {
                stringBuilder.append((String)object3 + ";");
                continue;
            }
            stringBuilder.append((String)object3 + " [shape=point,width=.01,style=invis,label=\"\"];");
        }
        for (int i = 1; i < list4.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                object3 = list4.get(j);
                object2 = list4.get(i);
                if (((Link)object3).getEntity2() != ((Link)object2).getEntity2()) continue;
                String iterator2 = this.getHiddenNodeUid(group, (Link)object3);
                String string = this.getHiddenNodeUid(group, (Link)object2);
                if (OptionFlags.getInstance().isDebugDot()) {
                    stringBuilder.append(iterator2 + "->" + string + ";");
                    continue;
                }
                stringBuilder.append(iterator2 + "->" + string + " [style=invis,arrowtail=none,arrowhead=none];");
            }
        }
        if (bl) {
            if (OptionFlags.getInstance().isDebugDot()) {
                stringBuilder.append(group.getUid() + "lmin;");
                stringBuilder.append(group.getUid() + "lmax;");
                stringBuilder.append(group.getUid() + "lmin->" + group.getUid() + "lmax [minlen=2]; ");
            } else {
                stringBuilder.append(group.getUid() + "lmin [shape=point,width=.01,style=invis,label=\"\"];");
                stringBuilder.append(group.getUid() + "lmax [shape=point,width=.01,style=invis,label=\"\"];");
                stringBuilder.append(group.getUid() + "lmin->" + group.getUid() + "lmax [minlen=2,style=invis,arrowtail=none,arrowhead=none]; ");
            }
        }
        UFont uFont = this.getData().getSkinParam().getFont(this.getFontParamForGroup(), null);
        stringBuilder.append("fontsize=\"" + uFont.getSize() + "\";");
        String string = uFont.getFamily(null);
        if (string != null) {
            stringBuilder.append("fontname=\"" + string + "\";");
        }
        if (group.getDisplay() != null) {
            object3 = new StringBuilder(this.manageHtmlIB(group.getDisplay(), this.getFontParamForGroup(), null));
            if (group.getEntityCluster().getFieldsToDisplay().size() > 0) {
                ((StringBuilder)object3).append("<BR ALIGN=\"LEFT\"/>");
                for (Member string2 : group.getEntityCluster().getFieldsToDisplay()) {
                    ((StringBuilder)object3).append(this.manageHtmlIB("  " + string2.getDisplayWithVisibilityChar() + "  ", FontParam.STATE_ATTRIBUTE, null));
                    ((StringBuilder)object3).append("<BR ALIGN=\"LEFT\"/>");
                }
            }
            stringBuilder.append("label=<" + object3 + ">;");
        }
        object3 = this.getAsHtml(this.getData().getSkinParam().getFontHtmlColor(this.getFontParamForGroup(), null));
        stringBuilder.append("fontcolor=\"" + (String)object3 + "\";");
        object2 = this.getGroupBackColor(group);
        if (object2 != null) {
            stringBuilder.append("fillcolor=\"" + this.getAsHtml((HtmlColor)object2) + "\";");
        }
        if (group.getType() == GroupType.STATE) {
            stringBuilder.append("color=" + this.getColorString(ColorParam.stateBorder, null) + ";");
        } else {
            stringBuilder.append("color=" + this.getColorString(ColorParam.packageBorder, null) + ";");
        }
        stringBuilder.append("style=\"" + this.getStyle(group) + "\";");
        stringBuilder.append("subgraph " + group.getUid() + "i {");
        stringBuilder.append("label=\"i\";");
        if (OptionFlags.getInstance().isDebugDot()) {
            stringBuilder.append("style=dotted;");
            stringBuilder.append("label=\"i\";");
        } else {
            if (object2 == null) {
                stringBuilder.append("style=invis;");
            } else {
                String i = this.getColorString(ColorParam.background, null);
                stringBuilder.append("fillcolor=" + i + ";");
                stringBuilder.append("color=" + i + ";");
                stringBuilder.append("style=\"filled,rounded\";");
            }
            stringBuilder.append("label=\"\";");
        }
        this.printGroups(stringBuilder, group);
        this.printEntities(stringBuilder, group.entities().values());
        for (Link link : this.getData().getLinks()) {
            this.eventuallySameRank(stringBuilder, group, link);
        }
        boolean bl2 = false;
        while (var14_25 < list3.size()) {
            if (OptionFlags.getInstance().isDebugDot()) {
                stringBuilder.append("eds" + (int)var14_25 + ";");
            } else {
                stringBuilder.append("eds" + (int)var14_25 + " [shape=point,width=.01,style=invis,label=\"\"];");
            }
            stringBuilder.append("eds" + (int)var14_25 + " ->" + list3.get((int)var14_25).getEntity2().getUid() + " [minlen=2,style=invis,arrowtail=none,arrowhead=none]; ");
            ++var14_25;
        }
        stringBuilder.append("}");
        stringBuilder.append("}");
        if (bl) {
            void var15_34;
            stringBuilder.append("subgraph " + group.getUid() + "l {");
            if (OptionFlags.getInstance().isDebugDot()) {
                stringBuilder.append("style=dotted;");
                stringBuilder.append("label=\"l\";");
            } else {
                stringBuilder.append("style=invis;");
                stringBuilder.append("label=\"\";");
            }
            String string2 = ",color=" + this.getColorString(this.getArrowColorParam(), null);
            stringBuilder.append(group.getUid() + "lab0 [shape=point,width=.01,label=\"\"" + string2 + "]");
            String string3 = list.get(0).getLabel();
            if (string3 == null) {
                String string4 = "";
            }
            stringBuilder.append(group.getUid() + "lab1 [label=<" + this.manageHtmlIB((String)var15_34, this.getArrowFontParam(), null) + ">,shape=plaintext,margin=0];");
            stringBuilder.append(group.getUid() + "lab0 -> " + group.getUid() + "lab1 [minlen=0,style=invis];");
            stringBuilder.append("}");
            stringBuilder.append(group.getUid() + "lmin -> " + group.getUid() + "lab0 [ltail=" + group.getUid() + "v,arrowtail=none,arrowhead=none" + string2 + "];");
            stringBuilder.append(group.getUid() + "lab0 -> " + group.getUid() + "lmax [lhead=" + group.getUid() + "v,arrowtail=none,arrowhead=open" + string2 + "];");
        }
        boolean bl3 = false;
        while (var14_28 < list3.size()) {
            stringBuilder.append("subgraph " + group.getUid() + "ed" + (int)var14_28 + " {");
            if (OptionFlags.getInstance().isDebugDot()) {
                stringBuilder.append("style=dotted;");
                stringBuilder.append("label=\"ed" + (int)var14_28 + "\";");
            } else {
                stringBuilder.append("style=invis;");
                stringBuilder.append("label=\"\";");
            }
            String string5 = ",color=" + this.getColorString(this.getArrowColorParam(), null);
            String string6 = list3.get((int)var14_28).getLabel();
            if (string6 == null) {
                string6 = "";
            }
            stringBuilder.append(group.getUid() + "fedge" + (int)var14_28 + " [shape=point,width=.01,label=\"\"" + string5 + "]");
            stringBuilder.append("}");
            stringBuilder.append("eds" + (int)var14_28 + " -> " + group.getUid() + "fedge" + (int)var14_28 + " [ltail=" + group.getUid() + "v,arrowtail=none,arrowhead=none" + string5 + "];");
            stringBuilder.append(group.getUid() + "fedge" + (int)var14_28 + " -> " + list3.get((int)var14_28).getEntity2().getUid() + "[arrowtail=none,arrowhead=open" + string5);
            stringBuilder.append(",label=<" + this.manageHtmlIB(string6, this.getArrowFontParam(), null) + ">];");
            ++var14_28;
        }
        stringBuilder.append("}");
    }

    private FontParam getFontParamForGroup() {
        if (this.getData().getUmlDiagramType() == UmlDiagramType.STATE) {
            return FontParam.STATE;
        }
        return FontParam.PACKAGE;
    }

    private String getStyle(Group group) {
        StringBuilder stringBuilder = new StringBuilder();
        if (group.isBold()) {
            stringBuilder.append("bold");
        } else if (group.isDashed()) {
            stringBuilder.append("dashed");
        } else {
            stringBuilder.append("solid");
        }
        if (this.getGroupBackColor(group) != null) {
            stringBuilder.append(",filled");
        }
        if (group.isRounded()) {
            stringBuilder.append(",rounded");
        }
        return stringBuilder.toString();
    }

    private void printLinks(StringBuilder stringBuilder, List<Link> list) throws IOException {
        for (Link link : this.appendPhantomLink(list)) {
            IEntity iEntity;
            IEntity iEntity2 = link.getEntity1();
            if (iEntity2 == (iEntity = link.getEntity2()) && iEntity2.getType() == EntityType.GROUP || iEntity2.getType() == EntityType.GROUP && iEntity.getParent() == iEntity2.getParent() || iEntity.getType() == EntityType.GROUP && iEntity2.getParent() == iEntity.getParent() || iEntity2.getType() == EntityType.LOLLIPOP || iEntity.getType() == EntityType.LOLLIPOP) continue;
            this.printLink(stringBuilder, link);
        }
    }

    private void printLink(StringBuilder stringBuilder, Link link) throws IOException {
        String string;
        StringBuilder stringBuilder2 = this.getLinkDecoration(link);
        if (link.getWeight() > 1.0) {
            stringBuilder2.append("weight=" + link.getWeight() + ",");
        }
        if (link.getLabeldistance() != null) {
            stringBuilder2.append("labeldistance=" + link.getLabeldistance() + ",");
        }
        if (link.getLabelangle() != null) {
            stringBuilder2.append("labelangle=" + link.getLabelangle() + ",");
        }
        if (!link.isConstraint()) {
            stringBuilder2.append("constraint=false,");
        }
        DrawFile drawFile = link.getImageFile();
        boolean bl = false;
        if (link.getLabel() != null) {
            stringBuilder2.append("label=<" + this.manageHtmlIB(link.getLabel(), this.getArrowFontParam(), null) + ">,");
            bl = true;
        } else if (drawFile != null) {
            stringBuilder2.append("label=<" + this.getHtmlForLinkNote(drawFile.getPngOrEps(this.fileFormat)) + ">,");
            bl = true;
        }
        if (link.getQualifier1() != null) {
            stringBuilder2.append("taillabel=<" + this.manageHtmlIB(link.getQualifier1(), this.getArrowFontParam(), null) + ">,");
        }
        if (link.getQualifier2() != null) {
            stringBuilder2.append("headlabel=<" + this.manageHtmlIB(link.getQualifier2(), this.getArrowFontParam(), null) + ">,");
        }
        int n = link.getLength();
        String string2 = link.getEntity1().getUid();
        String string3 = link.getEntity2().getUid();
        LinkType linkType = link.getType();
        stringBuilder2.append(linkType.getSpecificDecoration());
        if (link.isInvis()) {
            stringBuilder2.append(",style=invis");
        }
        String string4 = string = n >= 3 ? ",minlen=" + (n - 1) : "";
        if (link.getEntity1().getType() == EntityType.GROUP) {
            string2 = this.getHiddenNodeUid(link.getEntity1().getParent(), link);
            stringBuilder2.append(",ltail=" + link.getEntity1().getParent().getUid() + "v");
        }
        if (link.getEntity2().getType() == EntityType.GROUP) {
            string3 = this.getHiddenNodeUid(link.getEntity2().getParent(), link);
            stringBuilder2.append(",lhead=" + link.getEntity2().getParent().getUid() + "v");
        }
        boolean bl2 = link.getEntity1().hasNearDecoration();
        boolean bl3 = link.getEntity2().hasNearDecoration();
        stringBuilder.append(string2);
        if (bl2) {
            stringBuilder.append(":h");
        }
        stringBuilder.append(" -> ");
        stringBuilder.append(string3);
        if (bl3) {
            stringBuilder.append(":h");
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append(string + "];");
        this.eventuallySameRank(stringBuilder, this.getData().getTopParent(), link);
    }

    private List<Link> getNodesHiddenUidOut(Group group) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : this.getData().getLinks()) {
            if (link.getEntity1().getParent() == link.getEntity2().getParent() || link.getEntity1().getType() != EntityType.GROUP || link.getEntity1().getParent() != group) continue;
            arrayList.add(link);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private List<Link> getNodesHiddenUidIn(Group group) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : this.getData().getLinks()) {
            if (link.getEntity1().getParent() == link.getEntity2().getParent() || link.getEntity2().getType() != EntityType.GROUP || link.getEntity2().getParent() != group) continue;
            arrayList.add(link);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private String getHiddenNodeUid(Group group, Link link) {
        if (this.getData().isEmpty(group) && group.getType() == GroupType.PACKAGE) {
            return group.getUid();
        }
        return group.getUid() + "_" + link.getUid();
    }

    private StringBuilder getLinkDecoration(Link link) {
        StringBuilder stringBuilder = new StringBuilder("[color=");
        if (link.getSpecificColor() == null) {
            stringBuilder.append(this.getColorString(this.getArrowColorParam(), null));
        } else {
            stringBuilder.append("\"" + this.getAsHtml(link.getSpecificColor()) + "\"");
        }
        stringBuilder.append(",");
        stringBuilder.append("fontcolor=" + this.getFontColorString(this.getArrowFontParam(), null) + ",");
        UFont uFont = this.getData().getSkinParam().getFont(this.getArrowFontParam(), null);
        stringBuilder.append("fontsize=\"" + uFont.getSize() + "\",");
        String string = uFont.getFamily(null);
        if (string != null) {
            stringBuilder.append("fontname=\"" + string + "\",");
        }
        return stringBuilder;
    }

    private List<Link> appendPhantomLink(List<Link> list) {
        ArrayList<Link> arrayList = new ArrayList<Link>(list);
        for (Link link : list) {
            DrawFile drawFile;
            if (link.getLength() != 1 || (drawFile = link.getImageFile()) == null) continue;
            Link link2 = new Link(link.getEntity1(), link.getEntity2(), link.getType(), null, link.getLength());
            link2.setInvis(true);
            arrayList.add(link2);
        }
        return arrayList;
    }

    private String getHtmlForLinkNote(File file) {
        String string = StringUtils.getPlateformDependentAbsolutePath(file);
        StringBuilder stringBuilder = new StringBuilder("<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\">");
        stringBuilder.append("<TR><TD><IMG SRC=\"" + string + "\"/></TD></TR>");
        stringBuilder.append("</TABLE>");
        return stringBuilder.toString();
    }

    private FontParam getArrowFontParam() {
        if (this.getData().getUmlDiagramType() == UmlDiagramType.CLASS) {
            return FontParam.CLASS_ARROW;
        }
        if (this.getData().getUmlDiagramType() == UmlDiagramType.OBJECT) {
            return FontParam.OBJECT_ARROW;
        }
        if (this.getData().getUmlDiagramType() == UmlDiagramType.USECASE) {
            return FontParam.USECASE_ARROW;
        }
        if (this.getData().getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            return FontParam.ACTIVITY_ARROW;
        }
        if (this.getData().getUmlDiagramType() == UmlDiagramType.COMPONENT) {
            return FontParam.COMPONENT_ARROW;
        }
        if (this.getData().getUmlDiagramType() == UmlDiagramType.STATE) {
            return FontParam.STATE_ARROW;
        }
        throw new IllegalStateException();
    }

    private ColorParam getArrowColorParam() {
        if (this.getData().getUmlDiagramType() == UmlDiagramType.CLASS) {
            return ColorParam.classArrow;
        }
        if (this.getData().getUmlDiagramType() == UmlDiagramType.OBJECT) {
            return ColorParam.objectArrow;
        }
        if (this.getData().getUmlDiagramType() == UmlDiagramType.USECASE) {
            return ColorParam.usecaseArrow;
        }
        if (this.getData().getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            return ColorParam.activityArrow;
        }
        if (this.getData().getUmlDiagramType() == UmlDiagramType.COMPONENT) {
            return ColorParam.componentArrow;
        }
        if (this.getData().getUmlDiagramType() == UmlDiagramType.STATE) {
            return ColorParam.stateArrow;
        }
        throw new IllegalStateException();
    }

    private String getFontColorString(FontParam fontParam, String string) {
        return "\"" + this.getAsHtml(this.getFontHtmlColor(fontParam, string)) + "\"";
    }

    private void eventuallySameRank(StringBuilder stringBuilder, Group group, Link link) {
        int n = link.getLength();
        if (n == 1 && link.getEntity1().getParent() == group && link.getEntity2().getParent() == group) {
            if (link.getEntity1().getType() == EntityType.GROUP) {
                throw new IllegalArgumentException();
            }
            if (link.getEntity2().getType() == EntityType.GROUP) {
                throw new IllegalArgumentException();
            }
            stringBuilder.append("{rank=same; " + link.getEntity1().getUid() + "; " + link.getEntity2().getUid() + "}");
        }
    }

    private Map<IEntity, Integer> getMap(Collection<? extends IEntity> collection) {
        HashMap<IEntity, Integer> hashMap = new HashMap<IEntity, Integer>();
        for (IEntity imaged : collection) {
            hashMap.put(imaged, 0);
        }
        for (Link link : this.getData().getLinks()) {
            if (!link.isConstraint()) {
                hashMap.put(link.getEntity2(), 1);
                continue;
            }
            if (link.getLength() != 1 || !link.isInverted()) continue;
            hashMap.put(link.getEntity1(), 1);
        }
        return hashMap;
    }

    private void printEntities(StringBuilder stringBuilder, Collection<? extends IEntity> collection) throws IOException {
        ArrayList<? extends IEntity> arrayList = new ArrayList<IEntity>(collection);
        Collections.sort(arrayList, new EntityComparator2(this.getMap(collection)));
        HashSet<IEntity> hashSet = new HashSet<IEntity>();
        HashSet<IEntity> hashSet2 = new HashSet<IEntity>();
        for (IEntity iEntity : arrayList) {
            if (iEntity.getType() != EntityType.LOLLIPOP) continue;
            hashSet.add(iEntity);
            if (this.MODE_LOLLIPOP_BETA) continue;
            hashSet2.add(this.getConnectedToLollipop(iEntity));
        }
        if (this.MODE_LOLLIPOP_BETA) {
            for (IEntity iEntity : arrayList) {
                if (hashSet.contains(iEntity)) continue;
                this.printEntity(stringBuilder, iEntity);
            }
        } else {
            for (IEntity iEntity : arrayList) {
                if (hashSet.contains(iEntity) || hashSet2.contains(iEntity)) continue;
                this.printEntity(stringBuilder, iEntity);
            }
            for (IEntity iEntity : hashSet2) {
                stringBuilder.append("subgraph cluster" + iEntity.getUid() + "lol {");
                stringBuilder.append("style=invis;");
                stringBuilder.append("label=\"\";");
                this.printEntity(stringBuilder, iEntity);
                for (IEntity iEntity2 : this.getAllLollipop(iEntity)) {
                    Link link = this.getLinkLollipop(iEntity2, iEntity);
                    String string = this.getHeadOrTail(iEntity2, link);
                    this.printEntity(stringBuilder, iEntity2, string);
                    this.printLink(stringBuilder, link);
                }
                stringBuilder.append("}");
            }
        }
    }

    private Collection<IEntity> getAllLollipop(IEntity iEntity) {
        ArrayList<IEntity> arrayList = new ArrayList<IEntity>();
        for (IEntity iEntity2 : this.getData().getAllLinkedDirectedTo(iEntity)) {
            if (iEntity2.getType() != EntityType.LOLLIPOP) continue;
            arrayList.add(iEntity2);
        }
        return arrayList;
    }

    private IEntity getConnectedToLollipop(IEntity iEntity) {
        assert (iEntity.getType() == EntityType.LOLLIPOP);
        Set<IEntity> set = this.getData().getAllLinkedDirectedTo(iEntity);
        if (set.size() != 1) {
            throw new IllegalStateException("size=" + set.size());
        }
        return (IEntity)set.iterator().next();
    }

    private Link getLinkLollipop(IEntity iEntity, IEntity iEntity2) {
        assert (iEntity.getType() == EntityType.LOLLIPOP);
        for (Link link : this.getData().getLinks()) {
            if (!link.isBetween(iEntity, iEntity2)) continue;
            return link;
        }
        throw new IllegalArgumentException();
    }

    private void printEntity(StringBuilder stringBuilder, IEntity iEntity, String string) throws IOException {
        EntityType entityType = iEntity.getType();
        if (entityType != EntityType.LOLLIPOP) {
            throw new IllegalStateException(entityType.toString() + " " + (Object)((Object)this.getData().getUmlDiagramType()));
        }
        String string2 = this.getColorString(ColorParam.classBackground, null);
        String string3 = this.getColorString(ColorParam.classBorder, null);
        String string4 = this.getColorString(ColorParam.background, null);
        String string5 = this.manageHtmlIB(iEntity.getDisplay(), FontParam.CLASS_ATTRIBUTE, null);
        stringBuilder.append(iEntity.getUid() + " [fillcolor=" + string2 + ",color=" + string3 + ",style=\"filled\"," + "shape=circle,width=0.12,height=0.12,label=\"\"];");
        stringBuilder.append(iEntity.getUid() + " -> " + iEntity.getUid() + "[color=" + string4 + ",arrowtail=none,arrowhead=none," + string + "=<" + string5 + ">];");
    }

    private void printEntity(StringBuilder stringBuilder, IEntity iEntity) throws IOException {
        Object object;
        String string;
        EntityType entityType = iEntity.getType();
        String string2 = this.getLabel(iEntity);
        if (entityType == EntityType.GROUP) {
            return;
        }
        boolean bl = false;
        String string3 = string = iEntity.getStereotype() == null ? null : iEntity.getStereotype().getLabel();
        if (entityType == EntityType.ABSTRACT_CLASS || entityType == EntityType.CLASS || entityType == EntityType.INTERFACE || entityType == EntityType.ENUM) {
            object = iEntity.hasNearDecoration() || this.MODE_LOLLIPOP_BETA ? " [fontcolor=" + this.getFontColorString(FontParam.CLASS, string) + "color=" + this.getBackColorAroundEntity(iEntity) + ",margin=0,style=filled,shape=plaintext," + string2 : " [fontcolor=" + this.getFontColorString(FontParam.CLASS, string) + ",margin=0,fillcolor=" + this.getColorString(ColorParam.classBackground, string) + ",color=" + this.getColorString(ColorParam.classBorder, string) + ",style=filled,shape=box," + string2;
            stringBuilder.append(iEntity.getUid() + (String)object);
        } else if (entityType == EntityType.OBJECT) {
            stringBuilder.append(iEntity.getUid() + " [fontcolor=" + this.getFontColorString(FontParam.CLASS, string) + ",margin=0,fillcolor=" + this.getColorString(ColorParam.classBackground, string) + ",color=" + this.getColorString(ColorParam.classBorder, string) + ",style=filled,shape=record," + string2);
        } else if (entityType == EntityType.USECASE) {
            stringBuilder.append(iEntity.getUid() + " [fontcolor=" + this.getFontColorString(FontParam.USECASE, string) + ",fillcolor=" + this.getColorString(ColorParam.usecaseBackground, string) + ",color=" + this.getColorString(ColorParam.usecaseBorder, string) + ",style=filled," + string2);
        } else if (entityType == EntityType.ACTOR) {
            stringBuilder.append(iEntity.getUid() + " [fontcolor=" + this.getFontColorString(FontParam.USECASE_ACTOR, string) + ",margin=0,shape=plaintext," + string2);
        } else if (entityType == EntityType.CIRCLE_INTERFACE) {
            stringBuilder.append(iEntity.getUid() + " [margin=0,shape=plaintext," + string2);
        } else if (entityType == EntityType.COMPONENT) {
            stringBuilder.append(iEntity.getUid() + " [margin=0.2,fontcolor=" + this.getFontColorString(FontParam.COMPONENT, string) + ",fillcolor=" + this.getColorString(ColorParam.componentBackground, string) + ",color=" + this.getColorString(ColorParam.componentBorder, string) + ",style=filled,shape=component," + string2);
        } else if (entityType == EntityType.NOTE && this.getData().getDpi() != 96) {
            stringBuilder.append(iEntity.getUid() + " [margin=0,pad=0,shape=plaintext,label=" + this.getLabelForNoteDpi(iEntity));
        } else if (entityType == EntityType.NOTE) {
            object = iEntity.getImageFile();
            if (object == null) {
                throw new IllegalStateException("No file for NOTE");
            }
            if (!((DrawFile)object).getPngOrEps(this.fileFormat).exists()) {
                throw new IllegalStateException();
            }
            String string4 = StringUtils.getPlateformDependentAbsolutePath(((DrawFile)object).getPngOrEps(this.fileFormat));
            stringBuilder.append(iEntity.getUid() + " [margin=0,pad=0," + string2 + ",shape=none,image=\"" + string4 + "\"");
        } else if (entityType == EntityType.ACTIVITY) {
            object = "octagon";
            if (!this.getData().getSkinParam().useOctagonForActivity() || iEntity.getImageFile() != null) {
                object = "rect";
            }
            stringBuilder.append(iEntity.getUid() + " [fontcolor=" + this.getFontColorString(FontParam.ACTIVITY, string) + ",fillcolor=" + this.getBackColorOfEntity(iEntity) + ",color=" + this.getColorString(ColorParam.activityBorder, string) + ",style=\"rounded,filled\",shape=" + (String)object + "," + string2);
        } else if (entityType == EntityType.BRANCH) {
            stringBuilder.append(iEntity.getUid() + " [fillcolor=" + this.getBackColorOfEntity(iEntity) + ",color=" + this.getColorString(ColorParam.activityBorder, string) + ",style=\"filled\",shape=diamond,height=.25,width=.25,label=\"\"");
        } else if (entityType == EntityType.SYNCHRO_BAR) {
            object = this.getColorString(ColorParam.activityBar, null);
            stringBuilder.append(iEntity.getUid() + " [fillcolor=" + (String)object + ",color=" + (String)object + ",style=\"filled\"," + "shape=rect,height=.08,width=1.30,label=\"\"");
        } else if (entityType == EntityType.CIRCLE_START) {
            object = this.getColorString(this.getStartColorParam(), null);
            stringBuilder.append(iEntity.getUid() + " [fillcolor=" + (String)object + ",color=" + (String)object + ",style=\"filled\"," + "shape=circle,width=.20,height=.20,label=\"\"");
        } else if (entityType == EntityType.CIRCLE_END) {
            object = this.getColorString(this.getEndColorParam(), null);
            stringBuilder.append(iEntity.getUid() + " [fillcolor=" + (String)object + ",color=" + (String)object + ",style=\"filled\"," + "shape=doublecircle,width=.13,height=.13,label=\"\"");
        } else if (entityType == EntityType.POINT_FOR_ASSOCIATION) {
            stringBuilder.append(iEntity.getUid() + " [width=.05,shape=point,color=" + this.getColorString(ColorParam.classBorder, null));
        } else if (entityType == EntityType.STATE) {
            stringBuilder.append(iEntity.getUid() + " [color=" + this.getColorString(ColorParam.stateBorder, string) + ",shape=record,style=\"rounded,filled\",color=" + this.getColorString(ColorParam.stateBorder, string));
            if (iEntity.getImageFile() == null) {
                stringBuilder.append(",fillcolor=" + this.getBackColorOfEntity(iEntity));
            } else {
                stringBuilder.append(",fillcolor=" + this.getBackColorOfEntity(iEntity));
            }
            stringBuilder.append("," + string2);
        } else if (entityType == EntityType.STATE_CONCURRENT) {
            object = iEntity.getImageFile();
            if (object == null) {
                throw new IllegalStateException();
            }
            if (!((DrawFile)object).getPng().exists()) {
                throw new IllegalStateException();
            }
            String string5 = StringUtils.getPlateformDependentAbsolutePath(((DrawFile)object).getPng());
            stringBuilder.append(iEntity.getUid() + " [margin=1,pad=1," + string2 + ",style=dashed,shape=box,image=\"" + string5 + "\"");
        } else if (entityType == EntityType.ACTIVITY_CONCURRENT) {
            object = iEntity.getImageFile();
            if (object == null) {
                throw new IllegalStateException();
            }
            if (!((DrawFile)object).getPng().exists()) {
                throw new IllegalStateException();
            }
            String string6 = StringUtils.getPlateformDependentAbsolutePath(((DrawFile)object).getPng());
            stringBuilder.append(iEntity.getUid() + " [margin=0,pad=0," + string2 + ",style=dashed,shape=box,image=\"" + string6 + "\"");
        } else if (entityType == EntityType.EMPTY_PACKAGE) {
            stringBuilder.append(iEntity.getUid() + " [margin=0.2,fontcolor=" + this.getFontColorString(FontParam.PACKAGE, null) + ",fillcolor=" + this.getColorString(ColorParam.packageBackground, null) + ",color=" + this.getColorString(ColorParam.packageBorder, null) + ",style=filled,shape=tab," + string2);
        } else {
            throw new IllegalStateException(entityType.toString() + " " + (Object)((Object)this.getData().getUmlDiagramType()));
        }
        if (this.getData().hasUrl() && iEntity.getUrl() != null) {
            object = iEntity.getUrl();
            stringBuilder.append(",URL=\"" + ((Url)object).getUrl() + "\"");
            stringBuilder.append(",tooltip=\"" + ((Url)object).getTooltip() + "\"");
        }
        stringBuilder.append("];");
        if (bl) {
            stringBuilder.append("}");
        }
        if (iEntity.isTop()) {
            this.rankMin.add(iEntity.getUid());
        }
    }

    private ColorParam getEndColorParam() {
        if (this.getData().getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            return ColorParam.activityEnd;
        }
        if (this.getData().getUmlDiagramType() == UmlDiagramType.STATE) {
            return ColorParam.stateEnd;
        }
        throw new IllegalStateException(this.getData().getUmlDiagramType().toString());
    }

    private ColorParam getStartColorParam() {
        if (this.getData().getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            return ColorParam.activityStart;
        }
        if (this.getData().getUmlDiagramType() == UmlDiagramType.STATE) {
            return ColorParam.stateStart;
        }
        throw new IllegalStateException(this.getData().getUmlDiagramType().toString());
    }

    private String getHeadOrTail(IEntity iEntity, Link link) {
        assert (iEntity.getType() == EntityType.LOLLIPOP);
        if (link.getLength() > 1 && link.getEntity1() == iEntity) {
            return "taillabel";
        }
        return "headlabel";
    }

    private String getLabel(IEntity iEntity) throws IOException {
        if (iEntity.getType() == EntityType.ABSTRACT_CLASS || iEntity.getType() == EntityType.CLASS || iEntity.getType() == EntityType.INTERFACE || iEntity.getType() == EntityType.ENUM) {
            return "label=" + this.getLabelForClassOrInterfaceOrEnum(iEntity);
        }
        if (iEntity.getType() == EntityType.LOLLIPOP) {
            return "label=" + this.getLabelForLollipop(iEntity);
        }
        if (iEntity.getType() == EntityType.OBJECT) {
            return "label=" + this.getLabelForObject(iEntity);
        }
        if (iEntity.getType() == EntityType.ACTOR) {
            return "label=" + this.getLabelForActor(iEntity);
        }
        if (iEntity.getType() == EntityType.CIRCLE_INTERFACE) {
            return "label=" + this.getLabelForCircleInterface(iEntity);
        }
        if (iEntity.getType() == EntityType.NOTE) {
            return "label=\"\"";
        }
        if (iEntity.getType() == EntityType.STATE_CONCURRENT) {
            return "label=\"\"";
        }
        if (iEntity.getType() == EntityType.ACTIVITY_CONCURRENT) {
            return "label=\"\"";
        }
        if (iEntity.getType() == EntityType.COMPONENT) {
            return "label=" + this.getLabelForComponent(iEntity);
        }
        if (iEntity.getType() == EntityType.ACTIVITY) {
            DrawFile drawFile = iEntity.getImageFile();
            if (drawFile != null) {
                String string = StringUtils.getPlateformDependentAbsolutePath(drawFile.getPng());
                String string2 = "\"" + this.getAsHtml(this.getData().getSkinParam().getBackgroundColor()) + "\"";
                StringBuilder stringBuilder = new StringBuilder("label=<");
                stringBuilder.append("<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\">");
                stringBuilder.append("<TR>");
                stringBuilder.append("<TD BGCOLOR=" + string2 + " BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"2\">");
                stringBuilder.append("<IMG SRC=\"" + string + "\"/></TD></TR>");
                stringBuilder.append("</TABLE>");
                stringBuilder.append(">");
                return stringBuilder.toString();
            }
            String string = iEntity.getStereotype() == null ? null : iEntity.getStereotype().getLabel();
            return "label=" + this.getSimpleLabelAsHtml(iEntity, FontParam.ACTIVITY, string);
        }
        if (iEntity.getType() == EntityType.EMPTY_PACKAGE) {
            return "label=" + this.getSimpleLabelAsHtml(iEntity, this.getFontParamForGroup(), null);
        }
        if (iEntity.getType() == EntityType.USECASE) {
            return "label=" + this.getLabelForUsecase(iEntity);
        }
        if (iEntity.getType() == EntityType.STATE) {
            return "label=" + this.getLabelForState(iEntity);
        }
        if (iEntity.getType() == EntityType.BRANCH) {
            return "label=\"\"";
        }
        return "label=\"" + iEntity.getDisplay() + "\"";
    }

    private String getSimpleLabelAsHtml(IEntity iEntity, FontParam fontParam, String string) {
        return "<" + this.manageHtmlIB(iEntity.getDisplay(), fontParam, string) + ">";
    }

    private String getBackColorOfEntity(IEntity iEntity) {
        String string;
        if (iEntity.getSpecificBackColor() != null) {
            return "\"" + this.getAsHtml(iEntity.getSpecificBackColor()) + "\"";
        }
        String string2 = string = iEntity.getStereotype() == null ? null : iEntity.getStereotype().getLabel();
        if (iEntity.getType() == EntityType.STATE || iEntity.getType() == EntityType.STATE_CONCURRENT) {
            return this.getColorString(ColorParam.stateBackground, string);
        }
        if (iEntity.getType() == EntityType.ACTIVITY || iEntity.getType() == EntityType.ACTIVITY_CONCURRENT || iEntity.getType() == EntityType.BRANCH) {
            return this.getColorString(ColorParam.activityBackground, string);
        }
        throw new IllegalArgumentException(iEntity.getType().toString());
    }

    private String getLabelForState(IEntity iEntity) throws IOException {
        DrawFile drawFile = iEntity.getImageFile();
        String string = this.getBackColorOfEntity(iEntity);
        String string2 = iEntity.getStereotype() == null ? null : iEntity.getStereotype().getLabel();
        StringBuilder stringBuilder = new StringBuilder("<{<TABLE BGCOLOR=" + string + " BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\">");
        stringBuilder.append("<TR><TD>" + this.manageHtmlIB(iEntity.getDisplay(), FontParam.STATE, string2) + "</TD></TR>");
        stringBuilder.append("</TABLE>");
        if (iEntity.getFieldsToDisplay().size() > 0) {
            stringBuilder.append("|");
            for (Member object : iEntity.getFieldsToDisplay()) {
                stringBuilder.append(this.manageHtmlIB(object.getDisplayWithVisibilityChar(), FontParam.STATE_ATTRIBUTE, string2));
                stringBuilder.append("<BR ALIGN=\"LEFT\"/>");
            }
        }
        if (drawFile != null) {
            stringBuilder.append("|");
            String string3 = StringUtils.getPlateformDependentAbsolutePath(drawFile.getPng());
            String string4 = "\"" + this.getAsHtml(this.getData().getSkinParam().getBackgroundColor()) + "\"";
            stringBuilder.append("<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\">");
            stringBuilder.append("<TR>");
            stringBuilder.append("<TD BGCOLOR=" + string4 + " BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"2\">");
            stringBuilder.append("<IMG SRC=\"" + (String)string3 + "\"/></TD></TR>");
            stringBuilder.append("</TABLE>");
        }
        if (!this.getData().isHideEmptyDescription() && iEntity.getFieldsToDisplay().size() == 0 && drawFile == null) {
            stringBuilder.append("|");
        }
        stringBuilder.append("}>");
        return stringBuilder.toString();
    }

    private String getLabelForUsecase(IEntity iEntity) {
        String string;
        Stereotype stereotype = this.getStereotype(iEntity);
        String string2 = string = iEntity.getStereotype() == null ? null : iEntity.getStereotype().getLabel();
        if (stereotype == null) {
            return this.getSimpleLabelAsHtml(iEntity, FontParam.USECASE, string);
        }
        StringBuilder stringBuilder = new StringBuilder("<<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\">");
        if (this.isThereLabel(stereotype)) {
            stringBuilder.append("<TR><TD>" + this.manageHtmlIB(stereotype.getLabel(), FontParam.USECASE_STEREOTYPE, string) + "</TD></TR>");
        }
        stringBuilder.append("<TR><TD>" + this.manageHtmlIB(iEntity.getDisplay(), FontParam.USECASE, string) + "</TD></TR>");
        stringBuilder.append("</TABLE>>");
        return stringBuilder.toString();
    }

    private String getLabelForComponent(IEntity iEntity) {
        Stereotype stereotype = this.getStereotype(iEntity);
        if (stereotype == null) {
            return this.getSimpleLabelAsHtml(iEntity, FontParam.COMPONENT, null);
        }
        String string = stereotype.getLabel();
        StringBuilder stringBuilder = new StringBuilder("<<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\">");
        if (this.isThereLabel(stereotype)) {
            stringBuilder.append("<TR><TD>" + this.manageHtmlIB(stereotype.getLabel(), FontParam.COMPONENT_STEREOTYPE, string) + "</TD></TR>");
        }
        stringBuilder.append("<TR><TD>" + this.manageHtmlIB(iEntity.getDisplay(), FontParam.COMPONENT, string) + "</TD></TR>");
        stringBuilder.append("</TABLE>>");
        return stringBuilder.toString();
    }

    private String getLabelForNoteDpi(IEntity iEntity) throws IOException {
        DrawFile drawFile = iEntity.getImageFile();
        if (drawFile == null) {
            throw new IllegalStateException("No file for NOTE");
        }
        if (!drawFile.getPngOrEps(this.fileFormat).exists()) {
            throw new IllegalStateException();
        }
        String string = StringUtils.getPlateformDependentAbsolutePath(drawFile.getPngOrEps(this.fileFormat));
        StringBuilder stringBuilder = new StringBuilder("<<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\">");
        stringBuilder.append("<TR>");
        this.addTdImageBugB1983(stringBuilder, string);
        stringBuilder.append("</TR>");
        stringBuilder.append("</TABLE>>");
        return stringBuilder.toString();
    }

    private String getLabelForActor(IEntity iEntity) throws IOException {
        String string = StringUtils.getPlateformDependentAbsolutePath(iEntity.getImageFile().getPngOrEps(this.fileFormat));
        Stereotype stereotype = this.getStereotype(iEntity);
        String string2 = iEntity.getStereotype() == null ? null : iEntity.getStereotype().getLabel();
        StringBuilder stringBuilder = new StringBuilder("<<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\">");
        if (this.isThereLabel(stereotype)) {
            stringBuilder.append("<TR><TD>" + this.manageHtmlIB(stereotype.getLabel(), FontParam.USECASE_ACTOR_STEREOTYPE, string2) + "</TD></TR>");
        }
        if (this.getData().getDpi() == 96) {
            stringBuilder.append("<TR><TD><IMG SRC=\"" + string + "\"/></TD></TR>");
        } else {
            stringBuilder.append("<TR>");
            this.addTdImageBugB1983(stringBuilder, string);
            stringBuilder.append("</TR>");
        }
        stringBuilder.append("<TR><TD>" + this.manageHtmlIB(iEntity.getDisplay(), FontParam.USECASE_ACTOR, string2) + "</TD></TR>");
        stringBuilder.append("</TABLE>>");
        return stringBuilder.toString();
    }

    private String getLabelForCircleInterface(IEntity iEntity) throws IOException {
        String string = StringUtils.getPlateformDependentAbsolutePath(iEntity.getImageFile().getPngOrEps(this.fileFormat));
        Stereotype stereotype = this.getStereotype(iEntity);
        String string2 = iEntity.getStereotype() == null ? null : iEntity.getStereotype().getLabel();
        StringBuilder stringBuilder = new StringBuilder("<<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\">");
        if (this.isThereLabel(stereotype)) {
            stringBuilder.append("<TR><TD>" + this.manageHtmlIB(stereotype.getLabel(), FontParam.COMPONENT_STEREOTYPE, string2) + "</TD></TR>");
        }
        stringBuilder.append("<TR>");
        if (this.getData().getDpi() == 96) {
            stringBuilder.append("<TD><IMG SRC=\"" + string + "\"/></TD>");
        } else {
            this.addTdImageBugB1983(stringBuilder, string);
        }
        stringBuilder.append("</TR>");
        stringBuilder.append("<TR><TD>" + this.manageHtmlIB(iEntity.getDisplay(), FontParam.COMPONENT, string2) + "</TD></TR>");
        stringBuilder.append("</TABLE>>");
        return stringBuilder.toString();
    }

    private String getLabelForLollipop(IEntity iEntity) throws IOException {
        String string = iEntity.getStereotype() == null ? null : iEntity.getStereotype().getLabel();
        String string2 = StringUtils.getPlateformDependentAbsolutePath(this.getData().getStaticImages(EntityType.LOLLIPOP, string).getPngOrEps(this.fileFormat));
        Stereotype stereotype = this.getStereotype(iEntity);
        StringBuilder stringBuilder = new StringBuilder("<<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\">");
        if (this.isThereLabel(stereotype)) {
            stringBuilder.append("<TR><TD>" + this.manageHtmlIB(stereotype.getLabel(), FontParam.CLASS, null) + "</TD></TR>");
        }
        stringBuilder.append("<TR>");
        if (this.getData().getDpi() == 96) {
            stringBuilder.append("<TD><IMG SRC=\"" + string2 + "\"/></TD>");
        } else {
            this.addTdImageBugB1983(stringBuilder, string2);
        }
        stringBuilder.append("</TR>");
        stringBuilder.append("<TR><TD>" + this.manageHtmlIB(iEntity.getDisplay(), FontParam.CLASS, null) + "</TD></TR>");
        stringBuilder.append("</TABLE>>");
        return stringBuilder.toString();
    }

    private String getLabelForClassOrInterfaceOrEnum(IEntity iEntity) throws IOException {
        if (this.isVisibilityModifierPresent) {
            return this.getLabelForClassOrInterfaceOrEnumWithVisibilityImage(iEntity);
        }
        return this.getLabelForClassOrInterfaceOrEnumOld(iEntity);
    }

    private String getLabelForClassOrInterfaceOrEnumOld(IEntity iEntity) throws IOException {
        Object object;
        LabelBuilderObjectOrClass labelBuilderObjectOrClass = new LabelBuilderClassOld(this.getFileFormat(), this.getData(), iEntity);
        if (this.MODE_LOLLIPOP_BETA) {
            String string;
            object = this.getData().getStaticImages(iEntity.getType(), null);
            String string2 = string = StringUtils.getPlateformDependentAbsolutePath(((DrawFile)object).getPngOrEps(this.getFileFormat()));
            String string3 = string;
            String string4 = string;
            labelBuilderObjectOrClass = new LabelBuilderTableLollipopDecorator(this.getFileFormat(), this.getData(), iEntity, labelBuilderObjectOrClass, string, string2, string3, string4, this.getAllLollipop(iEntity));
        } else if (iEntity.hasNearDecoration()) {
            labelBuilderObjectOrClass = new LabelBuilderTableNineDecorator(this.getFileFormat(), this.getData(), iEntity, labelBuilderObjectOrClass);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("<");
        labelBuilderObjectOrClass.appendLabel((StringBuilder)object);
        if (labelBuilderObjectOrClass.isUnderline()) {
            this.setUnderline(true);
        }
        ((StringBuilder)object).append(">");
        return ((StringBuilder)object).toString();
    }

    private String addFieldsEps(List<Member> list, boolean bl) throws IOException {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Member object22 : list) {
            object = object22.getDisplay(bl);
            if (object22.isAbstract()) {
                object = "<i>" + (String)object + "</i>";
            }
            if (object22.isStatic()) {
                object = "<u>" + (String)object + "</u>";
            }
            arrayList.add((String)object);
        }
        UFont uFont = this.getData().getSkinParam().getFont(FontParam.CLASS_ATTRIBUTE, null);
        HtmlColor htmlColor = this.getFontHtmlColor(FontParam.CLASS_ATTRIBUTE, null);
        object = TextBlockUtils.create(arrayList, new FontConfiguration(uFont, htmlColor), HorizontalAlignement.LEFT);
        File file = FileUtils.createTempFile("member", ".eps");
        UGraphicEps.copyEpsToFile(this.getData().getColorMapper(), new UDrawable((TextBlock)object){
            final /* synthetic */ TextBlock val$text;
            {
                this.val$text = textBlock;
            }

            public void drawU(UGraphic uGraphic) {
                this.val$text.drawU(uGraphic, 0.0, 0.0);
            }
        }, file);
        this.fileToClean.add(file);
        String string = StringUtils.getPlateformDependentAbsolutePath(file);
        return "<TR ALIGN=\"LEFT\"><TD ALIGN=\"LEFT\"><TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\"><TR><TD><IMG SRC=\"" + string + "\"/>" + "</TD>" + "<TD></TD>" + "</TR></TABLE></TD></TR>";
    }

    private String getLabelForClassOrInterfaceOrEnumWithVisibilityImage(IEntity iEntity) throws IOException {
        LabelBuilderObjectOrClass labelBuilderObjectOrClass = new LabelBuilderClassWithVisibilityImage(this.fileFormat, this.getData(), iEntity);
        if (iEntity.hasNearDecoration()) {
            labelBuilderObjectOrClass = new LabelBuilderTableNineDecorator(this.getFileFormat(), this.getData(), iEntity, labelBuilderObjectOrClass);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<");
        labelBuilderObjectOrClass.appendLabel(stringBuilder);
        if (labelBuilderObjectOrClass.isUnderline()) {
            this.setUnderline(true);
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    private String getLabelForObject(IEntity iEntity) throws IOException {
        if (this.isVisibilityModifierPresent) {
            return this.getLabelForObjectWithVisibilityImage(iEntity);
        }
        return this.getLabelForObjectOld(iEntity);
    }

    private String getLabelForObjectWithVisibilityImage(IEntity iEntity) throws IOException {
        LabelBuilderObjectWithVisibilityImage labelBuilderObjectWithVisibilityImage = new LabelBuilderObjectWithVisibilityImage(this.getFileFormat(), this.getData(), iEntity);
        StringBuilder stringBuilder = new StringBuilder();
        labelBuilderObjectWithVisibilityImage.appendLabel(stringBuilder);
        if (labelBuilderObjectWithVisibilityImage.isUnderline()) {
            this.setUnderline(true);
        }
        return stringBuilder.toString();
    }

    private String getLabelForObjectOld(IEntity iEntity) throws IOException {
        LabelBuilderObjectOld labelBuilderObjectOld = new LabelBuilderObjectOld(this.getFileFormat(), this.getData(), iEntity);
        StringBuilder stringBuilder = new StringBuilder();
        labelBuilderObjectOld.appendLabel(stringBuilder);
        if (labelBuilderObjectOld.isUnderline()) {
            this.setUnderline(true);
        }
        return stringBuilder.toString();
    }

    private boolean isSpecialGroup(Group group) {
        if (group.getType() == GroupType.STATE) {
            return true;
        }
        if (group.getType() == GroupType.CONCURRENT_STATE) {
            throw new IllegalStateException();
        }
        return this.getData().isThereLink(group);
    }

    private static final String getLastDotSignature() {
        return lastDotSignature;
    }

    public static final void reset() {
        lastDotSignature = null;
    }

    @Override
    public void clean() {
        if (OptionFlags.getInstance().isKeepTmpFiles()) {
            return;
        }
        for (File file : this.fileToClean) {
            Log.info("Deleting temporary file " + file);
            boolean bl = file.delete();
            if (bl) continue;
            Log.error("Cannot delete: " + file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntityComparator2
    implements Comparator<IEntity> {
        private final Map<IEntity, Integer> map;

        public EntityComparator2(Map<IEntity, Integer> map) {
            this.map = map;
        }

        @Override
        public int compare(IEntity iEntity, IEntity iEntity2) {
            Integer n;
            Integer n2 = this.map.get(iEntity);
            int n3 = n2.compareTo(n = this.map.get(iEntity2));
            if (n3 != 0) {
                return -n3;
            }
            return iEntity.compareTo(iEntity2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntityComparator
    implements Comparator<IEntity> {
        EntityComparator() {
        }

        @Override
        public int compare(IEntity iEntity, IEntity iEntity2) {
            int n;
            int n2 = iEntity.getXposition();
            if (n2 < (n = iEntity2.getXposition())) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return iEntity.compareTo(iEntity2);
        }
    }
}

