/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frame
implements Component {
    private final List<String> name;
    private final ISkinParam skinParam;
    private final Rose rose = new Rose();

    public Frame(List<String> list, ISkinParam iSkinParam) {
        this.name = list;
        this.skinParam = iSkinParam;
    }

    @Override
    public void drawU(UGraphic uGraphic, Dimension2D dimension2D, Context2D context2D) {
        HtmlColor htmlColor = this.rose.getHtmlColor(this.skinParam, ColorParam.packageBorder);
        uGraphic.getParam().setColor(htmlColor);
        uGraphic.getParam().setBackcolor(null);
        uGraphic.getParam().setStroke(new UStroke(1.4));
        uGraphic.draw(0.0, 0.0, new URectangle(dimension2D.getWidth(), dimension2D.getHeight()));
        uGraphic.getParam().setStroke(new UStroke());
        TextBlock textBlock = this.createTextBloc();
        textBlock.drawU(uGraphic, 2.0, 2.0);
        Dimension2D dimension2D2 = this.getTextDim(uGraphic.getStringBounder());
        double d = dimension2D2.getWidth() + 6.0;
        double d2 = dimension2D2.getHeight() + 6.0;
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(d, 0.0);
        uPolygon.addPoint(d, d2 - 6.0);
        uPolygon.addPoint(d - 6.0, d2);
        uPolygon.addPoint(0.0, d2);
        uPolygon.addPoint(0.0, 0.0);
        uGraphic.getParam().setColor(htmlColor);
        uGraphic.getParam().setStroke(new UStroke(1.4));
        uGraphic.draw(0.0, 0.0, uPolygon);
        uGraphic.getParam().setStroke(new UStroke());
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        Dimension2D dimension2D = this.getTextDim(stringBounder);
        return dimension2D.getHeight() + 8.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        Dimension2D dimension2D = this.getTextDim(stringBounder);
        return dimension2D.getWidth() + 8.0;
    }

    public Dimension2D getTextDim(StringBounder stringBounder) {
        TextBlock textBlock = this.createTextBloc();
        return textBlock.calculateDimension(stringBounder);
    }

    private TextBlock createTextBloc() {
        UFont uFont = this.skinParam.getFont(FontParam.PACKAGE, null);
        HtmlColor htmlColor = this.skinParam.getFontHtmlColor(FontParam.PACKAGE, null);
        TextBlock textBlock = TextBlockUtils.create(this.name, new FontConfiguration(uFont, htmlColor), HorizontalAlignement.LEFT);
        return textBlock;
    }
}

