/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.suggest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.sourceforge.plantuml.StartUtils;
import net.sourceforge.plantuml.UmlSource;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.PSystemCommandFactory;
import net.sourceforge.plantuml.command.ProtectedCommand;
import net.sourceforge.plantuml.suggest.SuggestEngineResult;
import net.sourceforge.plantuml.suggest.SuggestEngineStatus;
import net.sourceforge.plantuml.suggest.VariatorAddOneCharBetweenWords;
import net.sourceforge.plantuml.suggest.VariatorIteratorAdaptor;
import net.sourceforge.plantuml.suggest.VariatorRemoveOneChar;
import net.sourceforge.plantuml.suggest.VariatorSwapLetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SuggestEngine {
    private final PSystemCommandFactory systemFactory;
    private final Iterator<String> it;
    private String current = "";
    private String previous = "";

    public SuggestEngine(UmlSource umlSource, PSystemCommandFactory pSystemCommandFactory) {
        this.systemFactory = pSystemCommandFactory;
        this.it = umlSource.iterator();
        if (!StartUtils.isArobaseStartDiagram(this.next())) {
            throw new UnsupportedOperationException();
        }
    }

    private boolean hasNext() {
        return this.it.hasNext();
    }

    private String next() {
        this.previous = this.current;
        this.current = this.it.next();
        return this.current;
    }

    public SuggestEngineResult tryToSuggest() throws IOException {
        return this.executeUmlCommand();
    }

    private SuggestEngineResult executeUmlCommand() throws IOException {
        this.systemFactory.init();
        while (this.hasNext()) {
            String string = this.next();
            if (StartUtils.isArobaseEndDiagram(string)) {
                return SuggestEngineResult.SYNTAX_OK;
            }
            SuggestEngineResult suggestEngineResult = this.checkAndCorrect(string);
            if (suggestEngineResult.getStatus() != SuggestEngineStatus.SYNTAX_OK) {
                return suggestEngineResult;
            }
            CommandControl commandControl = this.systemFactory.isValid(Arrays.asList(string));
            if (commandControl == CommandControl.OK_PARTIAL) {
                boolean bl = this.manageMultiline(string);
                if (bl) continue;
                return SuggestEngineResult.CANNOT_CORRECT;
            }
            if (commandControl == CommandControl.OK) {
                ProtectedCommand protectedCommand = new ProtectedCommand(this.systemFactory.createCommand(Arrays.asList(string)));
                CommandExecutionResult commandExecutionResult = protectedCommand.execute(Arrays.asList(string));
                if (commandExecutionResult.isOk()) continue;
                return SuggestEngineResult.CANNOT_CORRECT;
            }
            assert (false);
        }
        throw new IllegalStateException();
    }

    private boolean manageMultiline(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        while (this.hasNext()) {
            String string2 = this.next();
            if (StartUtils.isArobaseEndDiagram(string2)) {
                return false;
            }
            arrayList.add(string2);
            CommandControl commandControl = this.systemFactory.isValid(arrayList);
            if (commandControl == CommandControl.NOT_OK) {
                throw new IllegalStateException();
            }
            if (commandControl != CommandControl.OK) continue;
            return true;
        }
        return false;
    }

    SuggestEngineResult checkAndCorrect(String string) {
        CommandControl commandControl = this.systemFactory.isValid(Arrays.asList(string));
        if (commandControl != CommandControl.NOT_OK) {
            return SuggestEngineResult.SYNTAX_OK;
        }
        if (string.trim().startsWith("{") && this.systemFactory.isValid(Arrays.asList(this.previous + " {")) != CommandControl.NOT_OK) {
            return new SuggestEngineResult(this.previous + " {");
        }
        ArrayList<VariatorIteratorAdaptor> arrayList = new ArrayList<VariatorIteratorAdaptor>();
        arrayList.add(new VariatorRemoveOneChar(string));
        arrayList.add(new VariatorSwapLetter(string));
        arrayList.add(new VariatorAddOneCharBetweenWords(string, '-'));
        arrayList.add(new VariatorAddOneCharBetweenWords(string, ' '));
        for (Iterator iterator : arrayList) {
            SuggestEngineResult suggestEngineResult = this.tryThis(iterator);
            if (suggestEngineResult == null) continue;
            return suggestEngineResult;
        }
        return SuggestEngineResult.CANNOT_CORRECT;
    }

    private SuggestEngineResult tryThis(Iterator<String> iterator) {
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.trim().length() == 0) continue;
            CommandControl commandControl = this.systemFactory.isValid(Arrays.asList(string));
            if (commandControl == CommandControl.NOT_OK) continue;
            return new SuggestEngineResult(string);
        }
        return null;
    }
}

