/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.common;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.core.CoreContainer;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.UnsupportedType;
import org.xml.sax.SAXException;

public class SolrServerFactory {
    public static final String SOLR_HOME_PROPERTY_NAME = "solr.homeDir";
    public static final String SOLR_CONFIG_FILE_NAME_PROPERTY_NAME = "solr.configFileName";
    public static final String SOLR_COLLECTION_NAME_PROPERTY_NAME = "solr.collectionName";
    public static final String SOLR_SERVER_CLASSNAME_PROPERTY_NAME = "solr.server.classname";
    public static final String SOLR_ENPOINT_PROPERTY_NAME = "solr.endpoint";
    private static final String EMBEDDEDSERVERCLASS = "org.apache.solr.client.solrj.embedded.EmbeddedSolrServer";
    private static final String HTTPSERVERCLASS = "org.apache.solr.client.solrj.impl.CommonsHttpSolrServer";
    public static Log log = LogFactory.getLog(SolrServerFactory.class);
    private static CoreContainer coreContainer = null;
    private static String collectionName = null;
    private static SolrServer solrServer = null;

    public static SolrServer createSolrServer() throws ParserConfigurationException, IOException, SAXException, UnsupportedType {
        if (solrServer == null) {
            String className = Settings.getConfiguration().getString(SOLR_SERVER_CLASSNAME_PROPERTY_NAME);
            if (className != null && className.equals(EMBEDDEDSERVERCLASS)) {
                SolrServerFactory.generateEmbeddedServer();
            } else if (className != null && className.equals(HTTPSERVERCLASS)) {
                String solrServerBaseURL = Settings.getConfiguration().getString(SOLR_ENPOINT_PROPERTY_NAME);
                solrServer = new CommonsHttpSolrServer(solrServerBaseURL);
            } else {
                throw new UnsupportedType("0000", "SolrServerFactory.createSolrServer - MetacatIndex doesn't support this solr server type: " + className);
            }
        }
        return solrServer;
    }

    private static void generateEmbeddedServer() throws ParserConfigurationException, IOException, SAXException {
        String solrHomeDir = Settings.getConfiguration().getString(SOLR_HOME_PROPERTY_NAME);
        log.info((Object)("The configured solr home from properties is " + solrHomeDir));
        String configFileName = Settings.getConfiguration().getString(SOLR_CONFIG_FILE_NAME_PROPERTY_NAME);
        File configFile = new File(solrHomeDir, configFileName);
        coreContainer = new CoreContainer(solrHomeDir, configFile);
        coreContainer.load(solrHomeDir, configFile);
        collectionName = SolrServerFactory.getCollectionName();
        solrServer = new EmbeddedSolrServer(coreContainer, collectionName);
    }

    public static CoreContainer getCoreContainer() throws UnsupportedType, ParserConfigurationException, IOException, SAXException {
        if (coreContainer == null) {
            SolrServerFactory.createSolrServer();
        }
        return coreContainer;
    }

    public static String getCollectionName() {
        if (collectionName == null) {
            collectionName = Settings.getConfiguration().getString(SOLR_COLLECTION_NAME_PROPERTY_NAME);
        }
        return collectionName;
    }
}

