/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AbstractAjaxResponse;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.XmlAjaxResponse;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.core.request.handler.logger.PageLogData;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.response.StringResponse;
import org.apache.wicket.response.filter.IResponseFilter;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public class AjaxRequestHandler
implements AjaxRequestTarget {
    private final AbstractAjaxResponse responseObject;
    private List<AjaxRequestTarget.IListener> listeners = null;
    private final Set<AjaxRequestTarget.ITargetRespondListener> respondListeners = new HashSet<AjaxRequestTarget.ITargetRespondListener>();
    protected transient boolean respondersFrozen;
    protected transient boolean listenersFrozen;
    private final Page page;
    private PageLogData logData;

    public AjaxRequestHandler(Page page) {
        this.page = (Page)Args.notNull((Object)page, (String)"page");
        this.responseObject = new XmlAjaxResponse(page){

            @Override
            protected void fireOnAfterRespondListeners(final Response response) {
                AjaxRequestHandler.this.listenersFrozen = true;
                if (AjaxRequestHandler.this.listeners != null) {
                    Map<String, Component> components = Collections.unmodifiableMap(this.markupIdToComponent);
                    AjaxRequestTarget.IJavaScriptResponse jsresponse = new AjaxRequestTarget.IJavaScriptResponse(){

                        @Override
                        public void addJavaScript(String script) {
                            this.writeNormalEvaluations(response, Collections.singleton(script));
                        }
                    };
                    for (AjaxRequestTarget.IListener listener : AjaxRequestHandler.this.listeners) {
                        listener.onAfterRespond(components, jsresponse);
                    }
                }
            }

            @Override
            protected void fireOnBeforeRespondListeners() {
                AjaxRequestHandler.this.listenersFrozen = true;
                if (AjaxRequestHandler.this.listeners != null) {
                    Map<String, Component> components = Collections.unmodifiableMap(this.markupIdToComponent);
                    for (AjaxRequestTarget.IListener listener : AjaxRequestHandler.this.listeners) {
                        listener.onBeforeRespond(components, AjaxRequestHandler.this);
                    }
                }
                AjaxRequestHandler.this.listenersFrozen = false;
            }
        };
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    @Override
    public void addListener(AjaxRequestTarget.IListener listener) throws IllegalStateException {
        Args.notNull((Object)listener, (String)"listener");
        this.assertListenersNotFrozen();
        if (this.listeners == null) {
            this.listeners = new LinkedList<AjaxRequestTarget.IListener>();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public final void addChildren(MarkupContainer parent, Class<?> childCriteria) {
        Args.notNull((Object)parent, (String)"parent");
        Args.notNull(childCriteria, (String)"childCriteria");
        parent.visitChildren(childCriteria, new IVisitor<Component, Void>(){

            public void component(Component component, IVisit<Void> visit) {
                AjaxRequestHandler.this.add(component);
                visit.dontGoDeeper();
            }
        });
    }

    @Override
    public void add(Component ... components) {
        for (Component component : components) {
            Args.notNull((Object)component, (String)"component");
            if (!component.getOutputMarkupId() && !(component instanceof Page)) {
                throw new IllegalArgumentException("cannot update component that does not have setOutputMarkupId property set to true. Component: " + component.toString());
            }
            this.add(component, component.getMarkupId());
        }
    }

    @Override
    public void add(Component component, String markupId) {
        this.responseObject.add(component, markupId);
    }

    @Override
    public final Collection<? extends Component> getComponents() {
        return this.responseObject.getComponents();
    }

    @Override
    public final void focusComponent(Component component) {
        if (component != null && !component.getOutputMarkupId()) {
            throw new IllegalArgumentException("cannot update component that does not have setOutputMarkupId property set to true. Component: " + component.toString());
        }
        String id = component != null ? "'" + component.getMarkupId() + "'" : "null";
        this.appendJavaScript("Wicket.Focus.setFocusOnId(" + id + ");");
    }

    @Override
    public final void appendJavaScript(CharSequence javascript) {
        this.responseObject.appendJavaScript(javascript);
    }

    public void detach(IRequestCycle requestCycle) {
        if (this.logData == null) {
            this.logData = new PageLogData(this.page);
        }
        this.responseObject.detach(requestCycle);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AjaxRequestHandler) {
            AjaxRequestHandler that = (AjaxRequestHandler)obj;
            return this.responseObject.equals(that.responseObject);
        }
        return false;
    }

    public int hashCode() {
        int result = "AjaxRequestHandler".hashCode();
        return result += this.responseObject.hashCode() * 17;
    }

    @Override
    public final void prependJavaScript(CharSequence javascript) {
        this.responseObject.prependJavaScript(javascript);
    }

    @Override
    public void registerRespondListener(AjaxRequestTarget.ITargetRespondListener listener) {
        this.assertRespondersNotFrozen();
        this.respondListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void respond(IRequestCycle requestCycle) {
        RequestCycle rc = (RequestCycle)requestCycle;
        WebResponse response = (WebResponse)requestCycle.getResponse();
        if (this.responseObject.containsPage()) {
            RenderPageRequestHandler handler = new RenderPageRequestHandler(new PageProvider(this.page));
            String url = ((Object)rc.urlFor(handler)).toString();
            response.sendRedirect(url);
            return;
        }
        this.respondersFrozen = true;
        for (AjaxRequestTarget.ITargetRespondListener listener : this.respondListeners) {
            listener.onTargetRespond(this);
        }
        Application app = this.page.getApplication();
        this.page.send(app, Broadcast.BREADTH, this);
        String encoding = app.getRequestCycleSettings().getResponseRequestEncoding();
        this.responseObject.setContentType(response, encoding);
        response.disableCaching();
        try {
            StringResponse bodyResponse = new StringResponse();
            this.responseObject.writeTo(bodyResponse, encoding);
            AppendingStringBuffer filteredResponse = this.invokeResponseFilters(bodyResponse);
            response.write((CharSequence)filteredResponse);
        }
        finally {
            rc.setResponse((Response)response);
        }
    }

    private AppendingStringBuffer invokeResponseFilters(StringResponse contentResponse) {
        AppendingStringBuffer responseBuffer = new AppendingStringBuffer(contentResponse.getBuffer());
        List<IResponseFilter> responseFilters = Application.get().getRequestCycleSettings().getResponseFilters();
        if (responseFilters != null) {
            for (IResponseFilter filter : responseFilters) {
                responseBuffer = filter.filter(responseBuffer);
            }
        }
        return responseBuffer;
    }

    public String toString() {
        return "[AjaxRequestHandler@" + this.hashCode() + " responseObject [" + this.responseObject + "]";
    }

    @Override
    public IHeaderResponse getHeaderResponse() {
        return this.responseObject.getHeaderResponse();
    }

    @Override
    public String getLastFocusedElementId() {
        WebRequest request = (WebRequest)this.page.getRequest();
        String id = request.getHeader("Wicket-FocusedElementId");
        return Strings.isEmpty((CharSequence)id) ? null : id;
    }

    @Override
    public Class<? extends IRequestablePage> getPageClass() {
        return this.page.getPageClass();
    }

    @Override
    public Integer getPageId() {
        return this.page.getPageId();
    }

    @Override
    public PageParameters getPageParameters() {
        return this.page.getPageParameters();
    }

    @Override
    public final boolean isPageInstanceCreated() {
        return true;
    }

    @Override
    public final Integer getRenderCount() {
        return this.page.getRenderCount();
    }

    public PageLogData getLogData() {
        return this.logData;
    }

    private void assertNotFrozen(boolean frozen, Class<?> clazz) {
        if (frozen) {
            throw new IllegalStateException(Classes.simpleName(clazz) + "s can no longer be added");
        }
    }

    private void assertRespondersNotFrozen() {
        this.assertNotFrozen(this.respondersFrozen, AjaxRequestTarget.ITargetRespondListener.class);
    }

    private void assertListenersNotFrozen() {
        this.assertNotFrozen(this.listenersFrozen, AjaxRequestTarget.IListener.class);
    }
}

