/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.security;

import java.security.SignatureException;
import java.security.interfaces.DSAParams;
import java.util.Arrays;
import org.xbill.DNS.SIGRecord;

public class DSASignature {
    static final int ASN1_SEQ = 48;
    static final int ASN1_INT = 2;

    static byte[] create(SIGRecord sigrec) {
        int len = 20;
        int n = 0;
        byte[] sigdata = sigrec.getSignature();
        int rlen = 20;
        if (sigdata[1] < 0) {
            rlen = (byte)(rlen + 1);
        }
        int slen = 20;
        if (sigdata[1] < 0) {
            slen = (byte)(slen + 1);
        }
        byte seqlen = (byte)(rlen + slen + 4);
        byte[] array = new byte[seqlen + 2];
        array[n++] = 48;
        array[n++] = seqlen;
        array[n++] = 2;
        array[n++] = rlen;
        if (rlen > 20) {
            array[n++] = 0;
        }
        int i = 0;
        while (i < 20) {
            array[n] = sigdata[1 + i];
            ++i;
            ++n;
        }
        array[n++] = 2;
        array[n++] = slen;
        if (slen > 20) {
            array[n++] = 0;
        }
        int i2 = 0;
        while (i2 < 20) {
            array[n] = sigdata[21 + i2];
            ++i2;
            ++n;
        }
        return array;
    }

    static byte[] create(DSAParams params, byte[] sig) throws SignatureException {
        if (sig[0] != 48 || sig[2] != 2) {
            throw new SignatureException("Expected SEQ, INT");
        }
        int rLength = sig[3];
        int rOffset = 4;
        if (sig[rOffset] == 0) {
            --rLength;
            ++rOffset;
        }
        if (sig[rOffset + rLength] != 2) {
            throw new SignatureException("Expected INT");
        }
        int sLength = sig[rOffset + rLength + 1];
        int sOffset = rOffset + rLength + 2;
        if (sig[sOffset] == 0) {
            --sLength;
            ++sOffset;
        }
        if (rLength > 20 || sLength > 20) {
            throw new SignatureException("DSA R/S too long");
        }
        byte[] newSig = new byte[41];
        Arrays.fill(newSig, (byte)0);
        newSig[0] = (byte)((params.getP().bitLength() - 512) / 64);
        System.arraycopy(sig, rOffset, newSig, 1 + (20 - rLength), rLength);
        System.arraycopy(sig, sOffset, newSig, 21 + (20 - sLength), sLength);
        return newSig;
    }
}

