/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeFilter;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.IndexableBinaryStringTools;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util._TestUtil;
import org.junit.Assert;

public abstract class CollationTestBase
extends LuceneTestCase {
    protected String firstRangeBeginningOriginal = "\u062f";
    protected String firstRangeEndOriginal = "\u0698";
    protected String secondRangeBeginningOriginal = "\u0633";
    protected String secondRangeEndOriginal = "\u0638";

    protected String encodeCollationKey(byte[] keyBits) {
        int encodedLength = IndexableBinaryStringTools.getEncodedLength((byte[])keyBits, (int)0, (int)keyBits.length);
        char[] encodedBegArray = new char[encodedLength];
        IndexableBinaryStringTools.encode((byte[])keyBits, (int)0, (int)keyBits.length, (char[])encodedBegArray, (int)0, (int)encodedLength);
        return new String(encodedBegArray);
    }

    public void testFarsiRangeFilterCollating(Analyzer analyzer, String firstBeg, String firstEnd, String secondBeg, String secondEnd) throws Exception {
        RAMDirectory ramDir = new RAMDirectory();
        IndexWriter writer = new IndexWriter((Directory)ramDir, new IndexWriterConfig(TEST_VERSION_CURRENT, analyzer));
        Document doc = new Document();
        doc.add((Fieldable)new Field("content", "\u0633\u0627\u0628", Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("body", "body", Field.Store.YES, Field.Index.NOT_ANALYZED));
        writer.addDocument(doc);
        writer.close();
        IndexSearcher searcher = new IndexSearcher((Directory)ramDir, true);
        TermQuery query = new TermQuery(new Term("body", "body"));
        ScoreDoc[] result = searcher.search((Query)query, (Filter)new TermRangeFilter((String)"content", (String)firstBeg, (String)firstEnd, (boolean)true, (boolean)true), (int)1).scoreDocs;
        CollationTestBase.assertEquals((String)"The index Term should not be included.", (long)0L, (long)result.length);
        result = searcher.search((Query)query, (Filter)new TermRangeFilter((String)"content", (String)secondBeg, (String)secondEnd, (boolean)true, (boolean)true), (int)1).scoreDocs;
        CollationTestBase.assertEquals((String)"The index Term should be included.", (long)1L, (long)result.length);
        searcher.close();
    }

    public void testFarsiRangeQueryCollating(Analyzer analyzer, String firstBeg, String firstEnd, String secondBeg, String secondEnd) throws Exception {
        RAMDirectory ramDir = new RAMDirectory();
        IndexWriter writer = new IndexWriter((Directory)ramDir, new IndexWriterConfig(TEST_VERSION_CURRENT, analyzer));
        Document doc = new Document();
        doc.add((Fieldable)new Field("content", "\u0633\u0627\u0628", Field.Store.YES, Field.Index.ANALYZED));
        writer.addDocument(doc);
        writer.close();
        IndexSearcher searcher = new IndexSearcher((Directory)ramDir, true);
        TermRangeQuery query = new TermRangeQuery("content", firstBeg, firstEnd, true, true);
        ScoreDoc[] hits = searcher.search((Query)query, null, (int)1000).scoreDocs;
        CollationTestBase.assertEquals((String)"The index Term should not be included.", (long)0L, (long)hits.length);
        query = new TermRangeQuery("content", secondBeg, secondEnd, true, true);
        hits = searcher.search((Query)query, null, (int)1000).scoreDocs;
        CollationTestBase.assertEquals((String)"The index Term should be included.", (long)1L, (long)hits.length);
        searcher.close();
    }

    public void testFarsiTermRangeQuery(Analyzer analyzer, String firstBeg, String firstEnd, String secondBeg, String secondEnd) throws Exception {
        RAMDirectory farsiIndex = new RAMDirectory();
        IndexWriter writer = new IndexWriter((Directory)farsiIndex, new IndexWriterConfig(TEST_VERSION_CURRENT, analyzer));
        Document doc = new Document();
        doc.add((Fieldable)new Field("content", "\u0633\u0627\u0628", Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("body", "body", Field.Store.YES, Field.Index.NOT_ANALYZED));
        writer.addDocument(doc);
        writer.close();
        IndexReader reader = IndexReader.open((Directory)farsiIndex, (boolean)true);
        IndexSearcher search = CollationTestBase.newSearcher(reader);
        TermRangeQuery csrq = new TermRangeQuery("content", firstBeg, firstEnd, true, true);
        ScoreDoc[] result = search.search((Query)csrq, null, (int)1000).scoreDocs;
        CollationTestBase.assertEquals((String)"The index Term should not be included.", (long)0L, (long)result.length);
        csrq = new TermRangeQuery("content", secondBeg, secondEnd, true, true);
        result = search.search((Query)csrq, null, (int)1000).scoreDocs;
        CollationTestBase.assertEquals((String)"The index Term should be included.", (long)1L, (long)result.length);
        search.close();
    }

    public void testCollationKeySort(Analyzer usAnalyzer, Analyzer franceAnalyzer, Analyzer swedenAnalyzer, Analyzer denmarkAnalyzer, String usResult, String frResult, String svResult, String dkResult) throws Exception {
        RAMDirectory indexStore = new RAMDirectory();
        PerFieldAnalyzerWrapper analyzer = new PerFieldAnalyzerWrapper((Analyzer)new WhitespaceAnalyzer(TEST_VERSION_CURRENT));
        analyzer.addAnalyzer("US", usAnalyzer);
        analyzer.addAnalyzer("France", franceAnalyzer);
        analyzer.addAnalyzer("Sweden", swedenAnalyzer);
        analyzer.addAnalyzer("Denmark", denmarkAnalyzer);
        IndexWriter writer = new IndexWriter((Directory)indexStore, new IndexWriterConfig(TEST_VERSION_CURRENT, (Analyzer)analyzer));
        String[][] sortData = new String[][]{{"A", "x", "p\u00eache", "p\u00eache", "p\u00eache", "p\u00eache"}, {"B", "y", "HAT", "HAT", "HAT", "HAT"}, {"C", "x", "p\u00e9ch\u00e9", "p\u00e9ch\u00e9", "p\u00e9ch\u00e9", "p\u00e9ch\u00e9"}, {"D", "y", "HUT", "HUT", "HUT", "HUT"}, {"E", "x", "peach", "peach", "peach", "peach"}, {"F", "y", "H\u00c5T", "H\u00c5T", "H\u00c5T", "H\u00c5T"}, {"G", "x", "sin", "sin", "sin", "sin"}, {"H", "y", "H\u00d8T", "H\u00d8T", "H\u00d8T", "H\u00d8T"}, {"I", "x", "s\u00edn", "s\u00edn", "s\u00edn", "s\u00edn"}, {"J", "y", "HOT", "HOT", "HOT", "HOT"}};
        for (int i = 0; i < sortData.length; ++i) {
            Document doc = new Document();
            doc.add((Fieldable)new Field("tracer", sortData[i][0], Field.Store.YES, Field.Index.NO));
            doc.add((Fieldable)new Field("contents", sortData[i][1], Field.Store.NO, Field.Index.ANALYZED));
            if (sortData[i][2] != null) {
                doc.add((Fieldable)new Field("US", sortData[i][2], Field.Store.NO, Field.Index.ANALYZED));
            }
            if (sortData[i][3] != null) {
                doc.add((Fieldable)new Field("France", sortData[i][3], Field.Store.NO, Field.Index.ANALYZED));
            }
            if (sortData[i][4] != null) {
                doc.add((Fieldable)new Field("Sweden", sortData[i][4], Field.Store.NO, Field.Index.ANALYZED));
            }
            if (sortData[i][5] != null) {
                doc.add((Fieldable)new Field("Denmark", sortData[i][5], Field.Store.NO, Field.Index.ANALYZED));
            }
            writer.addDocument(doc);
        }
        writer.optimize();
        writer.close();
        IndexSearcher searcher = new IndexSearcher((Directory)indexStore, true);
        Sort sort = new Sort();
        TermQuery queryX = new TermQuery(new Term("contents", "x"));
        TermQuery queryY = new TermQuery(new Term("contents", "y"));
        sort.setSort(new SortField("US", 3));
        this.assertMatches((Searcher)searcher, (Query)queryY, sort, usResult);
        sort.setSort(new SortField("France", 3));
        this.assertMatches((Searcher)searcher, (Query)queryX, sort, frResult);
        sort.setSort(new SortField("Sweden", 3));
        this.assertMatches((Searcher)searcher, (Query)queryY, sort, svResult);
        sort.setSort(new SortField("Denmark", 3));
        this.assertMatches((Searcher)searcher, (Query)queryY, sort, dkResult);
    }

    private void assertMatches(Searcher searcher, Query query, Sort sort, String expectedResult) throws IOException {
        ScoreDoc[] result = searcher.search((Query)query, null, (int)1000, (Sort)sort).scoreDocs;
        StringBuilder buff = new StringBuilder(10);
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            Document doc = searcher.doc(result[i].doc);
            String[] v = doc.getValues("tracer");
            for (int j = 0; j < v.length; ++j) {
                buff.append(v[j]);
            }
        }
        CollationTestBase.assertEquals((Object)expectedResult, (Object)buff.toString());
    }

    public void assertThreadSafe(final Analyzer analyzer) throws Exception {
        int i;
        int numTestPoints = 100;
        int numThreads = _TestUtil.nextInt(random, 3, 5);
        final HashMap<String, String> map = new HashMap<String, String>();
        for (int i2 = 0; i2 < numTestPoints; ++i2) {
            String term = _TestUtil.randomSimpleString(random);
            TokenStream ts = analyzer.reusableTokenStream("fake", (Reader)new StringReader(term));
            CharTermAttribute encodedBytes = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            ts.reset();
            CollationTestBase.assertTrue((boolean)ts.incrementToken());
            map.put(term, encodedBytes.toString());
        }
        Thread[] threads = new Thread[numThreads];
        for (i = 0; i < numThreads; ++i) {
            threads[i] = new Thread(){

                public void run() {
                    try {
                        for (Map.Entry mapping : map.entrySet()) {
                            String term = (String)mapping.getKey();
                            String expected = (String)mapping.getValue();
                            TokenStream ts = analyzer.reusableTokenStream("fake", (Reader)new StringReader(term));
                            CharTermAttribute encodedBytes = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
                            ts.reset();
                            Assert.assertTrue((boolean)ts.incrementToken());
                            Assert.assertEquals((Object)expected, (Object)encodedBytes.toString());
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        for (i = 0; i < numThreads; ++i) {
            threads[i].start();
        }
        for (i = 0; i < numThreads; ++i) {
            threads[i].join();
        }
    }
}

