/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.ThreeLongs;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneTestCaseRunner
extends BlockJUnit4ClassRunner {
    private List<FrameworkMethod> testMethods;
    static final long runnerSeed = "random".equals(LuceneTestCase.TEST_SEED) ? LuceneTestCase.seedRand.nextLong() : ThreeLongs.fromString((String)LuceneTestCase.TEST_SEED).l3;

    protected List<FrameworkMethod> computeTestMethods() {
        if (this.testMethods != null) {
            return this.testMethods;
        }
        Random r = new Random(runnerSeed);
        LuceneTestCase.testClassesRun.add(this.getTestClass().getJavaClass().getSimpleName());
        this.testMethods = new ArrayList<FrameworkMethod>();
        for (Method m : this.getTestClass().getJavaClass().getMethods()) {
            Ignore ignored = m.getAnnotation(Ignore.class);
            if (ignored != null && !m.getName().equals("alwaysIgnoredTestMethod")) {
                System.err.println("NOTE: Ignoring test method '" + m.getName() + "': " + ignored.value());
            }
            int mod = m.getModifiers();
            if (m.getAnnotation(Test.class) == null && (!m.getName().startsWith("test") || Modifier.isAbstract(mod) || m.getParameterTypes().length != 0 || m.getReturnType() != Void.TYPE)) continue;
            if (Modifier.isStatic(mod)) {
                throw new RuntimeException("Test methods must not be static.");
            }
            this.testMethods.add(new FrameworkMethod(m));
        }
        if (this.testMethods.isEmpty()) {
            throw new RuntimeException("No runnable methods!");
        }
        if (!LuceneTestCase.TEST_NIGHTLY) {
            if (this.getTestClass().getJavaClass().isAnnotationPresent(LuceneTestCase.Nightly.class)) {
                String className = this.getTestClass().getJavaClass().getSimpleName();
                System.err.println("NOTE: Ignoring nightly-only test class '" + className + "'");
                this.testMethods.clear();
            } else {
                for (int i = 0; i < this.testMethods.size(); ++i) {
                    FrameworkMethod m = this.testMethods.get(i);
                    if (m.getAnnotation(LuceneTestCase.Nightly.class) == null) continue;
                    System.err.println("NOTE: Ignoring nightly-only test method '" + m.getName() + "'");
                    this.testMethods.remove(i--);
                }
            }
            if (this.testMethods.isEmpty()) {
                try {
                    this.testMethods.add(new FrameworkMethod(LuceneTestCase.class.getMethod("alwaysIgnoredTestMethod", new Class[0])));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        Collections.sort(this.testMethods, new Comparator<FrameworkMethod>(){

            @Override
            public int compare(FrameworkMethod f1, FrameworkMethod f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        Collections.shuffle(this.testMethods, r);
        return this.testMethods;
    }

    protected void runChild(FrameworkMethod arg0, RunNotifier arg1) {
        if (LuceneTestCase.VERBOSE) {
            System.out.println("\nNOTE: running test " + arg0.getName());
        }
        final boolean verbose = LuceneTestCase.VERBOSE && LuceneTestCase.TEST_ITER > 1;
        final int[] currentIter = new int[1];
        arg1.addListener(new RunListener(){

            public void testFailure(Failure failure) throws Exception {
                if (verbose) {
                    System.out.println("\nNOTE: iteration " + currentIter[0] + " failed! ");
                }
            }
        });
        for (int i = 0; i < LuceneTestCase.TEST_ITER; ++i) {
            currentIter[0] = i;
            if (verbose) {
                System.out.println("\nNOTE: running iter=" + (1 + i) + " of " + LuceneTestCase.TEST_ITER);
            }
            super.runChild(arg0, arg1);
            if (LuceneTestCase.testsFailed && i >= LuceneTestCase.TEST_ITER_MIN - 1) break;
        }
    }

    public LuceneTestCaseRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        Filter f = new Filter(){

            public String describe() {
                return "filters according to TEST_METHOD";
            }

            public boolean shouldRun(Description d) {
                return LuceneTestCase.TEST_METHOD == null || d.getMethodName().equals(LuceneTestCase.TEST_METHOD);
            }
        };
        try {
            f.apply((Object)this);
        }
        catch (NoTestsRemainException e) {
            throw new RuntimeException(e);
        }
    }
}

