/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.factories;

import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.index.IndexFactory;
import com.hp.hpl.jena.tdb.index.IndexRangeFactory;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexFactoryBPlusTree
implements IndexFactory,
IndexRangeFactory {
    private static Logger log = LoggerFactory.getLogger(IndexFactoryBPlusTree.class);
    private final int blockSize;

    public IndexFactoryBPlusTree() {
        this(8192);
    }

    public IndexFactoryBPlusTree(int blockSize) {
        this.blockSize = blockSize;
    }

    @Override
    public Index createIndex(FileSet fileset, RecordFactory factory) {
        return this.createRangeIndex(fileset, factory);
    }

    @Override
    public RangeIndex createRangeIndex(FileSet fileset, RecordFactory factory) {
        int order = BPlusTreeParams.calcOrder(this.blockSize, factory);
        BPlusTreeParams params = new BPlusTreeParams(order, factory);
        if (params.getCalcBlockSize() > this.blockSize) {
            throw new TDBException("Calculated block size is greater than required size");
        }
        BlockMgr blkMgrNodes = IndexFactoryBPlusTree.createBlockMgr(fileset, "idn", this.blockSize);
        BlockMgr blkMgrRecords = IndexFactoryBPlusTree.createBlockMgr(fileset, "dat", this.blockSize);
        return BPlusTree.create(params, blkMgrNodes, blkMgrRecords);
    }

    static BlockMgr createBlockMgr(FileSet fileset, String filename, int blockSize) {
        if (fileset.isMem()) {
            return BlockMgrFactory.createMem(filename, blockSize);
        }
        String fnNodes = fileset.filename(filename);
        return BlockMgrFactory.createFile(fnNodes, blockSize, SystemTDB.BlockReadCacheSize, SystemTDB.BlockWriteCacheSize);
    }
}

