/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xml.dtm.ref.DTMSafeStringPool;
import org.apache.xml.dtm.ref.DTMStringPool;

public class ExpandedNameTable {
    private DTMStringPool m_locNamesPool;
    private DTMStringPool m_namespaceNames;
    private Vector m_extendedTypes;
    private int m_nextType;
    public static final int ELEMENT = 1;
    public static final int ATTRIBUTE = 2;
    public static final int TEXT = 3;
    public static final int CDATA_SECTION = 4;
    public static final int ENTITY_REFERENCE = 5;
    public static final int ENTITY = 6;
    public static final int PROCESSING_INSTRUCTION = 7;
    public static final int COMMENT = 8;
    public static final int DOCUMENT = 9;
    public static final int DOCUMENT_TYPE = 10;
    public static final int DOCUMENT_FRAGMENT = 11;
    public static final int NOTATION = 12;
    public static final int NAMESPACE = 13;
    Hashtable m_hashtable = new Hashtable();
    ExtendedType hashET = new ExtendedType(-1, "", "");

    public ExpandedNameTable() {
        this.m_locNamesPool = new DTMSafeStringPool();
        this.m_namespaceNames = new DTMSafeStringPool();
        this.initExtendedTypes();
    }

    public ExpandedNameTable(DTMStringPool locNamesPool, DTMStringPool namespaceNames) {
        this.m_locNamesPool = locNamesPool;
        this.m_namespaceNames = namespaceNames;
        this.initExtendedTypes();
    }

    private void initExtendedTypes() {
        this.m_extendedTypes = new Vector();
        int i = 0;
        while (i < 14) {
            ExtendedType newET = new ExtendedType(i, "", "");
            this.m_extendedTypes.addElement(newET);
            this.m_hashtable.put(newET, new Integer(i));
            ++i;
        }
        this.m_nextType = this.m_extendedTypes.size();
    }

    public int getExpandedTypeID(String namespace, String localName, int type) {
        if (null == namespace) {
            namespace = "";
        }
        if (null == localName) {
            localName = "";
        }
        this.hashET.redefine(type, namespace, localName);
        Object eType = this.m_hashtable.get(this.hashET);
        if (eType != null) {
            return (Integer)eType;
        }
        ExtendedType newET = new ExtendedType(type, namespace, localName);
        this.m_extendedTypes.addElement(newET);
        this.m_hashtable.put(newET, new Integer(this.m_nextType));
        return this.m_nextType++;
    }

    public int getExpandedTypeID(int type) {
        return type;
    }

    public String getLocalName(int ExpandedNameID) {
        ExtendedType etype = (ExtendedType)this.m_extendedTypes.elementAt(ExpandedNameID);
        return etype.localName;
    }

    public final int getLocalNameID(int ExpandedNameID) {
        ExtendedType etype = (ExtendedType)this.m_extendedTypes.elementAt(ExpandedNameID);
        if (etype.localName.equals("")) {
            return 0;
        }
        return ExpandedNameID;
    }

    public String getNamespace(int ExpandedNameID) {
        ExtendedType etype = (ExtendedType)this.m_extendedTypes.elementAt(ExpandedNameID);
        return etype.namespace.equals("") ? null : etype.namespace;
    }

    public final int getNamespaceID(int ExpandedNameID) {
        ExtendedType etype = (ExtendedType)this.m_extendedTypes.elementAt(ExpandedNameID);
        if (etype.namespace.equals("")) {
            return 0;
        }
        return ExpandedNameID;
    }

    public final short getType(int ExpandedNameID) {
        ExtendedType etype = (ExtendedType)this.m_extendedTypes.elementAt(ExpandedNameID);
        return (short)etype.nodetype;
    }

    private class ExtendedType {
        protected int nodetype;
        protected String namespace;
        protected String localName;
        protected int hash;

        protected ExtendedType(int nodetype, String namespace, String localName) {
            this.nodetype = nodetype;
            this.namespace = namespace;
            this.localName = localName;
            this.hash = nodetype + namespace.hashCode() + localName.hashCode();
        }

        protected void redefine(int nodetype, String namespace, String localName) {
            this.nodetype = nodetype;
            this.namespace = namespace;
            this.localName = localName;
            this.hash = nodetype + namespace.hashCode() + localName.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object other) {
            try {
                ExtendedType et = (ExtendedType)other;
                return et.nodetype == this.nodetype && et.localName.equals(this.localName) && et.namespace.equals(this.namespace);
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }
    }
}

