/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.jibx.schema.codegen.extend;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.jibx.schema.codegen.extend.ClassDecorator;
import org.jibx.schema.codegen.extend.NameMatchDecoratorBase;

public abstract class FieldMatchDecoratorBase
extends NameMatchDecoratorBase
implements ClassDecorator {
    protected List<String> m_fields = new ArrayList<String>();

    public FieldMatchDecoratorBase() {
        this.m_fields.add("value");
    }

    public void setFields(String fields) {
        System.out.println(fields);
        this.m_fields.addAll(Arrays.asList(fields.split("\\s+")));
    }

    protected Type getFieldType(AST ast, String fieldName) {
        StringTokenizer st = new StringTokenizer(fieldName, ".");
        ArrayList<String> fieldList = new ArrayList<String>();
        ArrayList simpleNameList = new ArrayList();
        while (st.hasMoreTokens()) {
            String name = st.nextToken().trim();
            fieldList.add(name);
        }
        if (fieldList.isEmpty()) {
            return ast.newSimpleType((Name)ast.newSimpleName(fieldName));
        }
        if (fieldList.size() == 1) {
            return ast.newSimpleType((Name)ast.newSimpleName((String)fieldList.get(0)));
        }
        if (fieldList.size() > 1) {
            QualifiedType qualifiedFieldType = null;
            SimpleType simpleFieldType = null;
            for (String field : fieldList) {
                if (qualifiedFieldType == null && simpleFieldType == null) {
                    simpleFieldType = ast.newSimpleType((Name)ast.newSimpleName(field));
                    continue;
                }
                if (qualifiedFieldType == null) {
                    qualifiedFieldType = ast.newQualifiedType((Type)simpleFieldType, ast.newSimpleName(field));
                    continue;
                }
                qualifiedFieldType = ast.newQualifiedType(qualifiedFieldType, ast.newSimpleName(field));
            }
            return qualifiedFieldType;
        }
        throw new IllegalArgumentException("building a Type from field attribute '" + fieldName + "' did not work");
    }
}

