/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.IndexedPanel;
import com.google.gwt.user.client.ui.Widget;

public class DeckPanel
extends ComplexPanel
implements IndexedPanel {
    private Widget visibleWidget;

    public DeckPanel() {
        this.setElement(DOM.createDiv());
    }

    public void add(Widget w) {
        this.insert(w, this.getWidgetCount());
    }

    public int getVisibleWidget() {
        return this.getWidgetIndex(this.visibleWidget);
    }

    public Widget getWidget(int index) {
        return this.getChildren().get(index);
    }

    public int getWidgetCount() {
        return this.getChildren().size();
    }

    public int getWidgetIndex(Widget child) {
        return this.getChildren().indexOf(child);
    }

    public void insert(Widget w, int beforeIndex) {
        if (beforeIndex < 0 || beforeIndex > this.getWidgetCount()) {
            throw new IndexOutOfBoundsException();
        }
        super.insert(w, this.getElement(), beforeIndex);
        Element child = w.getElement();
        DOM.setStyleAttribute(child, "width", "100%");
        DOM.setStyleAttribute(child, "height", "100%");
        w.setVisible(false);
    }

    public boolean remove(int index) {
        return this.remove(this.getWidget(index));
    }

    public boolean remove(Widget w) {
        if (!super.remove(w)) {
            return false;
        }
        if (this.visibleWidget == w) {
            this.visibleWidget = null;
        }
        return true;
    }

    public void showWidget(int index) {
        this.checkIndex(index);
        if (this.visibleWidget != null) {
            this.visibleWidget.setVisible(false);
        }
        this.visibleWidget = this.getWidget(index);
        this.visibleWidget.setVisible(true);
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.getWidgetCount()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

