/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.FastStringMap;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SourcesTableEvents;
import com.google.gwt.user.client.ui.TableListener;
import com.google.gwt.user.client.ui.TableListenerCollection;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;

public abstract class HTMLTable
extends Panel
implements SourcesTableEvents {
    private static final String HASH_ATTR = "__hash";
    private final Element bodyElem;
    private CellFormatter cellFormatter;
    private ColumnFormatter columnFormatter;
    private RowFormatter rowFormatter;
    private final Element tableElem;
    private TableListenerCollection tableListeners;
    private final FastStringMap widgetMap = new FastStringMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public HTMLTable() {
        this.tableElem = DOM.createTable();
        this.bodyElem = DOM.createTBody();
        DOM.appendChild(this.tableElem, this.bodyElem);
        this.setElement(this.tableElem);
        this.sinkEvents(1);
    }

    public void addTableListener(TableListener listener) {
        if (this.tableListeners == null) {
            this.tableListeners = new TableListenerCollection();
        }
        this.tableListeners.add(listener);
    }

    public void clear() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int col = 0; col < this.getCellCount(row); ++col) {
                Widget child = this.getWidget(row, col);
                if (child == null) continue;
                this.removeWidget(child);
            }
        }
        if (!$assertionsDisabled && this.widgetMap.size() != 0) {
            throw new AssertionError();
        }
    }

    public boolean clearCell(int row, int column) {
        Element td = this.getCellFormatter().getElement(row, column);
        return this.internalClearCell(td, true);
    }

    public abstract int getCellCount(int var1);

    public CellFormatter getCellFormatter() {
        return this.cellFormatter;
    }

    public int getCellPadding() {
        return DOM.getIntAttribute(this.tableElem, "cellPadding");
    }

    public int getCellSpacing() {
        return DOM.getIntAttribute(this.tableElem, "cellSpacing");
    }

    public ColumnFormatter getColumnFormatter() {
        return this.columnFormatter;
    }

    public String getHTML(int row, int column) {
        return DOM.getInnerHTML(this.cellFormatter.getElement(row, column));
    }

    public abstract int getRowCount();

    public RowFormatter getRowFormatter() {
        return this.rowFormatter;
    }

    public String getText(int row, int column) {
        this.checkCellBounds(row, column);
        Element e = this.cellFormatter.getElement(row, column);
        return DOM.getInnerText(e);
    }

    public Widget getWidget(int row, int column) {
        this.checkCellBounds(row, column);
        Object key = this.computeKey(row, column);
        if (key == null) {
            return null;
        }
        return (Widget)this.widgetMap.get(key);
    }

    public boolean isCellPresent(int row, int column) {
        if (row >= this.getRowCount() && row < 0) {
            return false;
        }
        return column >= 0 && column < this.getCellCount(row);
    }

    public Iterator iterator() {
        return this.widgetMap.values().iterator();
    }

    public void onBrowserEvent(Event event) {
        switch (DOM.eventGetType(event)) {
            case 1: {
                if (this.tableListeners == null) break;
                Element td = this.getEventTargetCell(event);
                if (td == null) {
                    return;
                }
                Element tr = DOM.getParent(td);
                Element body = DOM.getParent(tr);
                int row = DOM.getChildIndex(body, tr);
                int column = DOM.getChildIndex(tr, td);
                this.tableListeners.fireCellClicked(this, row, column);
                break;
            }
        }
    }

    public boolean remove(Widget widget) {
        if (widget.getParent() != this) {
            return false;
        }
        this.removeWidget(widget);
        return true;
    }

    public void removeTableListener(TableListener listener) {
        if (this.tableListeners != null) {
            this.tableListeners.remove(listener);
        }
    }

    public void setBorderWidth(int width) {
        DOM.setAttribute(this.tableElem, "border", "" + width);
    }

    public void setCellPadding(int padding) {
        DOM.setIntAttribute(this.tableElem, "cellPadding", padding);
    }

    public void setCellSpacing(int spacing) {
        DOM.setIntAttribute(this.tableElem, "cellSpacing", spacing);
    }

    public void setHTML(int row, int column, String html) {
        this.prepareCell(row, column);
        Element td = this.cleanCell(row, column, html == null);
        if (html != null) {
            DOM.setInnerHTML(td, html);
        }
    }

    public void setText(int row, int column, String text) {
        this.prepareCell(row, column);
        Element td = this.cleanCell(row, column, text == null);
        if (text != null) {
            DOM.setInnerText(td, text);
        }
    }

    public void setWidget(int row, int column, Widget widget) {
        this.prepareCell(row, column);
        if (widget != null) {
            widget.removeFromParent();
            Element td = this.cleanCell(row, column, true);
            String hash = Integer.toString(widget.hashCode());
            Element e = widget.getElement();
            DOM.setAttribute(e, HASH_ATTR, hash);
            this.widgetMap.put(hash, (Object)widget);
            this.adopt(widget, td);
        }
    }

    protected void checkCellBounds(int row, int column) {
        this.checkRowBounds(row);
        if (column < 0) {
            throw new IndexOutOfBoundsException("Column " + column + " must be non-negative: " + column);
        }
        int cellSize = this.getCellCount(row);
        if (cellSize <= column) {
            throw new IndexOutOfBoundsException("Column index: " + column + ", Column size: " + this.getCellCount(row));
        }
    }

    protected void checkRowBounds(int row) {
        int rowSize = this.getRowCount();
        if (row >= rowSize || row < 0) {
            throw new IndexOutOfBoundsException("Row index: " + row + ", Row size: " + rowSize);
        }
    }

    protected Element createCell() {
        return DOM.createTD();
    }

    protected Element getBodyElement() {
        return this.bodyElem;
    }

    protected native int getDOMCellCount(Element var1, int var2);

    protected int getDOMCellCount(int row) {
        return this.getDOMCellCount(this.bodyElem, row);
    }

    protected int getDOMRowCount() {
        return this.getDOMRowCount(this.bodyElem);
    }

    protected native int getDOMRowCount(Element var1);

    protected Element getEventTargetCell(Event event) {
        Element td = DOM.eventGetTarget(event);
        while (td != null) {
            Element tr;
            Element body;
            if (DOM.getAttribute(td, "tagName").equalsIgnoreCase("td") && DOM.compare(body = DOM.getParent(tr = DOM.getParent(td)), this.bodyElem)) {
                return td;
            }
            if (DOM.compare(td, this.bodyElem)) {
                return null;
            }
            td = DOM.getParent(td);
        }
        return null;
    }

    protected void insertCell(int row, int column) {
        Element tr = this.rowFormatter.getRow(this.bodyElem, row);
        Element td = this.createCell();
        DOM.insertChild(tr, td, column);
    }

    protected void insertCells(int row, int column, int count) {
        Element tr = this.rowFormatter.getRow(this.bodyElem, row);
        for (int i = column; i < column + count; ++i) {
            Element td = this.createCell();
            DOM.insertChild(tr, td, i);
        }
    }

    protected int insertRow(int beforeRow) {
        if (beforeRow != this.getRowCount()) {
            this.checkRowBounds(beforeRow);
        }
        Element tr = DOM.createTR();
        DOM.insertChild(this.bodyElem, tr, beforeRow);
        return beforeRow;
    }

    protected boolean internalClearCell(Element td, boolean clearInnerHTML) {
        Element maybeChild = DOM.getFirstChild(td);
        Widget widget = null;
        if (maybeChild != null) {
            widget = this.getWidget(maybeChild);
        }
        if (widget != null) {
            this.removeWidget(widget);
            return true;
        }
        if (clearInnerHTML) {
            DOM.setInnerHTML(td, "");
        }
        return false;
    }

    protected abstract void prepareCell(int var1, int var2);

    protected void prepareColumn(int column) {
    }

    protected abstract void prepareRow(int var1);

    protected void removeCell(int row, int column) {
        this.checkCellBounds(row, column);
        Element td = this.cleanCell(row, column, false);
        Element tr = this.rowFormatter.getRow(this.bodyElem, row);
        DOM.removeChild(tr, td);
    }

    protected void removeRow(int row) {
        int columnCount = this.getCellCount(row);
        for (int column = 0; column < columnCount; ++column) {
            this.cleanCell(row, column, false);
        }
        DOM.removeChild(this.bodyElem, this.rowFormatter.getRow(this.bodyElem, row));
    }

    protected void setCellFormatter(CellFormatter cellFormatter) {
        this.cellFormatter = cellFormatter;
    }

    protected void setColumnFormatter(ColumnFormatter formatter) {
        this.columnFormatter = formatter;
    }

    protected void setRowFormatter(RowFormatter rowFormatter) {
        this.rowFormatter = rowFormatter;
    }

    FastStringMap getWidgetMap() {
        return this.widgetMap;
    }

    private Element cleanCell(int row, int column, boolean clearInnerHTML) {
        Element td = this.getCellFormatter().getRawElement(row, column);
        this.internalClearCell(td, clearInnerHTML);
        return td;
    }

    private Object computeKey(int row, int column) {
        Element e = this.cellFormatter.getRawElement(row, column);
        Element child = DOM.getFirstChild(e);
        if (child == null) {
            return null;
        }
        return this.computeKeyForElement(child);
    }

    private String computeKeyForElement(Element widgetElement) {
        return DOM.getAttribute(widgetElement, HASH_ATTR);
    }

    private Widget getWidget(Element widgetElement) {
        String key = this.computeKeyForElement(widgetElement);
        if (key != null) {
            Widget widget = (Widget)this.widgetMap.get((Object)key);
            if (!$assertionsDisabled && widget == null) {
                throw new AssertionError();
            }
            return widget;
        }
        return null;
    }

    private boolean removeWidget(Widget widget) {
        this.disown(widget);
        Object x = this.widgetMap.remove((Object)this.computeKeyForElement(widget.getElement()));
        if (!$assertionsDisabled && x == null) {
            throw new AssertionError();
        }
        return true;
    }

    static {
        $assertionsDisabled = !HTMLTable.class.desiredAssertionStatus();
    }

    public class RowFormatter {
        public void addStyleName(int row, String styleName) {
            UIObject.setStyleName(this.ensureElement(row), styleName, true);
        }

        public Element getElement(int row) {
            HTMLTable.this.checkRowBounds(row);
            return this.getRow(HTMLTable.this.bodyElem, row);
        }

        public String getStyleName(int row) {
            return DOM.getAttribute(this.getElement(row), "className");
        }

        public boolean isVisible(int row) {
            Element e = this.getElement(row);
            return UIObject.isVisible(e);
        }

        public void removeStyleName(int row, String styleName) {
            UIObject.setStyleName(this.getElement(row), styleName, false);
        }

        public void setStyleName(int row, String styleName) {
            Element elem = this.ensureElement(row);
            DOM.setAttribute(elem, "className", styleName);
        }

        public void setVerticalAlign(int row, HasVerticalAlignment.VerticalAlignmentConstant align) {
            DOM.setStyleAttribute(this.ensureElement(row), "verticalAlign", align.getVerticalAlignString());
        }

        public void setVisible(int row, boolean visible) {
            Element e = this.ensureElement(row);
            UIObject.setVisible(e, visible);
        }

        protected Element ensureElement(int row) {
            HTMLTable.this.prepareRow(row);
            return this.getRow(HTMLTable.this.bodyElem, row);
        }

        protected native Element getRow(Element var1, int var2);

        protected void setAttr(int row, String attrName, String value) {
            Element elem = this.ensureElement(row);
            DOM.setAttribute(elem, attrName, value);
        }
    }

    public class ColumnFormatter {
        protected Element columnGroup;

        public void addStyleName(int col, String styleName) {
            UIObject.setStyleName(this.ensureColumn(col), styleName, true);
        }

        public String getStyleName(int column) {
            return DOM.getAttribute(this.ensureColumn(column), "className");
        }

        public void removeStyleName(int column, String styleName) {
            UIObject.setStyleName(this.ensureColumn(column), styleName, false);
        }

        public void setStyleName(int column, String styleName) {
            Element elem = this.ensureColumn(column);
            DOM.setAttribute(elem, "className", styleName);
        }

        public void setWidth(int column, String width) {
            DOM.setAttribute(this.ensureColumn(column), "width", width);
        }

        private Element ensureColumn(int col) {
            int num;
            HTMLTable.this.prepareColumn(col);
            if (this.columnGroup == null) {
                this.columnGroup = DOM.createElement("colgroup");
                DOM.insertChild(HTMLTable.this.getElement(), this.columnGroup, 0);
            }
            if ((num = DOM.getChildCount(this.columnGroup)) <= col) {
                Element colElement = null;
                for (int i = num; i <= col; ++i) {
                    colElement = DOM.createElement("col");
                    DOM.appendChild(this.columnGroup, colElement);
                }
                return colElement;
            }
            return DOM.getChild(this.columnGroup, col);
        }
    }

    public class CellFormatter {
        public void addStyleName(int row, int column, String styleName) {
            HTMLTable.this.prepareCell(row, column);
            Element td = this.getCellElement(HTMLTable.this.bodyElem, row, column);
            UIObject.setStyleName(td, styleName, true);
        }

        public Element getElement(int row, int column) {
            HTMLTable.this.checkCellBounds(row, column);
            return this.getCellElement(HTMLTable.this.bodyElem, row, column);
        }

        public String getStyleName(int row, int column) {
            return DOM.getAttribute(this.getElement(row, column), "className");
        }

        public boolean isVisible(int row, int column) {
            Element e = this.getElement(row, column);
            return UIObject.isVisible(e);
        }

        public void removeStyleName(int row, int column, String styleName) {
            HTMLTable.this.checkCellBounds(row, column);
            Element td = this.getCellElement(HTMLTable.this.bodyElem, row, column);
            UIObject.setStyleName(td, styleName, false);
        }

        public void setAlignment(int row, int column, HasHorizontalAlignment.HorizontalAlignmentConstant hAlign, HasVerticalAlignment.VerticalAlignmentConstant vAlign) {
            this.setHorizontalAlignment(row, column, hAlign);
            this.setVerticalAlignment(row, column, vAlign);
        }

        public void setHeight(int row, int column, String height) {
            HTMLTable.this.prepareCell(row, column);
            Element elem = this.getCellElement(HTMLTable.this.bodyElem, row, column);
            DOM.setAttribute(elem, "height", height);
        }

        public void setHorizontalAlignment(int row, int column, HasHorizontalAlignment.HorizontalAlignmentConstant align) {
            HTMLTable.this.prepareCell(row, column);
            Element elem = this.getCellElement(HTMLTable.this.bodyElem, row, column);
            DOM.setAttribute(elem, "align", align.getTextAlignString());
        }

        public void setStyleName(int row, int column, String styleName) {
            HTMLTable.this.prepareCell(row, column);
            this.setAttr(row, column, "className", styleName);
        }

        public void setVerticalAlignment(int row, int column, HasVerticalAlignment.VerticalAlignmentConstant align) {
            HTMLTable.this.prepareCell(row, column);
            DOM.setStyleAttribute(this.getCellElement(HTMLTable.this.bodyElem, row, column), "verticalAlign", align.getVerticalAlignString());
        }

        public void setVisible(int row, int column, boolean visible) {
            Element e = this.ensureElement(row, column);
            UIObject.setVisible(e, visible);
        }

        public void setWidth(int row, int column, String width) {
            HTMLTable.this.prepareCell(row, column);
            DOM.setAttribute(this.getCellElement(HTMLTable.this.bodyElem, row, column), "width", width);
        }

        public void setWordWrap(int row, int column, boolean wrap) {
            HTMLTable.this.prepareCell(row, column);
            String wrapValue = wrap ? "" : "nowrap";
            DOM.setStyleAttribute(this.getElement(row, column), "whiteSpace", wrapValue);
        }

        protected Element ensureElement(int row, int column) {
            HTMLTable.this.prepareCell(row, column);
            return this.getCellElement(HTMLTable.this.bodyElem, row, column);
        }

        protected String getAttr(int row, int column, String attr) {
            Element elem = this.getElement(row, column);
            return DOM.getAttribute(elem, attr);
        }

        protected void setAttr(int row, int column, String attrName, String value) {
            Element elem = this.ensureElement(row, column);
            DOM.setAttribute(elem, attrName, value);
        }

        private native Element getCellElement(Element var1, int var2, int var3);

        private Element getRawElement(int row, int column) {
            return this.getCellElement(HTMLTable.this.bodyElem, row, column);
        }
    }
}

