/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ChangeListenerCollection;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.SourcesChangeEvents;

public class ListBox
extends FocusWidget
implements SourcesChangeEvents,
HasName {
    private static final int INSERT_AT_END = -1;
    private ChangeListenerCollection changeListeners;

    public ListBox() {
        super(DOM.createSelect());
        this.sinkEvents(1024);
        this.setStyleName("gwt-ListBox");
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ChangeListenerCollection();
        }
        this.changeListeners.add(listener);
    }

    public void addItem(String item) {
        this.insertItem(item, -1);
    }

    public void addItem(String item, String value) {
        this.insertItem(item, value, -1);
    }

    public void clear() {
        Element h = this.getElement();
        while (DOM.getChildCount(h) > 0) {
            DOM.removeChild(h, DOM.getChild(h, 0));
        }
    }

    public int getItemCount() {
        return DOM.getChildCount(this.getElement());
    }

    public String getItemText(int index) {
        Element child = DOM.getChild(this.getElement(), index);
        return DOM.getInnerText(child);
    }

    public String getName() {
        return DOM.getAttribute(this.getElement(), "name");
    }

    public int getSelectedIndex() {
        return DOM.getIntAttribute(this.getElement(), "selectedIndex");
    }

    public String getValue(int index) {
        this.checkIndex(index);
        Element option = DOM.getChild(this.getElement(), index);
        return DOM.getAttribute(option, "value");
    }

    public int getVisibleItemCount() {
        return DOM.getIntAttribute(this.getElement(), "size");
    }

    public void insertItem(String item, int index) {
        this.insertItem(item, null, index);
    }

    public void insertItem(String item, String value, int index) {
        DOM.insertListItem(this.getElement(), item, value, index);
    }

    public boolean isItemSelected(int index) {
        this.checkIndex(index);
        Element option = DOM.getChild(this.getElement(), index);
        return DOM.getBooleanAttribute(option, "selected");
    }

    public boolean isMultipleSelect() {
        return DOM.getBooleanAttribute(this.getElement(), "multiple");
    }

    public void onBrowserEvent(Event event) {
        if (DOM.eventGetType(event) == 1024) {
            if (this.changeListeners != null) {
                this.changeListeners.fireChange(this);
            }
        } else {
            super.onBrowserEvent(event);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(listener);
        }
    }

    public void removeItem(int index) {
        Element child = DOM.getChild(this.getElement(), index);
        DOM.removeChild(this.getElement(), child);
    }

    public void setItemSelected(int index, boolean selected) {
        this.checkIndex(index);
        Element option = DOM.getChild(this.getElement(), index);
        DOM.setBooleanAttribute(option, "selected", selected);
    }

    public void setItemText(int index, String text) {
        this.checkIndex(index);
        if (text == null) {
            throw new NullPointerException("Cannot set an option to have null text");
        }
        DOM.setOptionText(this.getElement(), text, index);
    }

    public void setMultipleSelect(boolean multiple) {
        DOM.setBooleanAttribute(this.getElement(), "multiple", multiple);
    }

    public void setName(String name) {
        DOM.setAttribute(this.getElement(), "name", name);
    }

    public void setSelectedIndex(int index) {
        DOM.setIntAttribute(this.getElement(), "selectedIndex", index);
    }

    public void setValue(int index, String value) {
        this.checkIndex(index);
        Element option = DOM.getChild(this.getElement(), index);
        DOM.setAttribute(option, "value", value);
    }

    public void setVisibleItemCount(int visibleItems) {
        DOM.setIntAttribute(this.getElement(), "size", visibleItems);
    }

    private void checkIndex(int index) {
        Element elem = this.getElement();
        if (index < 0 || index >= DOM.getChildCount(elem)) {
            throw new IndexOutOfBoundsException();
        }
    }
}

