/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.utils;

import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.log4j.Logger;

class IdleConnectionsMonitorThread
extends Thread {
    private final WeakReference<HttpClientConnectionManager> weakConnMgrRef;
    private volatile boolean shutdown;
    static final Logger logger = Logger.getLogger(IdleConnectionsMonitorThread.class);

    public IdleConnectionsMonitorThread(HttpClientConnectionManager connMgr) {
        this.weakConnMgrRef = new WeakReference<HttpClientConnectionManager>(connMgr);
        logger.warn((Object)"Starting Idle Connections Monitor...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {}
        catch (InterruptedException interruptedException) {
            return;
        }
        while (!this.shutdown) {
            IdleConnectionsMonitorThread idleConnectionsMonitorThread = this;
            synchronized (idleConnectionsMonitorThread) {
                this.wait(5000L);
                logger.debug((Object)"...calling closeExpire/IdleConnections...");
                try {
                    ((HttpClientConnectionManager)this.weakConnMgrRef.get()).closeExpiredConnections();
                    ((HttpClientConnectionManager)this.weakConnMgrRef.get()).closeIdleConnections(30L, TimeUnit.SECONDS);
                }
                catch (NullPointerException e) {
                    logger.warn((Object)"ConnectionManager out of scope. Shutting down Idle Connections Monitor...");
                    this.notifyAll();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        IdleConnectionsMonitorThread idleConnectionsMonitorThread = this;
        synchronized (idleConnectionsMonitorThread) {
            logger.warn((Object)"Shutting down Idle Connections Monitor...");
            this.notifyAll();
        }
    }
}

