/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.Utilities;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.style.ContrastMethod;

public class ContrastEnhancementImpl
implements ContrastEnhancement {
    private FilterFactory filterFactory;
    private Expression gamma;
    private Expression type;
    private ContrastMethod method;

    public ContrastEnhancementImpl() {
        this(CommonFactoryFinder.getFilterFactory(null));
    }

    public ContrastEnhancementImpl(FilterFactory factory) {
        this(factory, null);
    }

    public ContrastEnhancementImpl(FilterFactory factory, ContrastMethod method) {
        this.filterFactory = factory;
        this.method = method;
    }

    public ContrastEnhancementImpl(org.opengis.style.ContrastEnhancement contrastEnhancement) {
        this.filterFactory = CommonFactoryFinder.getFilterFactory2(null);
        this.method = contrastEnhancement.getMethod();
        this.gamma = contrastEnhancement.getGammaValue();
    }

    public ContrastEnhancementImpl(FilterFactory2 factory, Expression gamma, ContrastMethod method) {
        this.filterFactory = factory;
        this.gamma = gamma;
        this.method = method;
        this.type = factory.literal((Object)method.name());
    }

    public void setFilterFactory(FilterFactory factory) {
        this.filterFactory = factory;
    }

    public Expression getGammaValue() {
        return this.gamma;
    }

    public Expression getType() {
        return this.type;
    }

    public void setGammaValue(Expression gamma) {
        this.gamma = gamma;
    }

    public void setHistogram() {
        this.type = this.filterFactory.literal((Object)"Histogram");
        this.method = ContrastMethod.HISTOGRAM;
    }

    public void setNormalize() {
        this.type = this.filterFactory.literal((Object)"Normalize");
        this.method = ContrastMethod.NORMALIZE;
    }

    public void setLogarithmic() {
        this.type = this.filterFactory.literal((Object)"Logarithmic");
        this.method = ContrastMethod.NONE;
    }

    public void setExponential() {
        this.type = this.filterFactory.literal((Object)"Exponential");
        this.method = ContrastMethod.NONE;
    }

    public void setType(Expression type) {
        String value;
        this.type = type;
        this.method = type instanceof Literal ? ("Histogram".equalsIgnoreCase(value = (String)type.evaluate(null, String.class)) ? ContrastMethod.HISTOGRAM : ("Normalize".equalsIgnoreCase(value) ? ContrastMethod.NORMALIZE : ContrastMethod.NONE)) : ContrastMethod.NONE;
    }

    public void setMethod(ContrastMethod method) {
        if (method == ContrastMethod.NORMALIZE) {
            this.type = this.filterFactory.literal((Object)"Normalize");
            method = ContrastMethod.NORMALIZE;
        } else if (method == ContrastMethod.HISTOGRAM) {
            this.type = this.filterFactory.literal((Object)"Histogram");
            method = ContrastMethod.HISTOGRAM;
        } else {
            this.method = method;
        }
    }

    public ContrastMethod getMethod() {
        return this.method;
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object extraData) {
        return null;
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.gamma != null) {
            result = 1000003 * result + this.gamma.hashCode();
        }
        if (this.type != null) {
            result = 1000003 * result + this.type.hashCode();
        }
        if (this.method != null) {
            result = 1000003 * result + this.method.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ContrastEnhancementImpl) {
            ContrastEnhancementImpl other = (ContrastEnhancementImpl)obj;
            return Utilities.equals((Object)this.gamma, (Object)other.gamma) && Utilities.equals((Object)this.type, (Object)other.type) && Utilities.equals((Object)this.method, (Object)other.method);
        }
        return false;
    }

    static ContrastEnhancementImpl cast(org.opengis.style.ContrastEnhancement enhancement) {
        if (enhancement == null) {
            return null;
        }
        if (enhancement instanceof ContrastEnhancementImpl) {
            return (ContrastEnhancementImpl)enhancement;
        }
        ContrastEnhancementImpl copy = new ContrastEnhancementImpl();
        copy.setGammaValue(enhancement.getGammaValue());
        copy.setMethod(enhancement.getMethod());
        return copy;
    }
}

