<%@ page contentType="text/plain;charset=ISO-8859-1" import="java.io.*" %>
<% 
/************************************************
 * This is an example implementation of a Kepler AuthNamespace web service.
 * 
 * The output parameters are
 *   error, namespace
 * The optional input parameters are
 *   username, password, namespace
 *
 ************************************
 * Kepler AuthNamespace Web Service *
 ************************************
 *
 * The namespace that is returned shall always be unique for the given URL regardless of URI input parameters
 * The file type returned by the webservice shall be text/plain and shall contain the two output parameters
 *      formatted in accordance with the java.util.Properties specification.
 *
 * Optionally a username and password parameter may be supplied to the webservice for authenticating users
 *      or simply for disallowing robots from accessing the service.
 * Implementations of the AuthNamespace service may also optionally accept a namespace as an input,
 *      check to see if that namespace is available, and return it if it is available or return an error if it is not.
 *
 ************************************************/
try {
	/*
	 * The authority string should exactly match the URL this service is accessed by.
	 * This prevents having multiple URLs accessing this same JSP page which would be bad
	 *   since the namespaces generated by an authority must be unique to that authority.
	 */
	String authority = "http://library.kepler-project.org/kepler/style/skins/kepler/keplerAuthNameSpace.jsp";
	String accessedAuthority = request.getRequestURL().toString();
	
	/*
	 * Get username and password inputs.
	 */
	String user = request.getParameter( "username" );
	String pass = request.getParameter( "password" );
	
	/*
	 * Make sure the URL used to access this service is the correct authority URL.
	 */
	if ( accessedAuthority != null && accessedAuthority.equals( authority )) {
	
		/* 
		 * Check to make sure the "kepler" username/password was given
		 * This will prevent stray robots or users from incrementing namespaces arbitrarily.
		 */
		if ( user != null && user.equals("kepler") ) {
			if ( pass != null && pass.equals("kepler") ) {
				
				if ( request.getParameter( "namespace" ) != null ) {
					// TODO query a database for the requested namespace
					// print namespace if it is not already taken and insert it into the database
					// return an error if the namespace has already been reserved
				} else {
				
					/* Store an incrementing integer in a file.
					 * This approach may fail due to collisions under high load conditions.
					 * But works fine for this example implementation.
					 */
					ServletContext context = session.getServletContext();
					String fname = "/var/kepler/last_issued_namespace.txt";

					Integer inc = new Integer(0);

					File f = new File( fname );
					if (f.exists()) {
					
						// Read in the previous Integer
						InputStream is = new FileInputStream(fname);
						ObjectInput oi = new ObjectInputStream(is);
						inc = (Integer) oi.readObject();
						oi.close();

						int i = inc.intValue() + 1;
						inc = new Integer( i );

					}
					
					// Write out the incremented integer (or 0 if the file does not exist)
					OutputStream os = new FileOutputStream(fname);
					ObjectOutputStream oos = new ObjectOutputStream(os);
					oos.writeObject( inc );
					oos.flush();
					oos.close();

					/*
					 * Print out the incremented Integer as the namespace output
					 * in java.util.Properties format.
					 */
					out.println( "namespace=" + inc + "\n" );
				}
				
			} else {
				throw new Exception("The specified password is incorrect");
			}
		} else {
			throw new Exception("The specified username is incorrect.");
		}
	} else {
		throw new Exception("The specified authority URL is incorrect.");
	}

} catch (Exception e) { 
	
	/*
	 * Print out the error in java.util.Properties format.
	 */
	out.println( "error=" + e.getMessage() + "\n" );
} 
%>