/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.ezid;

import edu.ucsb.nceas.ezid.EZIDException;
import edu.ucsb.nceas.ezid.profile.InternalProfile;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class EZIDService {
    private static final int GET = 1;
    private static final int PUT = 2;
    private static final int POST = 3;
    private static final int DELETE = 4;
    private static final int CONNECTIONS_PER_ROUTE = 8;
    private String serviceBaseUrl = "https://ezid.cdlib.org/";
    private String loginServiceEndpoint = null;
    private String logoutServiceEndpoint = null;
    private String idServiceEndpoint = null;
    private String mintServiceEndpoint = null;
    private DefaultHttpClient httpclient = EZIDService.createThreadSafeClient();
    private BasicCookieStore cookieStore = new BasicCookieStore();
    protected static Log log = LogFactory.getLog(EZIDService.class);

    public EZIDService(String baseUrl) {
        this.httpclient.setCookieStore((CookieStore)this.cookieStore);
        if (baseUrl != null) {
            this.serviceBaseUrl = baseUrl;
        }
        this.loginServiceEndpoint = this.serviceBaseUrl + "/login";
        this.logoutServiceEndpoint = this.serviceBaseUrl + "/logout";
        this.idServiceEndpoint = this.serviceBaseUrl + "/id";
        this.mintServiceEndpoint = this.serviceBaseUrl + "/shoulder";
    }

    public EZIDService() {
        this(null);
    }

    public void login(String username, String password) throws EZIDException {
        try {
            URI serviceUri = new URI(this.loginServiceEndpoint);
            HttpHost targetHost = new HttpHost(serviceUri.getHost(), serviceUri.getPort(), serviceUri.getScheme());
            this.httpclient.getCredentialsProvider().setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(targetHost, (AuthScheme)basicAuth);
            BasicHttpContext localcontext = new BasicHttpContext();
            localcontext.setAttribute("http.auth.auth-cache", (Object)authCache);
            ResponseHandler<byte[]> handler = new ResponseHandler<byte[]>(){

                public byte[] handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        return EntityUtils.toByteArray((HttpEntity)entity);
                    }
                    return null;
                }
            };
            byte[] body = null;
            HttpGet httpget = new HttpGet(this.loginServiceEndpoint);
            body = (byte[])this.httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)handler, (HttpContext)localcontext);
            String message = new String(body);
            String msg = this.parseIdentifierResponse(message);
        }
        catch (URISyntaxException e) {
            throw new EZIDException(e.getMessage());
        }
        catch (ClientProtocolException e) {
            throw new EZIDException(e.getMessage());
        }
        catch (IOException e) {
            throw new EZIDException(e.getMessage());
        }
    }

    public void logout() throws EZIDException {
        String ezidEndpoint = this.logoutServiceEndpoint;
        byte[] response = this.sendRequest(1, ezidEndpoint);
        String message = new String(response);
        String msg = this.parseIdentifierResponse(message);
    }

    public String createIdentifier(String identifier, HashMap<String, String> metadata) throws EZIDException {
        Object newId = null;
        String ezidEndpoint = this.idServiceEndpoint + "/" + identifier;
        String anvl = this.serializeAsANVL(metadata);
        byte[] response = this.sendRequest(2, ezidEndpoint, anvl);
        String responseMsg = new String(response);
        log.debug((Object)responseMsg);
        return this.parseIdentifierResponse(responseMsg);
    }

    public String mintIdentifier(String shoulder, HashMap<String, String> metadata) throws EZIDException {
        String ezidEndpoint = this.mintServiceEndpoint + "/" + shoulder;
        String anvl = this.serializeAsANVL(metadata);
        byte[] response = this.sendRequest(3, ezidEndpoint, anvl);
        String responseMsg = new String(response);
        log.debug((Object)responseMsg);
        return this.parseIdentifierResponse(responseMsg);
    }

    public HashMap<String, String> getMetadata(String identifier) throws EZIDException {
        String ezidEndpoint = this.idServiceEndpoint + "/" + identifier;
        byte[] response = this.sendRequest(1, ezidEndpoint);
        String anvl = new String(response);
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (String l : anvl.split("[\\r\\n]+")) {
            String[] kv = l.split(":", 2);
            String key = this.unescape(kv[0]).trim();
            String value = this.unescape(kv[1]).trim();
            if (key.equals(InternalProfile.ERROR.toString())) {
                throw new EZIDException(value);
            }
            metadata.put(key, value);
        }
        return metadata;
    }

    public void setMetadata(String identifier, HashMap<String, String> metadata) throws EZIDException {
        String ezidEndpoint = this.idServiceEndpoint + "/" + identifier;
        String anvl = this.serializeAsANVL(metadata);
        byte[] response = this.sendRequest(3, ezidEndpoint, anvl);
        String responseMsg = new String(response);
        log.debug((Object)responseMsg);
        String modifiedId = this.parseIdentifierResponse(responseMsg);
    }

    public void deleteIdentifier(String identifier) throws EZIDException {
        String ezidEndpoint = this.idServiceEndpoint + "/" + identifier;
        byte[] response = this.sendRequest(4, ezidEndpoint);
        String responseMsg = new String(response);
        String deletedId = this.parseIdentifierResponse(responseMsg);
    }

    private static DefaultHttpClient createThreadSafeClient() {
        DefaultHttpClient client = new DefaultHttpClient();
        ClientConnectionManager mgr = client.getConnectionManager();
        HttpParams params = client.getParams();
        ThreadSafeClientConnManager connManager = new ThreadSafeClientConnManager(mgr.getSchemeRegistry());
        connManager.setDefaultMaxPerRoute(8);
        client = new DefaultHttpClient((ClientConnectionManager)connManager, params);
        return client;
    }

    private byte[] sendRequest(int requestType, String uri) throws EZIDException {
        return this.sendRequest(requestType, uri, null);
    }

    private byte[] sendRequest(int requestType, String uri, String requestBody) throws EZIDException {
        HttpGet request = null;
        log.debug((Object)("Trying uri: " + uri));
        switch (requestType) {
            case 1: {
                request = new HttpGet(uri);
                break;
            }
            case 2: {
                StringEntity myEntity;
                request = new HttpPut(uri);
                if (requestBody == null || requestBody.length() <= 0) break;
                try {
                    myEntity = new StringEntity(requestBody, "UTF-8");
                    ((HttpPut)request).setEntity((HttpEntity)myEntity);
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    throw new EZIDException(e.getMessage());
                }
            }
            case 3: {
                StringEntity myEntity;
                request = new HttpPost(uri);
                if (requestBody == null || requestBody.length() <= 0) break;
                try {
                    myEntity = new StringEntity(requestBody, "UTF-8");
                    ((HttpPost)request).setEntity((HttpEntity)myEntity);
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    throw new EZIDException(e.getMessage());
                }
            }
            case 4: {
                request = new HttpDelete(uri);
                break;
            }
            default: {
                throw new EZIDException("Unrecognized HTTP method requested.");
            }
        }
        request.addHeader("Accept", "text/plain");
        ResponseHandler<byte[]> handler = new ResponseHandler<byte[]>(){

            public byte[] handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    return EntityUtils.toByteArray((HttpEntity)entity);
                }
                return null;
            }
        };
        byte[] body = null;
        try {
            body = (byte[])this.httpclient.execute((HttpUriRequest)request, (ResponseHandler)handler);
        }
        catch (ClientProtocolException e) {
            throw new EZIDException(e.getMessage());
        }
        catch (IOException e) {
            throw new EZIDException(e.getMessage());
        }
        return body;
    }

    private String parseIdentifierResponse(String responseMsg) throws EZIDException {
        String[] responseArray = responseMsg.split(":", 2);
        String resultCode = this.unescape(responseArray[0]).trim();
        if (resultCode.equals(InternalProfile.SUCCESS.toString())) {
            String[] idList = this.unescape(responseArray[1]).trim().split("\\|");
            String newId = idList[0].trim();
            return newId;
        }
        String msg = this.unescape(responseArray[1]).trim();
        throw new EZIDException(msg);
    }

    private String serializeAsANVL(HashMap<String, String> metadata) {
        StringBuffer buffer = new StringBuffer();
        if (metadata != null && metadata.size() > 0) {
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                buffer.append(this.escape(entry.getKey()) + ": " + this.escape(entry.getValue()) + "\n");
            }
        }
        String anvl = null;
        if (buffer != null) {
            anvl = buffer.toString();
        }
        return anvl;
    }

    private String escape(String str) {
        return str.replace("%", "%25").replace("\n", "%0A").replace("\r", "%0D").replace(":", "%3A");
    }

    private String unescape(String str) {
        int i;
        StringBuffer buffer = new StringBuffer();
        while ((i = str.indexOf("%")) >= 0) {
            buffer.append(str.substring(0, i));
            buffer.append((char)Integer.parseInt(str.substring(i + 1, i + 3), 16));
            str = str.substring(i + 3);
        }
        buffer.append(str);
        return buffer.toString();
    }
}

