/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.index.processor;

import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import org.dataone.client.v2.formats.ObjectFormatCache;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.index.processor.IndexTaskProcessingStrategy;
import org.dataone.cn.index.task.IndexTask;
import org.dataone.cn.index.task.IndexTaskRepository;
import org.dataone.cn.index.util.PerformanceLogger;
import org.dataone.cn.indexer.XmlDocumentUtility;
import org.dataone.cn.indexer.resourcemap.ForesiteResourceMap;
import org.dataone.cn.indexer.resourcemap.ResourceMap;
import org.dataone.cn.indexer.resourcemap.ResourceMapFactory;
import org.dataone.cn.indexer.solrhttp.HTTPService;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.SystemMetadata;
import org.dspace.foresite.OREParserException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate3.HibernateOptimisticLockingFailureException;
import org.w3c.dom.Document;

public class IndexTaskProcessor {
    private static Logger logger = Logger.getLogger((String)IndexTaskProcessor.class.getName());
    private static final String FORMAT_TYPE_DATA = "DATA";
    private static final String LOAD_LOGGER_NAME = "indexProcessorLoad";
    @Autowired
    private IndexTaskRepository repo;
    @Autowired
    private IndexTaskProcessingStrategy deleteProcessor;
    @Autowired
    private IndexTaskProcessingStrategy updateProcessor;
    @Autowired
    private HTTPService httpService;
    @Autowired
    private String solrQueryUri;
    private PerformanceLogger perfLog = PerformanceLogger.getInstance();

    public void processIndexTaskQueue() {
        this.logProcessorLoad();
        List<IndexTask> queue = this.getIndexTaskQueue();
        IndexTask task = this.getNextIndexTask(queue);
        while (task != null) {
            this.processTask(task);
            task = this.getNextIndexTask(queue);
        }
        List<IndexTask> retryQueue = this.getIndexTaskRetryQueue();
        task = this.getNextIndexTask(retryQueue);
        while (task != null) {
            this.processTask(task);
            task = this.getNextIndexTask(queue);
        }
    }

    private void logProcessorLoad() {
        Logger loadLogger = Logger.getLogger((String)LOAD_LOGGER_NAME);
        Long newTasks = null;
        Long failedTasks = null;
        try {
            newTasks = this.repo.countByStatus("NEW");
            failedTasks = this.repo.countByStatus("FAILED");
        }
        catch (Exception e) {
            logger.error((Object)"Unable to count NEW or FAILED tasks in task index repository.", (Throwable)e);
        }
        loadLogger.info((Object)("new:" + newTasks + ", failed: " + failedTasks));
    }

    private void processTask(IndexTask task) {
        try {
            if (task.isDeleteTask()) {
                logger.info((Object)("Indexing delete task for pid: " + task.getPid()));
                this.deleteProcessor.process(task);
            } else {
                logger.info((Object)("Indexing update task for pid: " + task.getPid()));
                this.updateProcessor.process(task);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to process task for pid: " + task.getPid()), (Throwable)e);
            this.handleFailedTask(task);
            return;
        }
        this.repo.delete((Object)task);
        logger.info((Object)("Indexing complete for pid: " + task.getPid()));
    }

    private void handleFailedTask(IndexTask task) {
        task.markFailed();
        this.saveTask(task);
    }

    private IndexTask getNextIndexTask(List<IndexTask> queue) {
        IndexTask task = null;
        while (task == null && !queue.isEmpty()) {
            task = queue.remove(0);
            task.markInProgress();
            task = this.saveTask(task);
            logger.info((Object)("Start of indexing pid: " + task.getPid()));
            if (task != null && task.isDeleteTask()) {
                return task;
            }
            if (task != null && !this.isObjectPathReady(task)) {
                task.markNew();
                this.saveTask(task);
                logger.info((Object)("Task for pid: " + task.getPid() + " not processed."));
                task = null;
                continue;
            }
            if (task == null || this.isResourceMapReadyToIndex(task, queue)) continue;
            task.markNew();
            this.saveTask(task);
            logger.info((Object)("Task for pid: " + task.getPid() + " not processed."));
            task = null;
        }
        return task;
    }

    private boolean isResourceMapReadyToIndex(IndexTask task, List<IndexTask> queue) {
        boolean ready = true;
        if (this.representsResourceMap(task)) {
            ResourceMap rm = null;
            try {
                rm = ResourceMapFactory.buildResourceMap(task.getObjectPath());
                List<String> referencedIds = rm.getAllDocumentIDs();
                referencedIds.remove(task.getPid());
                if (!this.areAllReferencedDocsIndexed(referencedIds)) {
                    logger.info((Object)("Not all map resource references indexed for map: " + task.getPid() + ".  Marking new and continuing..."));
                    ready = false;
                }
            }
            catch (OREParserException oreException) {
                ready = false;
                logger.error((Object)("Unable to parse ORE doc: " + task.getPid() + ".  Unrecoverable parse error: task will not be re-tried."));
                if (logger.isTraceEnabled()) {
                    oreException.printStackTrace();
                }
            }
            catch (Exception e) {
                ready = false;
                logger.error((Object)("unable to load resource for pid: " + task.getPid() + " at object path: " + task.getObjectPath() + ".  Marking new and continuing..."));
            }
        }
        return ready;
    }

    private boolean areAllReferencedDocsIndexed(List<String> referencedIds) {
        if (referencedIds == null || referencedIds.size() == 0) {
            return true;
        }
        List<SolrDoc> updateDocuments = null;
        int numberOfIndexedOrRemovedReferences = 0;
        try {
            updateDocuments = this.httpService.getDocumentsById(this.solrQueryUri, referencedIds);
            numberOfIndexedOrRemovedReferences = 0;
            for (String id : referencedIds) {
                boolean foundId = false;
                for (SolrDoc solrDoc : updateDocuments) {
                    if (!solrDoc.getIdentifier().equals(id) && !id.equals(solrDoc.getSeriesId())) continue;
                    foundId = true;
                    ++numberOfIndexedOrRemovedReferences;
                    break;
                }
                if (foundId) continue;
                Identifier pid = new Identifier();
                pid.setValue(id);
                logger.debug((Object)("Identifier " + id + " was not found in the referenced id list in the Solr search index."));
                SystemMetadata smd = (SystemMetadata)HazelcastClientFactory.getSystemMetadataMap().get((Object)pid);
                if (smd == null || !this.notVisibleInIndex(smd)) continue;
                ++numberOfIndexedOrRemovedReferences;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return referencedIds.size() == numberOfIndexedOrRemovedReferences;
    }

    private boolean notVisibleInIndex(SystemMetadata smd) {
        return !SolrDoc.visibleInIndex(smd) && smd != null;
    }

    private boolean representsResourceMap(IndexTask task) {
        return ForesiteResourceMap.representsResourceMap(task.getFormatId());
    }

    private boolean isObjectPathReady(IndexTask task) {
        File objectPathFile;
        boolean ok = true;
        boolean isDataObject = this.isDataObject(task);
        if (task.getObjectPath() == null && !isDataObject) {
            String objectPath = this.retrieveObjectPath(task.getPid());
            if (objectPath == null) {
                ok = false;
                this.evictObjectPathEntry(task.getPid());
                logger.info((Object)("Object path for pid: " + task.getPid() + " is not available.  Object path entry will be evicting from map.  " + "Task will be retried."));
            }
            task.setObjectPath(objectPath);
        }
        if (task.getObjectPath() != null && !isDataObject && !(objectPathFile = new File(task.getObjectPath())).exists()) {
            ok = false;
            logger.info((Object)("Object path exists for pid: " + task.getPid() + " however the file location: " + task.getObjectPath() + " does not exist.  " + "Marking not ready - task will be marked new and retried."));
        }
        return ok;
    }

    private boolean isDataObject(IndexTask task) {
        ObjectFormat format = null;
        try {
            ObjectFormatIdentifier formatId = new ObjectFormatIdentifier();
            formatId.setValue(task.getFormatId());
            format = ObjectFormatCache.getInstance().getFormat(formatId);
        }
        catch (BaseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return FORMAT_TYPE_DATA.equals(format.getFormatType());
    }

    private String retrieveObjectPath(String pid) {
        Identifier PID = new Identifier();
        PID.setValue(pid);
        return (String)HazelcastClientFactory.getObjectPathMap().get((Object)PID);
    }

    private void evictObjectPathEntry(String pid) {
        Identifier PID = new Identifier();
        PID.setValue(pid);
        HazelcastClientFactory.getObjectPathMap().evict((Object)PID);
    }

    private List<IndexTask> getIndexTaskQueue() {
        long getIndexTasksStart = System.currentTimeMillis();
        List indexTasks = this.repo.findByStatusOrderByPriorityAscTaskModifiedDateAsc("NEW");
        this.perfLog.log("IndexTaskProcessor.getIndexTaskQueue() fetching NEW IndexTasks from repo", System.currentTimeMillis() - getIndexTasksStart);
        return indexTasks;
    }

    private List<IndexTask> getIndexTaskRetryQueue() {
        return this.repo.findByStatusAndNextExecutionLessThan("FAILED", System.currentTimeMillis());
    }

    private IndexTask saveTask(IndexTask task) {
        try {
            task = (IndexTask)this.repo.save((Object)task);
        }
        catch (HibernateOptimisticLockingFailureException e) {
            logger.error((Object)("Unable to update index task for pid: " + task.getPid() + "."));
            task = null;
        }
        return task;
    }

    private Document loadDocument(IndexTask task) {
        Document docObject = null;
        try {
            docObject = XmlDocumentUtility.loadDocument(task.getObjectPath());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (docObject == null) {
            logger.error((Object)("Could not load OBJECT file for ID,Path=" + task.getPid() + ", " + task.getObjectPath()));
        }
        return docObject;
    }

    public void setSolrQueryUri(String uri) {
        this.solrQueryUri = uri;
    }
}

