/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.annotation;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.tdb.TDBFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.indexer.annotation.SparqlField;
import org.dataone.cn.indexer.annotation.TripleStoreService;
import org.dataone.cn.indexer.parser.IDocumentSubprocessor;
import org.dataone.cn.indexer.parser.ISolrDataField;
import org.dataone.cn.indexer.parser.SubprocessorUtility;
import org.dataone.cn.indexer.solrhttp.HTTPService;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.springframework.beans.factory.annotation.Autowired;

public class RdfXmlSubprocessor
implements IDocumentSubprocessor {
    private static Log log = LogFactory.getLog(RdfXmlSubprocessor.class);
    private List<String> matchDocuments = null;
    private List<ISolrDataField> fieldList = new ArrayList<ISolrDataField>();
    private List<String> fieldsToMerge = new ArrayList<String>();
    @Autowired
    private HTTPService httpService = null;
    @Autowired
    private String solrQueryUri = null;
    @Autowired
    private SubprocessorUtility processorUtility;

    @Override
    public boolean canProcess(String formatId) {
        return this.matchDocuments.contains(formatId);
    }

    public List<String> getMatchDocuments() {
        return this.matchDocuments;
    }

    public void setMatchDocuments(List<String> matchDocuments) {
        this.matchDocuments = matchDocuments;
    }

    public List<ISolrDataField> getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(List<ISolrDataField> fieldList) {
        this.fieldList = fieldList;
    }

    @Override
    public Map<String, SolrDoc> processDocument(String identifier, Map<String, SolrDoc> docs, InputStream is) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)"INCOMING DOCS to processDocument(): ");
            this.serializeDocuments(docs);
        }
        SolrDoc resourceMapDoc = docs.get(identifier);
        List<SolrDoc> processedDocs = this.process(resourceMapDoc, is);
        HashMap<String, SolrDoc> processedDocsMap = new HashMap<String, SolrDoc>();
        for (SolrDoc processedDoc : processedDocs) {
            processedDocsMap.put(processedDoc.getIdentifier(), processedDoc);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"PREMERGED DOCS from processDocument(): ");
            this.serializeDocuments(processedDocsMap);
        }
        Map<String, SolrDoc> mergedDocs = this.mergeDocs(docs, processedDocsMap);
        if (log.isTraceEnabled()) {
            log.trace((Object)"OUTGOING DOCS from processDocument(): ");
            this.serializeDocuments(mergedDocs);
        }
        return mergedDocs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeDocuments(Map<String, SolrDoc> docs) {
        StringBuilder documents = new StringBuilder();
        documents.append("<docs>");
        for (SolrDoc doc : docs.values()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                doc.serialize(baos, "UTF-8");
            }
            catch (IOException e) {
                log.trace((Object)("Couldn't serialize documents: " + e.getMessage()));
            }
            try {
                documents.append(baos.toString());
            }
            finally {
                IOUtils.closeQuietly((OutputStream)baos);
            }
        }
        documents.append("</docs>");
        log.trace((Object)documents.toString());
    }

    private List<SolrDoc> process(SolrDoc indexDocument, InputStream is) throws Exception {
        boolean loaded;
        String indexDocId;
        Dataset dataset = TripleStoreService.getInstance().getDataset();
        String name = indexDocId = indexDocument.getIdentifier();
        String scheme = null;
        try {
            URI nameURI = new URI(indexDocId);
            scheme = nameURI.getScheme();
        }
        catch (URISyntaxException use) {
            name = "https://cn.dataone.org/cn/v1/resolve/" + indexDocId;
        }
        if (scheme == null || scheme.isEmpty()) {
            name = "https://cn.dataone.org/cn/v1/resolve/" + indexDocId;
        }
        if (!(loaded = dataset.containsNamedModel(name))) {
            OntModel ontModel = ModelFactory.createOntologyModel();
            ontModel.read(is, name);
            dataset.addNamedModel(name, (Model)ontModel);
        }
        HashMap<String, SolrDoc> documentsToIndex = new HashMap<String, SolrDoc>();
        for (ISolrDataField field : this.fieldList) {
            String q = null;
            if (!(field instanceof SparqlField)) continue;
            q = ((SparqlField)field).getQuery();
            q = q.replaceAll("\\$GRAPH_NAME", name);
            Query query = QueryFactory.create((String)q);
            log.trace((Object)("Executing SPARQL query:\n" + query.toString()));
            QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                SolrDoc solrDoc = null;
                QuerySolution solution = results.next();
                log.trace((Object)solution.toString());
                if (solution.contains("pid")) {
                    String id = solution.getLiteral("pid").getString();
                    boolean statementAuthorized = true;
                    if (!statementAuthorized) continue;
                    solrDoc = (SolrDoc)documentsToIndex.get(id);
                    if (solrDoc == null) {
                        solrDoc = new SolrDoc();
                        solrDoc.addField(new SolrElementField("id", id));
                        documentsToIndex.put(id, solrDoc);
                    }
                }
                if (!solution.contains(field.getName())) continue;
                String value = solution.get(field.getName()).toString();
                SolrElementField f = new SolrElementField(field.getName(), value);
                if (solrDoc.hasFieldWithValue(f.getName(), f.getValue())) continue;
                solrDoc.addField(f);
            }
        }
        TDBFactory.release((Dataset)dataset);
        Map<String, SolrDoc> existingDocuments = this.getSolrDocs(documentsToIndex.keySet());
        Map<String, SolrDoc> mergedDocuments = this.mergeDocs(documentsToIndex, existingDocuments);
        mergedDocuments.put(indexDocument.getIdentifier(), indexDocument);
        return new ArrayList<SolrDoc>(mergedDocuments.values());
    }

    private Map<String, SolrDoc> getSolrDocs(Set<String> ids) throws Exception {
        HashMap<String, SolrDoc> list = new HashMap<String, SolrDoc>();
        if (ids != null) {
            for (String id : ids) {
                SolrDoc doc = this.httpService.retrieveDocumentFromSolrServer(id, this.solrQueryUri);
                if (doc == null) continue;
                list.put(id, doc);
            }
        }
        return list;
    }

    private Map<String, SolrDoc> mergeDocs(Map<String, SolrDoc> pending, Map<String, SolrDoc> existing) throws Exception {
        HashMap<String, SolrDoc> merged = new HashMap<String, SolrDoc>();
        for (String id : pending.keySet()) {
            SolrDoc pendingDoc = pending.get(id);
            SolrDoc existingDoc = existing.get(id);
            SolrDoc mergedDoc = new SolrDoc();
            if (existingDoc != null) {
                for (SolrElementField field : existingDoc.getFieldList()) {
                    mergedDoc.addField(field);
                }
            }
            for (SolrElementField field : pendingDoc.getFieldList()) {
                if (field.getName().equals("id") && mergedDoc.hasField("id") || mergedDoc.hasFieldWithValue(field.getName(), field.getValue())) continue;
                mergedDoc.addField(field);
            }
            merged.put(id, mergedDoc);
        }
        for (String existingId : existing.keySet()) {
            if (merged.containsKey(existingId)) continue;
            merged.put(existingId, existing.get(existingId));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"MERGED DOCS with existing from the Solr index: ");
            this.serializeDocuments(merged);
        }
        return merged;
    }

    @Override
    public SolrDoc mergeWithIndexedDocument(SolrDoc indexDocument) throws IOException, EncoderException, XPathExpressionException {
        return this.processorUtility.mergeWithIndexedDocument(indexDocument, this.fieldsToMerge);
    }

    public List<String> getFieldsToMerge() {
        return this.fieldsToMerge;
    }

    public void setFieldsToMerge(List<String> fieldsToMerge) {
        this.fieldsToMerge = fieldsToMerge;
    }
}

