/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.convert;

import ch.hsr.geohash.BoundingBox;
import ch.hsr.geohash.GeoHash;
import ch.hsr.geohash.WGS84Point;
import org.dataone.cn.indexer.convert.IConverter;

public class GeohashConverter
implements IConverter {
    private int length = 9;

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public String convert(String latlong) {
        BoundingBox bbox = null;
        String geohash = null;
        double geohashLat = 0.0;
        double geohashLong = 0.0;
        WGS84Point centerPoint = null;
        String[] coords = latlong.split(" ");
        if (coords.length == 2) {
            geohashLat = Double.parseDouble(coords[0]);
            geohashLong = Double.parseDouble(coords[1]);
        } else if (coords.length == 4) {
            double northCoord = Double.parseDouble(coords[0]);
            double southCoord = Double.parseDouble(coords[1]);
            double eastCoord = Double.parseDouble(coords[2]);
            double westCoord = Double.parseDouble(coords[3]);
            if (westCoord == eastCoord || southCoord == northCoord) {
                geohashLat = southCoord;
                geohashLong = westCoord;
            } else {
                bbox = new BoundingBox(southCoord, northCoord, westCoord, eastCoord);
                centerPoint = bbox.getCenterPoint();
                geohashLat = centerPoint.getLatitude();
                geohashLong = centerPoint.getLongitude();
            }
        } else {
            return null;
        }
        try {
            geohash = GeoHash.withCharacterPrecision((double)geohashLat, (double)geohashLong, (int)this.length).toBase32();
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        return geohash;
    }
}

