/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringEscapeUtils;
import org.dataone.cn.indexer.parser.SolrField;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MergeSolrField
extends SolrField {
    private String delimiter = " ";

    public MergeSolrField(String name, String xpath) {
        super(name, xpath);
    }

    public MergeSolrField(String name, String xpath, String delimiter) {
        super(name, xpath);
        this.delimiter = delimiter;
    }

    @Override
    public List<SolrElementField> processField(Document doc) throws XPathExpressionException, IOException, SAXException, ParserConfigurationException {
        ArrayList<SolrElementField> fields = new ArrayList<SolrElementField>();
        try {
            NodeList values = (NodeList)this.xPathExpression.evaluate(doc, XPathConstants.NODESET);
            HashSet<String> usedValues = new HashSet<String>();
            StringBuilder sb = new StringBuilder();
            int imax = values.getLength();
            for (int i = 0; i < imax; ++i) {
                Node n = values.item(i);
                String nodeValue = n.getNodeValue();
                if (nodeValue == null || !(!this.dedupe | this.dedupe & !usedValues.contains(nodeValue = nodeValue.trim())) || !this.allowedValue(nodeValue)) continue;
                sb.append(nodeValue);
                if (i < imax - 1) {
                    sb.append(this.delimiter);
                }
                if (!this.dedupe) continue;
                usedValues.add(nodeValue);
            }
            String nodeValue = sb.toString().trim();
            if (this.escapeXML) {
                nodeValue = StringEscapeUtils.escapeXml((String)nodeValue);
            }
            fields.add(new SolrElementField(this.name, nodeValue));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return fields;
    }
}

