/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.index.generator;

import java.util.List;
import org.apache.log4j.Logger;
import org.dataone.cn.index.task.IndexTask;
import org.dataone.cn.index.task.IndexTaskRepository;
import org.dataone.service.types.v2.SystemMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate3.HibernateOptimisticLockingFailureException;

public class IndexTaskGenerator {
    private static Logger logger = Logger.getLogger((String)IndexTaskGenerator.class.getName());
    private static final String IGNOREPID = "OBJECT_FORMAT_LIST.1.1";
    @Autowired
    private IndexTaskRepository repo;

    public IndexTask processSystemMetaDataAdd(SystemMetadata smd, String objectPath) {
        if (this.isNotIgnorePid(smd)) {
            this.removeDuplicateNewTasks(smd);
            IndexTask task = new IndexTask(smd, objectPath);
            task.setAddPriority();
            task = (IndexTask)this.repo.save((Object)task);
            return task;
        }
        return null;
    }

    public IndexTask processSystemMetaDataUpdate(SystemMetadata smd, String objectPath) {
        if (this.isNotIgnorePid(smd)) {
            this.removeDuplicateNewTasks(smd);
            IndexTask task = new IndexTask(smd, objectPath);
            task.setUpdatePriority();
            task = (IndexTask)this.repo.save((Object)task);
            return task;
        }
        return null;
    }

    public IndexTask processSystemMetaDataDelete(SystemMetadata smd) {
        if (this.isNotIgnorePid(smd)) {
            this.removeDuplicateNewTasks(smd);
            IndexTask task = new IndexTask(smd, null);
            task.setDeleted(true);
            task = (IndexTask)this.repo.save((Object)task);
            return task;
        }
        return null;
    }

    private boolean isNotIgnorePid(SystemMetadata smd) {
        return !IGNOREPID.equals(smd.getIdentifier().getValue());
    }

    private void removeDuplicateNewTasks(SystemMetadata smd) {
        this.removeDuplicateTasksByStatus(smd, "NEW");
        this.removeDuplicateTasksByStatus(smd, "FAILED");
    }

    private void removeDuplicateTasksByStatus(SystemMetadata smd, String status) {
        List itList = this.repo.findByPidAndStatus(smd.getIdentifier().getValue(), status);
        for (IndexTask indexTask : itList) {
            try {
                this.repo.delete((Object)indexTask);
            }
            catch (HibernateOptimisticLockingFailureException e) {
                logger.debug((Object)("Unable to delete existing index task for pid: " + indexTask.getPid() + " prior to generating new index task."));
            }
        }
    }
}

