/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LogWritable;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.InconsistentNodeException;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;

public abstract class Node
implements LoggableObject,
LogReadable,
LogWritable {
    private static long lastAllocatedId = 0L;
    private static final String BEGIN_TAG = "<node>";
    private static final String END_TAG = "</node>";
    private long nodeId;

    public static void setLastNodeId(long id) {
        lastAllocatedId = id;
    }

    private Node() {
    }

    protected Node(boolean init) {
        if (init) {
            this.nodeId = Node.getNextNodeId();
        }
    }

    private static synchronized long getNextNodeId() {
        return ++lastAllocatedId;
    }

    public static synchronized long getLastId() {
        return lastAllocatedId;
    }

    public void postFetchInit(DatabaseImpl db) throws DatabaseException {
    }

    public long getNodeId() {
        return this.nodeId;
    }

    void setNodeId(long nid) {
        this.nodeId = nid;
    }

    public void verify(Key maxKey) throws InconsistentNodeException {
    }

    public boolean containsDuplicates() {
        return false;
    }

    int getLevel() {
        return 0;
    }

    boolean matchLNByNodeId(TreeLocation location, long nodeId) throws DatabaseException {
        throw new DatabaseException("matchLNByNodeId called on non DIN/DBIN");
    }

    abstract void rebuildINList(INList var1) throws DatabaseException;

    abstract void removeFromINList(INList var1) throws DatabaseException;

    abstract boolean isValidForDelete() throws DatabaseException;

    protected abstract boolean isSoughtNode(long var1) throws DatabaseException;

    protected abstract boolean canBeAncestor(IN var1);

    protected long getMemorySizeIncludedByParent() {
        return 0L;
    }

    public String toString() {
        return this.dumpString(0, true);
    }

    private String beginTag() {
        return BEGIN_TAG;
    }

    private String endTag() {
        return END_TAG;
    }

    public void dump(int nSpaces) {
        System.out.print(this.dumpString(nSpaces, true));
    }

    String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer self = new StringBuffer();
        self.append(TreeUtils.indent(nSpaces));
        if (dumpTags) {
            self.append(this.beginTag());
        }
        self.append(this.nodeId);
        if (dumpTags) {
            self.append(this.endTag());
        }
        return self.toString();
    }

    public String shortDescription() {
        return "<" + this.getType() + "/" + this.getNodeId();
    }

    public String getType() {
        return this.getClass().getName();
    }

    public abstract LogEntryType getLogType();

    public boolean marshallOutsideWriteLatch() {
        return true;
    }

    public void postLogWork(DbLsn justLoggedLsn) throws DatabaseException {
    }

    public int getLogSize() {
        return 8;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeLong(logBuffer, this.nodeId);
    }

    public void readFromLog(ByteBuffer itemBuffer) throws LogException {
        this.nodeId = LogUtils.readLong(itemBuffer);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append(BEGIN_TAG);
        sb.append(this.nodeId);
        sb.append(END_TAG);
    }

    public static long readNodeIdFromLog(ByteBuffer itemBuffer, int entrySize) {
        long nodeId = LogUtils.readLong(itemBuffer);
        itemBuffer.position(itemBuffer.position() + entrySize - 8);
        return nodeId;
    }
}

