/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.log;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.params.SolrParams;
import org.dataone.cn.log.AuditEvent;
import org.dataone.cn.log.AuditLogClient;
import org.dataone.cn.log.AuditLogClientFactory;
import org.dataone.cn.log.AuditLogEntry;
import org.dataone.configuration.Settings;

public class AuditLogClientSolrImpl
implements AuditLogClient {
    private static Logger log = Logger.getLogger((String)AuditLogClientSolrImpl.class.getName());
    private static final String AUDIT_LOG_URL = Settings.getConfiguration().getString("cn.audit.log.url", "http://localhost:8983/solr4/cn-audit/");
    private static CommonsHttpSolrServer server = null;

    @Override
    public boolean logAuditEvent(AuditLogEntry logEntry) {
        boolean success = false;
        try {
            server.addBean((Object)logEntry);
            server.commit();
            success = true;
        }
        catch (SolrServerException e) {
            log.error((Object)("exception attempting to ADD audit event: " + (Object)((Object)logEntry.getEvent()) + " for pid: " + logEntry.getPid() + " and node: " + logEntry.getNodeId() + " to audit log"), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("exception attempting to ADD audit event: " + (Object)((Object)logEntry.getEvent()) + " for pid: " + logEntry.getPid() + " and node: " + logEntry.getNodeId() + " to audit log"), (Throwable)e);
        }
        return success;
    }

    @Override
    public String queryLog(String query, Integer start, Integer rows) {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQuery(query);
        solrQuery.setStart(start);
        solrQuery.setRows(rows);
        String returnVal = "";
        try {
            QueryResponse response = server.query((SolrParams)solrQuery);
            returnVal = response.toString();
        }
        catch (SolrServerException e) {
            log.error((Object)"exception querying audit log", (Throwable)e);
        }
        return returnVal;
    }

    @Override
    public String queryLog(AuditLogEntry logEntry, Integer start, Integer rows) {
        if (logEntry == null) {
            return "";
        }
        String queryString = this.createIntersectionQueryString(logEntry);
        if (queryString.isEmpty()) {
            return "";
        }
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQuery(queryString);
        solrQuery.setStart(start);
        solrQuery.setRows(rows);
        String returnVal = "";
        try {
            QueryResponse response = server.query((SolrParams)solrQuery);
            returnVal = response.toString();
        }
        catch (SolrServerException e) {
            log.error((Object)"exception querying audit log", (Throwable)e);
        }
        return returnVal;
    }

    @Override
    public boolean removeReplicaAuditEvent(AuditLogEntry logEntry) {
        if (logEntry == null) {
            return true;
        }
        String deleteQuery = this.createIntersectionQueryString(logEntry);
        if (deleteQuery.isEmpty()) {
            return true;
        }
        boolean success = false;
        try {
            server.deleteByQuery(deleteQuery);
            server.commit();
            success = true;
        }
        catch (SolrServerException e) {
            log.error((Object)("exception attempting to DELETE audit event: " + (Object)((Object)logEntry.getEvent()) + " for pid: " + logEntry.getPid() + " and node: " + logEntry.getNodeId() + " to audit log"), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("exception attempting to DELETE audit event: " + (Object)((Object)logEntry.getEvent()) + " for pid: " + logEntry.getPid() + " and node: " + logEntry.getNodeId() + " to audit log"), (Throwable)e);
        }
        return success;
    }

    private String createIntersectionQueryString(AuditLogEntry logEntry) {
        ArrayList<String> fields = new ArrayList<String>();
        if (logEntry.getPid() != null) {
            fields.add("pid:" + ClientUtils.escapeQueryChars((String)logEntry.getPid()));
        }
        if (logEntry.getNodeId() != null) {
            fields.add("nodeId:" + ClientUtils.escapeQueryChars((String)logEntry.getNodeId()));
        }
        if (logEntry.getEvent() != null) {
            fields.add("event:" + ClientUtils.escapeQueryChars((String)logEntry.getEvent().toString()));
        }
        StringBuffer queryString = new StringBuffer();
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            String field = (String)iterator.next();
            queryString.append(field);
            if (!iterator.hasNext()) continue;
            queryString.append(" AND ");
        }
        return queryString.toString();
    }

    public static void main(String[] args) throws InterruptedException {
        AuditLogClient alc = AuditLogClientFactory.getAuditLogClient();
        System.out.println(alc.queryLog("*:*", null, (Integer)0));
        AuditLogEntry rale = new AuditLogEntry("test-pid-1", "urn:node:the616", AuditEvent.REPLICA_AUDIT_FAILED, "audit failed!");
        alc.logAuditEvent(rale);
        Thread.sleep(2000L);
        System.out.println(alc.queryLog("*:*", null, (Integer)0));
    }

    static {
        try {
            server = new CommonsHttpSolrServer(AUDIT_LOG_URL);
        }
        catch (MalformedURLException e) {
            log.error((Object)"Exception attempting to create common solr server", (Throwable)e);
        }
    }
}

