/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.PSystem;
import net.sourceforge.plantuml.Pragma;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.code.CompressionZlib;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.pdf.PdfConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UmlDiagram
extends AbstractPSystem
implements PSystem {
    private boolean rotation;
    private boolean hideUnlinkedData;
    private int minwidth = Integer.MAX_VALUE;
    private List<String> title;
    private List<String> header;
    private List<String> footer;
    private HorizontalAlignement headerAlignement = HorizontalAlignement.RIGHT;
    private HorizontalAlignement footerAlignement = HorizontalAlignement.CENTER;
    private final Pragma pragma = new Pragma();
    private Scale scale;
    private final SkinParam skinParam = new SkinParam();

    public final void setTitle(List<String> list) {
        this.title = list;
    }

    @Override
    public final List<String> getTitle() {
        return this.title;
    }

    public final int getMinwidth() {
        return this.minwidth;
    }

    public final void setMinwidth(int n) {
        this.minwidth = n;
    }

    public final boolean isRotation() {
        return this.rotation;
    }

    public final void setRotation(boolean bl) {
        this.rotation = bl;
    }

    public final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public void setParam(String string, String string2) {
        this.skinParam.setParam(string.toLowerCase(), string2);
    }

    public final List<String> getHeader() {
        return this.header;
    }

    public final void setHeader(List<String> list) {
        this.header = list;
    }

    public final List<String> getFooter() {
        return this.footer;
    }

    public final void setFooter(List<String> list) {
        this.footer = list;
    }

    public final HorizontalAlignement getHeaderAlignement() {
        return this.headerAlignement;
    }

    public final void setHeaderAlignement(HorizontalAlignement horizontalAlignement) {
        this.headerAlignement = horizontalAlignement;
    }

    public final HorizontalAlignement getFooterAlignement() {
        return this.footerAlignement;
    }

    public final void setFooterAlignement(HorizontalAlignement horizontalAlignement) {
        this.footerAlignement = horizontalAlignement;
    }

    public abstract UmlDiagramType getUmlDiagramType();

    public Pragma getPragma() {
        return this.pragma;
    }

    public final void setScale(Scale scale) {
        this.scale = scale;
    }

    public final Scale getScale() {
        return this.scale;
    }

    public final double getDpiFactor(FileFormatOption fileFormatOption) {
        if (this.getSkinParam().getDpi() == 96) {
            return 1.0;
        }
        return (double)this.getSkinParam().getDpi() / 96.0;
    }

    public final int getDpi(FileFormatOption fileFormatOption) {
        return this.getSkinParam().getDpi();
    }

    public final boolean isHideUnlinkedData() {
        return this.hideUnlinkedData;
    }

    public final void setHideUnlinkedData(boolean bl) {
        this.hideUnlinkedData = bl;
    }

    @Override
    public final void exportDiagram(OutputStream outputStream, StringBuilder stringBuilder, int n, FileFormatOption fileFormatOption) throws IOException {
        List<BufferedImage> list = null;
        try {
            if ("split".equalsIgnoreCase(this.getSkinParam().getValue("flashcode")) && fileFormatOption.getFileFormat() == FileFormat.PNG) {
                String string = this.getSource().getPlainString();
                list = this.exportSplitCompress(string);
            } else if ("compress".equalsIgnoreCase(this.getSkinParam().getValue("flashcode")) && fileFormatOption.getFileFormat() == FileFormat.PNG) {
                String string = this.getSource().getPlainString();
                list = this.exportFlashcodeCompress(string);
            } else if (this.getSkinParam().getValue("flashcode") != null && fileFormatOption.getFileFormat() == FileFormat.PNG) {
                String string = this.getSource().getPlainString();
                list = this.exportFlashcodeSimple(string);
            }
        }
        catch (WriterException writerException) {
            Log.error("Cannot generate flashcode");
            writerException.printStackTrace();
            list = null;
        }
        if (fileFormatOption.getFileFormat() == FileFormat.PDF) {
            this.exportDiagramInternalPdf(outputStream, stringBuilder, n, list);
            return;
        }
        this.exportDiagramInternal(outputStream, stringBuilder, n, fileFormatOption, list);
    }

    private void exportDiagramInternalPdf(OutputStream outputStream, StringBuilder stringBuilder, int n, List<BufferedImage> list) throws IOException {
        File file = FileUtils.createTempFile("pdf", ".svf");
        File file2 = FileUtils.createTempFile("pdf", ".pdf");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        this.exportDiagram(bufferedOutputStream, stringBuilder, n, new FileFormatOption(FileFormat.SVG));
        ((OutputStream)bufferedOutputStream).close();
        PdfConverter.convert(file, file2);
        FileUtils.copyToStream(file2, outputStream);
    }

    protected abstract void exportDiagramInternal(OutputStream var1, StringBuilder var2, int var3, FileFormatOption var4, List<BufferedImage> var5) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void exportCmap(File file, StringBuilder stringBuilder) throws FileNotFoundException {
        File file2 = new File(UmlDiagram.changeName(file.getAbsolutePath()));
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(file2);
            printWriter.print(stringBuilder.toString());
            printWriter.close();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    static String changeName(String string) {
        return string.replaceAll("(?i)\\.\\w{3}$", ".cmapx");
    }

    private List<BufferedImage> exportFlashcodeSimple(String string) throws IOException, WriterException {
        QRCodeWriter qRCodeWriter = new QRCodeWriter();
        Hashtable<EncodeHintType, ErrorCorrectionLevel> hashtable = new Hashtable<EncodeHintType, ErrorCorrectionLevel>();
        hashtable.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        BitMatrix bitMatrix = qRCodeWriter.encode(string, BarcodeFormat.QR_CODE, 1);
        BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage(bitMatrix);
        return Arrays.asList(bufferedImage);
    }

    private List<BufferedImage> exportFlashcodeCompress(String string) throws IOException, WriterException {
        QRCodeWriter qRCodeWriter = new QRCodeWriter();
        Hashtable<EncodeHintType, ErrorCorrectionLevel> hashtable = new Hashtable<EncodeHintType, ErrorCorrectionLevel>();
        hashtable.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        CompressionZlib compressionZlib = new CompressionZlib();
        byte[] byArray = compressionZlib.compress(string.getBytes("UTF-8"));
        BitMatrix bitMatrix = qRCodeWriter.encode(new String(byArray, "ISO-8859-1"), BarcodeFormat.QR_CODE, 1);
        BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage(bitMatrix);
        return Arrays.asList(bufferedImage);
    }

    private List<BufferedImage> exportSplitCompress(String string) throws IOException, WriterException {
        QRCodeWriter qRCodeWriter = new QRCodeWriter();
        Hashtable<EncodeHintType, ErrorCorrectionLevel> hashtable = new Hashtable<EncodeHintType, ErrorCorrectionLevel>();
        hashtable.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        CompressionZlib compressionZlib = new CompressionZlib();
        byte[] byArray = compressionZlib.compress(string.getBytes("UTF-8"));
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        for (int i = 0; i < 4; ++i) {
            arrayList2.add(UmlDiagram.getSplited(byArray, i, 4));
        }
        arrayList2.add(UmlDiagram.xor(arrayList2));
        for (byte[] byArray2 : arrayList2) {
            BitMatrix bitMatrix = qRCodeWriter.encode(new String(byArray2, "ISO-8859-1"), BarcodeFormat.QR_CODE, 1);
            arrayList.add(MatrixToImageWriter.toBufferedImage(bitMatrix));
        }
        return Collections.unmodifiableList(arrayList);
    }

    static byte[] xor(List<byte[]> list) {
        byte[] byArray = new byte[list.get(0).length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = UmlDiagram.xor(list, i);
        }
        return byArray;
    }

    static byte xor(List<byte[]> list, int n) {
        byte by = 0;
        for (byte[] byArray : list) {
            by = (byte)(by ^ byArray[n]);
        }
        return by;
    }

    static byte[] getSplited(byte[] byArray, int n, int n2) {
        int n3 = (byArray.length + n2 - 1) / n2;
        assert (n3 * n2 >= byArray.length);
        byte[] byArray2 = new byte[n3 + 1];
        byArray2[0] = (byte)(1 << n);
        for (int i = 0; i < n3 && n * n2 + i < byArray.length; ++i) {
            byArray2[i + 1] = byArray[n * n2 + i];
        }
        return byArray2;
    }
}

