/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.dot.DrawFile;
import net.sourceforge.plantuml.cucadiagram.dot.StaticFiles;

public class StaticFilesMap {
    private final Map<String, StaticFiles> map = new HashMap<String, StaticFiles>();
    private final ISkinParam param;
    private final double dpiFactor;

    public StaticFilesMap(ISkinParam iSkinParam, double d) {
        this.param = iSkinParam;
        this.dpiFactor = d;
    }

    public StaticFiles getStaticFiles(String string) throws IOException {
        StaticFiles staticFiles = this.map.get(string);
        if (staticFiles == null) {
            staticFiles = new StaticFiles(this.param, string, this.dpiFactor);
            this.map.put(string, staticFiles);
        }
        return staticFiles;
    }

    public DrawFile getDrawFile(String string) throws IOException {
        for (StaticFiles staticFiles : this.map.values()) {
            DrawFile drawFile = staticFiles.getDrawFile(string);
            if (drawFile == null) continue;
            return drawFile;
        }
        return null;
    }

    public void clean() {
        for (StaticFiles staticFiles : this.map.values()) {
            staticFiles.clean();
        }
    }
}

