/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graph.MethodsOrFieldsArea;
import net.sourceforge.plantuml.graphic.CircledCharacter;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;

class EntityImageClass
extends AbstractEntityImage {
    private final TextBlock name;
    private final MethodsOrFieldsArea methods;
    private final MethodsOrFieldsArea fields;
    private final CircledCharacter circledCharacter;
    private final int xMargin = 10;
    private final int yMargin = 6;

    public EntityImageClass(Entity entity) {
        super(entity);
        this.name = TextBlockUtils.create(StringUtils.getWithNewlines(entity.getDisplay()), new FontConfiguration(this.getFont14(), HtmlColor.BLACK), HorizontalAlignement.CENTER);
        this.methods = new MethodsOrFieldsArea(entity.getMethodsToDisplay(), this.getFont14());
        this.fields = new MethodsOrFieldsArea(entity.getFieldsToDisplay(), this.getFont14());
        this.circledCharacter = this.getCircledCharacter(entity);
    }

    private CircledCharacter getCircledCharacter(Entity entity) {
        if (entity.getType() == EntityType.ABSTRACT_CLASS) {
            return new CircledCharacter('A', 10.0, this.getFont17(), this.getBlue(), this.getRed(), HtmlColor.BLACK);
        }
        if (entity.getType() == EntityType.CLASS) {
            return new CircledCharacter('C', 10.0, this.getFont17(), this.getGreen(), this.getRed(), HtmlColor.BLACK);
        }
        if (entity.getType() == EntityType.INTERFACE) {
            return new CircledCharacter('I', 10.0, this.getFont17(), this.getViolet(), this.getRed(), HtmlColor.BLACK);
        }
        if (entity.getType() == EntityType.ENUM) {
            return new CircledCharacter('E', 10.0, this.getFont17(), this.getRose(), this.getRed(), HtmlColor.BLACK);
        }
        assert (false);
        return null;
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.getNameDimension(stringBounder);
        Dimension2D dimension2D2 = this.methods.calculateDimension(stringBounder);
        Dimension2D dimension2D3 = this.fields.calculateDimension(stringBounder);
        double d = Math.max(Math.max(dimension2D2.getWidth(), dimension2D3.getWidth()), dimension2D.getWidth()) + 20.0;
        double d2 = dimension2D2.getHeight() + dimension2D3.getHeight() + dimension2D.getHeight() + 36.0;
        return new Dimension2DDouble(d, d2);
    }

    private Dimension2D getNameDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.name.calculateDimension(stringBounder);
        if (this.circledCharacter == null) {
            return dimension2D;
        }
        return new Dimension2DDouble(dimension2D.getWidth() + this.getCircledWidth(stringBounder), Math.max(dimension2D.getHeight(), this.circledCharacter.getPreferredHeight(stringBounder)));
    }

    private double getCircledWidth(StringBounder stringBounder) {
        if (this.circledCharacter == null) {
            return 0.0;
        }
        return this.circledCharacter.getPreferredWidth(stringBounder) + 3.0;
    }

    public void draw(ColorMapper colorMapper, Graphics2D graphics2D) {
        Dimension2D dimension2D = this.getDimension(StringBounderUtils.asStringBounder(graphics2D));
        Dimension2D dimension2D2 = this.getNameDimension(StringBounderUtils.asStringBounder(graphics2D));
        Dimension2D dimension2D3 = this.fields.calculateDimension(StringBounderUtils.asStringBounder(graphics2D));
        int n = (int)dimension2D.getWidth();
        int n2 = (int)dimension2D.getHeight();
        graphics2D.setColor(colorMapper.getMappedColor(this.getYellow()));
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setColor(colorMapper.getMappedColor(this.getRed()));
        graphics2D.drawRect(0, 0, n - 1, n2 - 1);
        double d = dimension2D2.getHeight() + 12.0;
        double d2 = dimension2D2.getHeight() + dimension2D3.getHeight() + 24.0;
        graphics2D.drawLine(0, (int)d, n, (int)d);
        graphics2D.drawLine(0, (int)d2, n, (int)d2);
        double d3 = this.getCircledWidth(StringBounderUtils.asStringBounder(graphics2D));
        graphics2D.setColor(Color.BLACK);
        this.name.drawTOBEREMOVED(colorMapper, graphics2D, 10.0 + d3, 6.0);
        this.fields.drawTOBEREMOVED(colorMapper, graphics2D, 10.0, d + 6.0);
        this.methods.drawTOBEREMOVED(colorMapper, graphics2D, 10.0, d2 + 6.0);
        if (this.circledCharacter != null) {
            this.circledCharacter.draw(new ColorMapperIdentity(), graphics2D, 10, 6, 1.0);
        }
    }
}

