/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapper;

class EntityImageComponent
extends AbstractEntityImage {
    private final TextBlock name;
    private final float thickness = 1.6f;

    public EntityImageComponent(Entity entity) {
        super(entity);
        this.name = TextBlockUtils.create(StringUtils.getWithNewlines(entity.getDisplay()), new FontConfiguration(this.getFont14(), HtmlColor.BLACK), HorizontalAlignement.CENTER);
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.name.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(dimension2D, 20.0, 14.0);
    }

    private void drawRect(ColorMapper colorMapper, Graphics2D graphics2D, double d, double d2, double d3, double d4) {
        graphics2D.setStroke(new BasicStroke(1.6f));
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        graphics2D.setColor(colorMapper.getMappedColor(this.getYellow()));
        graphics2D.fill(double_);
        graphics2D.setColor(colorMapper.getMappedColor(this.getRed()));
        graphics2D.draw(double_);
        graphics2D.setStroke(new BasicStroke());
    }

    public void draw(ColorMapper colorMapper, Graphics2D graphics2D) {
        Dimension2D dimension2D = this.getDimension(StringBounderUtils.asStringBounder(graphics2D));
        Dimension2D dimension2D2 = this.name.calculateDimension(StringBounderUtils.asStringBounder(graphics2D));
        this.drawRect(colorMapper, graphics2D, 6.0, 0.0, dimension2D.getWidth(), dimension2D.getHeight());
        this.drawRect(colorMapper, graphics2D, 0.0, 7.0, 12.0, 6.0);
        this.drawRect(colorMapper, graphics2D, 0.0, dimension2D.getHeight() - 7.0 - 6.0, 12.0, 6.0);
        graphics2D.setColor(Color.BLACK);
        this.name.drawTOBEREMOVED(colorMapper, graphics2D, 6.0 + (dimension2D.getWidth() - dimension2D2.getWidth()) / 2.0, (dimension2D.getHeight() - dimension2D2.getHeight()) / 2.0);
    }
}

