/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.AbstractCollection;
import java.util.EnumSet;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.ugraphic.UFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontConfiguration {
    private final EnumSet<FontStyle> styles;
    private final UFont currentFont;
    private final UFont motherFont;
    private final HtmlColor motherColor;
    private final HtmlColor currentColor;
    private final HtmlColor extendedColor;

    public FontConfiguration(UFont uFont, HtmlColor htmlColor) {
        this(EnumSet.noneOf(FontStyle.class), uFont, htmlColor, uFont, htmlColor, null);
    }

    public String toString() {
        return this.styles.toString() + " " + this.currentColor;
    }

    private FontConfiguration(EnumSet<FontStyle> enumSet, UFont uFont, HtmlColor htmlColor, UFont uFont2, HtmlColor htmlColor2, HtmlColor htmlColor3) {
        this.styles = enumSet;
        this.currentFont = uFont2;
        this.motherFont = uFont;
        this.currentColor = htmlColor2;
        this.motherColor = htmlColor;
        this.extendedColor = htmlColor3;
    }

    FontConfiguration changeColor(HtmlColor htmlColor) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, htmlColor, this.extendedColor);
    }

    FontConfiguration changeExtendedColor(HtmlColor htmlColor) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, this.currentColor, htmlColor);
    }

    FontConfiguration changeSize(float f) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont.deriveSize(f), this.currentColor, this.extendedColor);
    }

    public FontConfiguration resetFont() {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.motherFont, this.motherColor, null);
    }

    FontConfiguration add(FontStyle fontStyle) {
        Object object = this.styles.clone();
        ((AbstractCollection)object).add(fontStyle);
        return new FontConfiguration((EnumSet<FontStyle>)object, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor);
    }

    FontConfiguration remove(FontStyle fontStyle) {
        Object object = this.styles.clone();
        ((AbstractCollection)object).remove((Object)fontStyle);
        return new FontConfiguration((EnumSet<FontStyle>)object, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor);
    }

    public UFont getFont() {
        UFont uFont = this.currentFont;
        for (FontStyle fontStyle : this.styles) {
            uFont = fontStyle.mutateFont(uFont);
        }
        return uFont;
    }

    public HtmlColor getColor() {
        return this.currentColor;
    }

    public HtmlColor getExtendedColor() {
        return this.extendedColor;
    }

    public boolean containsStyle(FontStyle fontStyle) {
        return this.styles.contains((Object)fontStyle);
    }
}

