/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicStrings {
    private final HtmlColor background;
    private final UFont font;
    private final HtmlColor green;
    private final List<String> strings;
    private final BufferedImage image;
    private final GraphicPosition position;
    private final boolean disableTextAliasing;
    private final ColorMapper colorMapper = new ColorMapperIdentity();

    public GraphicStrings(List<String> list) {
        this(list, new UFont("SansSerif", 1, 14), HtmlColor.getColorIfValid("#33FF02"), HtmlColor.BLACK, null, null, false);
    }

    public GraphicStrings(List<String> list, BufferedImage bufferedImage) {
        this(list, new UFont("SansSerif", 1, 14), HtmlColor.getColorIfValid("#33FF02"), HtmlColor.BLACK, bufferedImage, null, false);
    }

    public GraphicStrings(List<String> list, UFont uFont, HtmlColor htmlColor, HtmlColor htmlColor2, boolean bl) {
        this(list, uFont, htmlColor, htmlColor2, null, null, bl);
    }

    public GraphicStrings(List<String> list, UFont uFont, HtmlColor htmlColor, HtmlColor htmlColor2, BufferedImage bufferedImage, GraphicPosition graphicPosition, boolean bl) {
        this.strings = list;
        this.font = uFont;
        this.green = htmlColor;
        this.background = htmlColor2;
        this.image = bufferedImage;
        this.position = graphicPosition;
        this.disableTextAliasing = bl;
    }

    public void writeImage(OutputStream outputStream, FileFormatOption fileFormatOption) throws IOException {
        this.writeImage(outputStream, null, fileFormatOption);
    }

    public void writeImage(OutputStream outputStream, String string, FileFormatOption fileFormatOption) throws IOException {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.PNG) {
            BufferedImage bufferedImage = this.createImage();
            PngIO.write((RenderedImage)bufferedImage, outputStream, string, 96);
        } else if (fileFormat == FileFormat.SVG) {
            UGraphicSvg uGraphicSvg = new UGraphicSvg(this.colorMapper, StringUtils.getAsHtml(this.colorMapper.getMappedColor(this.background)), false);
            this.drawU(uGraphicSvg);
            uGraphicSvg.createXml(outputStream);
        } else if (fileFormat == FileFormat.ATXT || fileFormat == FileFormat.UTXT) {
            UGraphicTxt uGraphicTxt = new UGraphicTxt();
            this.drawU(uGraphicTxt);
            uGraphicTxt.getCharArea().print(new PrintStream(outputStream));
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private BufferedImage createImage() {
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(10, 10, this.colorMapper.getMappedColor(this.background));
        Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
        Dimension2D dimension2D = this.drawU(new UGraphicG2d(this.colorMapper, graphics2D, null, 1.0));
        graphics2D.dispose();
        emptyImageBuilder = new EmptyImageBuilder(dimension2D.getWidth(), dimension2D.getHeight(), this.colorMapper.getMappedColor(this.background));
        BufferedImage bufferedImage = emptyImageBuilder.getBufferedImage();
        graphics2D = emptyImageBuilder.getGraphics2D();
        if (this.disableTextAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.drawU(new UGraphicG2d(this.colorMapper, graphics2D, null, 1.0));
        graphics2D.dispose();
        return bufferedImage;
    }

    public Dimension2D drawU(UGraphic uGraphic) {
        TextBlock textBlock = TextBlockUtils.create(this.strings, new FontConfiguration(this.font, this.green), HorizontalAlignement.LEFT);
        Dimension2D dimension2D = textBlock.calculateDimension(uGraphic.getStringBounder());
        textBlock.drawU(uGraphic, 0.0, 0.0);
        if (this.image != null) {
            if (this.position == GraphicPosition.BOTTOM) {
                uGraphic.draw((dimension2D.getWidth() - (double)this.image.getWidth()) / 2.0, dimension2D.getHeight(), new UImage(this.image));
                dimension2D = new Dimension2DDouble(dimension2D.getWidth(), dimension2D.getHeight() + (double)this.image.getHeight());
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER) {
                uGraphic.draw(dimension2D.getWidth() - (double)this.image.getWidth(), dimension2D.getHeight() - (double)this.image.getHeight(), new UImage(this.image));
            }
        }
        return dimension2D;
    }
}

