/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.skin.ArrowConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessage
implements Event {
    private final List<String> label;
    private final ArrowConfiguration arrowConfiguration;
    private final List<LifeEvent> lifeEvents = new ArrayList<LifeEvent>();
    private List<? extends CharSequence> notes;
    private NotePosition notePosition;
    private HtmlColor noteBackColor;
    private Url urlNote;
    private final String messageNumber;

    public AbstractMessage(List<String> list, ArrowConfiguration arrowConfiguration, String string) {
        this.label = list;
        this.arrowConfiguration = arrowConfiguration;
        this.messageNumber = string;
    }

    public final void addLifeEvent(LifeEvent lifeEvent) {
        this.lifeEvents.add(lifeEvent);
    }

    public final boolean isCreate() {
        for (LifeEvent lifeEvent : this.lifeEvents) {
            if (lifeEvent.getType() != LifeEventType.CREATE) continue;
            return true;
        }
        return false;
    }

    public final boolean isActivateAndDeactive() {
        if (this.lifeEvents.size() < 2) {
            return false;
        }
        return this.lifeEvents.get(0).getType() == LifeEventType.ACTIVATE && (this.lifeEvents.get(1).getType() == LifeEventType.DEACTIVATE || this.lifeEvents.get(1).getType() == LifeEventType.DESTROY);
    }

    public final List<LifeEvent> getLiveEvents() {
        return Collections.unmodifiableList(this.lifeEvents);
    }

    public final List<String> getLabel() {
        return Collections.unmodifiableList(this.label);
    }

    public final ArrowConfiguration getArrowConfiguration() {
        return this.arrowConfiguration;
    }

    public final List<? extends CharSequence> getNote() {
        return this.notes == null ? this.notes : Collections.unmodifiableList(this.notes);
    }

    public final Url getUrlNote() {
        return this.urlNote;
    }

    public final void setNote(List<? extends CharSequence> list, NotePosition notePosition, String string, Url url) {
        if (notePosition != NotePosition.LEFT && notePosition != NotePosition.RIGHT) {
            throw new IllegalArgumentException();
        }
        this.notes = list;
        this.urlNote = url;
        this.notePosition = notePosition;
        this.noteBackColor = HtmlColor.getColorIfValid(string);
    }

    public final HtmlColor getSpecificBackColor() {
        return this.noteBackColor;
    }

    public final NotePosition getNotePosition() {
        return this.notePosition;
    }

    public final String getMessageNumber() {
        return this.messageNumber;
    }
}

