/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandNoteOverSeveral
extends SingleLineCommand<SequenceDiagram> {
    public CommandNoteOverSeveral(SequenceDiagram sequenceDiagram) {
        super(sequenceDiagram, "(?i)^note\\s+over\\s+([\\p{L}0-9_.]+|\"[^\"]+\")\\s*\\,\\s*([\\p{L}0-9_.]+|\"[^\"]+\")\\s*(#\\w+)?\\s*:\\s*(.*)$");
    }

    @Override
    protected CommandExecutionResult executeArg(List<String> list) {
        Participant participant = ((SequenceDiagram)this.getSystem()).getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(list.get(0)));
        Participant participant2 = ((SequenceDiagram)this.getSystem()).getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(list.get(1)));
        List<String> list2 = StringUtils.getWithNewlines(list.get(3));
        Note note = new Note(participant, participant2, list2);
        note.setSpecificBackcolor(HtmlColor.getColorIfValid(list.get(2)));
        ((SequenceDiagram)this.getSystem()).addNote(note);
        return CommandExecutionResult.ok();
    }
}

