/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ditaa;

import java.io.UnsupportedEncodingException;
import net.sourceforge.plantuml.DiagramType;
import net.sourceforge.plantuml.PSystemBasicFactory;
import net.sourceforge.plantuml.ditaa.PSystemDitaa;

public class PSystemDitaaFactory
implements PSystemBasicFactory {
    private StringBuilder data;
    private boolean first;
    private final DiagramType diagramType;

    public PSystemDitaaFactory(DiagramType diagramType) {
        this.diagramType = diagramType;
    }

    public void init() {
        this.data = null;
        if (this.diagramType == DiagramType.UML) {
            this.first = true;
        } else if (this.diagramType == DiagramType.DITAA) {
            this.first = false;
            this.data = new StringBuilder();
        } else {
            throw new IllegalStateException(this.diagramType.name());
        }
    }

    public boolean executeLine(String string) {
        if (this.first && string.equals("ditaa")) {
            this.data = new StringBuilder();
            return true;
        }
        this.first = false;
        if (this.data == null) {
            return false;
        }
        this.data.append(string);
        this.data.append("\n");
        return true;
    }

    public PSystemDitaa getSystem() {
        try {
            return new PSystemDitaa(this.data.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    public DiagramType getDiagramType() {
        return this.diagramType;
    }
}

